# Code generated by TRAC

from __future__ import annotations
import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa
from .data import *  # noqa



@_dc.dataclass
class ModelParameter:

    """Describes an individual parameter of a model"""

    paramType: TypeDescriptor = None

    label: str = None

    defaultValue: _tp.Optional[Value] = None


@_dc.dataclass
class ModelInputSchema:

    """
    Describes the data schema of a model input
    
    In many cases models define the entire schemas of their inputs, in which case the input
    schema is just a wrapper around a schema definition. This is what is supported now.
    
    Other approaches are possible. Models can define dynamic inputs, in which case the input
    schema is provided at runtime and can be interrogated by the model code. Models may also
    define inputs with some required fields and a dynamic portion. For non-tabular inputs,
    other options may be required. These capabilities may be added in future releases.
    """

    schema: SchemaDefinition = None

    label: _tp.Optional[str] = None


@_dc.dataclass
class ModelOutputSchema:

    """
    Describes the data schema of a model output
    
    In many cases models define the entire schemas of their outputs, in which case the output
    schema is just a wrapper around a schema definition. This is what is supported now.
    
    Other approaches are possible. Models can define dynamic outputs, in which case the model
    decides at runtime what the output schema will be. Pass-through schemas (output X has the
    same schema as dynamic input Y) and pass-through-extend schemas (output X has the schema of
    dynamic input Y, plus one or more new columns) can also be useful. These capabilities may be
    added in future releases.
    """

    schema: SchemaDefinition = None

    label: _tp.Optional[str] = None


@_dc.dataclass
class ModelDefinition:

    """Define a model for execution on the TRAC platform"""

    language: str = None

    repository: str = None

    packageGroup: _tp.Optional[str] = None

    package: str = None

    version: str = None

    entryPoint: str = None

    path: _tp.Optional[str] = None

    parameters: _tp.Dict[str, ModelParameter] = _dc.field(default_factory=dict)

    inputs: _tp.Dict[str, ModelInputSchema] = _dc.field(default_factory=dict)

    outputs: _tp.Dict[str, ModelOutputSchema] = _dc.field(default_factory=dict)

    staticAttributes: _tp.Dict[str, Value] = _dc.field(default_factory=dict)

    """Static attributes defined in model code"""
