# Code generated by TRAC

from __future__ import annotations
import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .type import *  # noqa
from .object_id import *  # noqa
from .tag_update import *  # noqa


class JobType(_enum.Enum):

    JOB_TYPE_NOT_SET = 0, 

    RUN_MODEL = 1, 

    RUN_FLOW = 2, 

    IMPORT_MODEL = 3, 

    IMPORT_DATA = 4, 


class JobStatusCode(_enum.Enum):

    JOB_STATUS_CODE_NOT_SET = 0, 

    PREPARING = 1, 

    VALIDATED = 2, 

    PENDING = 3, 

    QUEUED = 4, 

    SUBMITTED = 5, 

    RUNNING = 6, 

    FINISHING = 7, 

    SUCCEEDED = 8, 

    FAILED = 9, 

    CANCELLED = 10, 


@_dc.dataclass
class JobDefinition:

    jobType: JobType = JobType.JOB_TYPE_NOT_SET

    runModel: _tp.Optional[RunModelJob] = None

    runFlow: _tp.Optional[RunFlowJob] = None

    importModel: _tp.Optional[ImportModelJob] = None


@_dc.dataclass
class RunModelJob:

    model: TagSelector = None

    parameters: _tp.Dict[str, Value] = _dc.field(default_factory=dict)

    inputs: _tp.Dict[str, TagSelector] = _dc.field(default_factory=dict)

    outputs: _tp.Dict[str, TagSelector] = _dc.field(default_factory=dict)

    priorOutputs: _tp.Dict[str, TagSelector] = _dc.field(default_factory=dict)

    outputAttrs: _tp.List[TagUpdate] = _dc.field(default_factory=list)


@_dc.dataclass
class RunFlowJob:

    flow: TagSelector = None

    parameters: _tp.Dict[str, Value] = _dc.field(default_factory=dict)

    inputs: _tp.Dict[str, TagSelector] = _dc.field(default_factory=dict)

    outputs: _tp.Dict[str, TagSelector] = _dc.field(default_factory=dict)

    priorOutputs: _tp.Dict[str, TagSelector] = _dc.field(default_factory=dict)

    models: _tp.Dict[str, TagSelector] = _dc.field(default_factory=dict)

    outputAttrs: _tp.List[TagUpdate] = _dc.field(default_factory=list)


@_dc.dataclass
class ImportModelJob:

    language: str = None

    repository: str = None

    packageGroup: _tp.Optional[str] = None

    package: str = None

    version: str = None

    entryPoint: str = None

    path: str = None

    modelAttrs: _tp.List[TagUpdate] = _dc.field(default_factory=list)
