# Code generated by TRAC

from __future__ import annotations
import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

class MetadataFormat(_enum.Enum):

    """
    Available formats for representing the TRAC metadata.
    
    Use for communication between components, config files
    metadata stored in the metadata database.
    """

    METADATA_FORMAT_NOT_SET = 0, 

    PROTO = 1, 

    JSON = 2, 

    YAML = 3, 


class MetadataVersion(_enum.Enum):

    """
    Explicit versioning of the metadata schema.
    
    A strictly increasing enumeration of metadata versions.
    The special value CURRENT is always set to the latest version and used by default,
    in API calls, config files and for storing in the metadata database.
    
    TRAC can use this information identify and handle old metadata found in the metadata database.
    In future it may also be possible to request old metadata versions in API calls,
    or to run upgrades of metadata stored in an older metadata format.
    """

    METADATA_VERSION_NOT_SET = 0, 

    V1 = 1, 

    CURRENT = 1, 


@_dc.dataclass
class TenantInfo:

    """Information about a tenant that is set up on the TRAC platform."""

    tenantCode: str = None

    """* Unique code used to identify the tenant, required by most API calls."""

    description: str = None

    """* A short description of the tenant, suitable for displaying to users in lists."""
