# Code generated by TRAC

from __future__ import annotations
import typing as _tp  # noqa
import dataclasses as _dc  # noqa
import enum as _enum  # noqa

from .common import *  # noqa


class GwProtocol(_enum.Enum):

    PROTOCOL_NOT_SET = 0, 

    HTTP = 1, 

    GRPC = 2, 

    GRPC_WEB = 3, 

    REST = 4, 


class GwRestMapping(_enum.Enum):

    REST_MAPPING_NOT_SET = 0, 

    TRAC_META = 1, 

    TRAC_DATA = 2, 

    TRAC_ORCH = 3, 


@_dc.dataclass
class GatewayConfig:

    config: _tp.Dict[str, str] = _dc.field(default_factory=dict)

    platformInfo: PlatformInfo = None

    authentication: AuthenticationConfig = None

    routes: _tp.List[GwRoute] = _dc.field(default_factory=list)

    services: GwServiceMap = None

    port: int = None

    idleTimeout: int = None


@_dc.dataclass
class GwRoute:

    routeName: str = None

    routeType: GwProtocol = GwProtocol.PROTOCOL_NOT_SET

    protocols: _tp.List[GwProtocol] = _dc.field(default_factory=list)

    restMapping: GwRestMapping = GwRestMapping.REST_MAPPING_NOT_SET

    match: GwMatch = None

    target: GwTarget = None


@_dc.dataclass
class GwMatch:

    host: str = None

    path: str = None


@_dc.dataclass
class GwTarget:

    scheme: str = None

    host: str = None

    port: int = None

    path: str = None


@_dc.dataclass
class GwServiceMap:

    meta: GwService = None

    data: GwService = None

    orch: GwService = None


@_dc.dataclass
class GwService:

    protocols: _tp.List[GwProtocol] = _dc.field(default_factory=list)

    target: GwTarget = None
