(window["webpackJsonp"] = window["webpackJsonp"] || []).push([[3],{

/***/ "./js/whyis_vue/components/pages/sparql-templates/load-sparql-templates.js":
/*!*********************************************************************************!*\
  !*** ./js/whyis_vue/components/pages/sparql-templates/load-sparql-templates.js ***!
  \*********************************************************************************/
/*! exports provided: loadSparqlTemplates, TextSegmentType, OptValueType */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"loadSparqlTemplates\", function() { return loadSparqlTemplates; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"TextSegmentType\", function() { return TextSegmentType; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"OptValueType\", function() { return OptValueType; });\n/* harmony import */ var _rdfjs_data_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @rdfjs/data-model */ \"./node_modules/@rdfjs/data-model/index.js\");\n/* harmony import */ var _rdfjs_data_model__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_rdfjs_data_model__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var rdf_literal__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! rdf-literal */ \"./node_modules/rdf-literal/index.js\");\n/* harmony import */ var rdf_literal__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(rdf_literal__WEBPACK_IMPORTED_MODULE_1__);\n/* harmony import */ var _utilities_sparql__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../utilities/sparql */ \"./js/whyis_vue/utilities/sparql.js\");\n/* harmony import */ var _load_sparql_templates_rq__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./load-sparql-templates.rq */ \"./js/whyis_vue/components/pages/sparql-templates/load-sparql-templates.rq\");\n/* harmony import */ var _utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utilities/common-namespaces */ \"./js/whyis_vue/utilities/common-namespaces.js\");\n\n\n\n\n\n\nconst SP = 'http://spinrdf.org/sp'\nconst SPIN = `${SP}in#`\n\nconst templateType = 'http://vocab.rpi.edu/whyis/SparqlTemplate'\nconst typePred = _utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"RDF\"] + 'type'\n\nasync function loadSparqlTemplates() {\n  const queryResponse = await Object(_utilities_sparql__WEBPACK_IMPORTED_MODULE_2__[\"querySparql\"])(_load_sparql_templates_rq__WEBPACK_IMPORTED_MODULE_3__[\"default\"], {accept: \"application/rdf+json\"})\n\n  // Generate map data structure of {subject: {predicate: (set of objects) }}\n  // TODO: this step could have been simplified by requesting json-ld  - \"Accept: application/ld+json'\"\n  const subjectMap = {}\n  const templateUris = []\n  queryResponse.results.bindings.forEach(b => {\n    const subject = b.subject.value\n    const predicate = b.predicate.value\n    let object = b.object.value\n    if (b.object.type === \"literal\" && b.object.datatype) {\n      object = Object(rdf_literal__WEBPACK_IMPORTED_MODULE_1__[\"fromRdf\"])(Object(_rdfjs_data_model__WEBPACK_IMPORTED_MODULE_0__[\"literal\"])(object, Object(_rdfjs_data_model__WEBPACK_IMPORTED_MODULE_0__[\"namedNode\"])(b.object.datatype)))\n    }\n\n    // Identify template uris\n    if (predicate === typePred && object === templateType) {\n      templateUris.push(subject)\n    }\n\n    let predicateMap = subjectMap[subject]\n    if (!predicateMap) {\n      predicateMap = {}\n      subjectMap[subject] = predicateMap\n    }\n    let objectSet = predicateMap[predicate]\n    if (!objectSet) {\n      objectSet = new Set()\n      predicateMap[predicate] = objectSet\n    }\n    objectSet.add(object)\n  })\n\n  // Use a recursive function to form objects from triples\n  const resolvedTemplates = templateUris.map((templateUri) => resolveUri(templateUri))\n\n  // Transform objects so that they are usable in the query templates page\n  const transformedTemplates = resolvedTemplates.map(transformTemplate)\n  transformedTemplates.sort((a, b) => a.id > b.id ? 1 : -1)\n  return transformedTemplates\n\n  function resolveUri(uri, visited) {\n    visited = visited || new Set()\n    if (visited.has(uri) || !subjectMap.hasOwnProperty(uri)) {\n      return uri\n    }\n    visited.add(uri)\n    const predMap = subjectMap[uri]\n    const obj = {uri}\n    Object.entries(predMap)\n      .forEach(([pred, values]) => {\n        const resolvedVals = [...values].map(vUri => resolveUri(vUri, visited))\n        obj[pred] = resolvedVals\n      })\n    return obj\n  }\n}\n\n/**\n * Identifies segments of display text as being variables or text\n */\nconst TextSegmentType = Object.freeze({\n  VAR: \"var\",\n  TEXT: \"text\"\n});\n\n/**\n * Enumeration of types of query parameter option values.\n */\nconst OptValueType = Object.freeze({\n  ANY: \"any\",\n  LITERAL: \"literal\",\n  IDENTIFIER: \"identifier\"\n})\n\n/**\n * Transforms rdf proto-template into a usable template\n */\nfunction transformTemplate(template) {\n  const displayText = template[`${SPIN}labelTemplate`][0]\n  return {\n    id: template.uri,\n    display: displayText,\n    displaySegments: parseDisplayText(displayText),\n    SPARQL: template[`${SP}text`][0],\n    options: transformTemplateParams(template[`${SPIN}constraint`])\n  }\n}\n\nfunction transformTemplateParams(params) {\n  return Object.fromEntries(\n    params.map(param => [\n      param[`${SP}varName`][0],\n      transformParamOpts(param[`${_utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"SCHEMA\"]}option`])\n    ])\n  )\n}\n\nfunction transformParamOpts(opts) {\n  return Object.fromEntries(\n    opts.map(opt => [\n        opt[`${_utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"RDFS\"]}label`][0],\n        getOptValue(opt),\n        opt[`${_utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"SCHEMA\"]}position`][0],\n    ])\n    .sort((e1, e2) => (e1[2] > e2[2]) ? 1: -1)\n  )\n}\n\nfunction getOptValue(opt) {\n  let value = {\n    type: OptValueType.ANY\n  }\n  if (opt[`${_utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"SCHEMA\"]}value`]) {\n    const rawVal = opt[`${_utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"SCHEMA\"]}value`]\n    value = {\n      type: OptValueType.LITERAL,\n      value: opt[`${_utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"SCHEMA\"]}value`][0]\n    }\n  } else if (opt[`${_utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"SCHEMA\"]}identifier`]) {\n    value = {\n      type: OptValueType.IDENTIFIER,\n      value: opt[`${_utilities_common_namespaces__WEBPACK_IMPORTED_MODULE_4__[\"SCHEMA\"]}identifier`][0]\n    }\n  }\n  return value\n}\n\n// Matches query variables in display text\nconst qVarRegex = /{\\?([^}]+)}/g\n// Matches query variables or the text between query variables\nconst segmentRegex = new RegExp(`${qVarRegex.source}|[^{]+`, \"g\")\n\nfunction parseDisplayText(displayText) {\n  return displayText.match(segmentRegex).map(token => {\n    let displaySegment;\n    const match = qVarRegex.exec(token)\n    if (match) {\n      displaySegment = {\n        type: TextSegmentType.VAR,\n        varName: match[1]\n      };\n    } else {\n      displaySegment = {\n        type: TextSegmentType.TEXT,\n        text: token\n      };\n    }\n    return displaySegment;\n  });\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./js/whyis_vue/components/pages/sparql-templates/load-sparql-templates.js\n");

/***/ }),

/***/ "./js/whyis_vue/components/pages/sparql-templates/load-sparql-templates.rq":
/*!*********************************************************************************!*\
  !*** ./js/whyis_vue/components/pages/sparql-templates/load-sparql-templates.rq ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__[\"default\"] = (\"PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\\nPREFIX schema: <http://schema.org/>\\nPREFIX sp: <http://spinrdf.org/sp>\\nPREFIX spin: <http://spinrdf.org/spin#>\\nPREFIX spl: <http://spinrdf.org/spin#>\\nPREFIX whyis: <http://vocab.rpi.edu/whyis/>\\nPREFIX nanomine_templates: <http://nanomine.org/query/>\\n\\nCONSTRUCT {\\n    ?template a whyis:SparqlTemplate  ;\\n        spin:labelTemplate ?labelTemplate ;\\n        sp:text ?query ;\\n        spin:constraint ?constraint .\\n    ?constraint sp:varName ?varName ;\\n        schema:option ?option .\\n    ?option rdfs:label ?optLabel ;\\n        schema:value ?optValue ;\\n        schema:identifier ?optId ;\\n        schema:position ?optPosition .\\n}\\nWHERE {\\n    ?template a whyis:SparqlTemplate  ;\\n        spin:labelTemplate ?labelTemplate ;\\n        sp:text ?query ;\\n        spin:constraint ?constraint .\\n    ?constraint sp:varName ?varName ;\\n        schema:option ?option .\\n    ?option rdfs:label ?optLabel ;\\n        schema:position ?optPosition .\\n    OPTIONAL { ?option schema:value ?optValue } .\\n    OPTIONAL { ?option schema:identifier ?optId } .\\n}\\n\");//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9qcy93aHlpc192dWUvY29tcG9uZW50cy9wYWdlcy9zcGFycWwtdGVtcGxhdGVzL2xvYWQtc3BhcnFsLXRlbXBsYXRlcy5ycS5qcyIsInNvdXJjZXMiOlsid2VicGFjazovLy8uL2pzL3doeWlzX3Z1ZS9jb21wb25lbnRzL3BhZ2VzL3NwYXJxbC10ZW1wbGF0ZXMvbG9hZC1zcGFycWwtdGVtcGxhdGVzLnJxP2Q4YzIiXSwic291cmNlc0NvbnRlbnQiOlsiZXhwb3J0IGRlZmF1bHQgXCJQUkVGSVggcmRmczogPGh0dHA6Ly93d3cudzMub3JnLzIwMDAvMDEvcmRmLXNjaGVtYSM+XFxuUFJFRklYIHNjaGVtYTogPGh0dHA6Ly9zY2hlbWEub3JnLz5cXG5QUkVGSVggc3A6IDxodHRwOi8vc3BpbnJkZi5vcmcvc3A+XFxuUFJFRklYIHNwaW46IDxodHRwOi8vc3BpbnJkZi5vcmcvc3BpbiM+XFxuUFJFRklYIHNwbDogPGh0dHA6Ly9zcGlucmRmLm9yZy9zcGluIz5cXG5QUkVGSVggd2h5aXM6IDxodHRwOi8vdm9jYWIucnBpLmVkdS93aHlpcy8+XFxuUFJFRklYIG5hbm9taW5lX3RlbXBsYXRlczogPGh0dHA6Ly9uYW5vbWluZS5vcmcvcXVlcnkvPlxcblxcbkNPTlNUUlVDVCB7XFxuICAgID90ZW1wbGF0ZSBhIHdoeWlzOlNwYXJxbFRlbXBsYXRlICA7XFxuICAgICAgICBzcGluOmxhYmVsVGVtcGxhdGUgP2xhYmVsVGVtcGxhdGUgO1xcbiAgICAgICAgc3A6dGV4dCA/cXVlcnkgO1xcbiAgICAgICAgc3Bpbjpjb25zdHJhaW50ID9jb25zdHJhaW50IC5cXG4gICAgP2NvbnN0cmFpbnQgc3A6dmFyTmFtZSA/dmFyTmFtZSA7XFxuICAgICAgICBzY2hlbWE6b3B0aW9uID9vcHRpb24gLlxcbiAgICA/b3B0aW9uIHJkZnM6bGFiZWwgP29wdExhYmVsIDtcXG4gICAgICAgIHNjaGVtYTp2YWx1ZSA/b3B0VmFsdWUgO1xcbiAgICAgICAgc2NoZW1hOmlkZW50aWZpZXIgP29wdElkIDtcXG4gICAgICAgIHNjaGVtYTpwb3NpdGlvbiA/b3B0UG9zaXRpb24gLlxcbn1cXG5XSEVSRSB7XFxuICAgID90ZW1wbGF0ZSBhIHdoeWlzOlNwYXJxbFRlbXBsYXRlICA7XFxuICAgICAgICBzcGluOmxhYmVsVGVtcGxhdGUgP2xhYmVsVGVtcGxhdGUgO1xcbiAgICAgICAgc3A6dGV4dCA/cXVlcnkgO1xcbiAgICAgICAgc3Bpbjpjb25zdHJhaW50ID9jb25zdHJhaW50IC5cXG4gICAgP2NvbnN0cmFpbnQgc3A6dmFyTmFtZSA/dmFyTmFtZSA7XFxuICAgICAgICBzY2hlbWE6b3B0aW9uID9vcHRpb24gLlxcbiAgICA/b3B0aW9uIHJkZnM6bGFiZWwgP29wdExhYmVsIDtcXG4gICAgICAgIHNjaGVtYTpwb3NpdGlvbiA/b3B0UG9zaXRpb24gLlxcbiAgICBPUFRJT05BTCB7ID9vcHRpb24gc2NoZW1hOnZhbHVlID9vcHRWYWx1ZSB9IC5cXG4gICAgT1BUSU9OQUwgeyA/b3B0aW9uIHNjaGVtYTppZGVudGlmaWVyID9vcHRJZCB9IC5cXG59XFxuXCIiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUEiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./js/whyis_vue/components/pages/sparql-templates/load-sparql-templates.rq\n");

/***/ }),

/***/ "./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue":
/*!*********************************************************************************!*\
  !*** ./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue ***!
  \*********************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _sparql_template_page_vue_vue_type_template_id_f1f1c9dc_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true& */ \"./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true&\");\n/* harmony import */ var _sparql_template_page_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sparql-template-page.vue?vue&type=script&lang=js& */ \"./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=script&lang=js&\");\n/* empty/unused harmony star reexport *//* harmony import */ var _sparql_template_page_vue_vue_type_style_index_0_id_f1f1c9dc_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true& */ \"./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&\");\n/* harmony import */ var _node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../../node_modules/vue-loader/lib/runtime/componentNormalizer.js */ \"./node_modules/vue-loader/lib/runtime/componentNormalizer.js\");\n\n\n\n\n\n\n/* normalize component */\n\nvar component = Object(_node_modules_vue_loader_lib_runtime_componentNormalizer_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(\n  _sparql_template_page_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_1__[\"default\"],\n  _sparql_template_page_vue_vue_type_template_id_f1f1c9dc_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"render\"],\n  _sparql_template_page_vue_vue_type_template_id_f1f1c9dc_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"staticRenderFns\"],\n  false,\n  null,\n  \"f1f1c9dc\",\n  null\n  \n)\n\n/* hot reload */\nif (false) { var api; }\ncomponent.options.__file = \"js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue\"\n/* harmony default export */ __webpack_exports__[\"default\"] = (component.exports);//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue\n");

/***/ }),

/***/ "./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=script&lang=js&":
/*!**********************************************************************************************************!*\
  !*** ./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=script&lang=js& ***!
  \**********************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/lib??vue-loader-options!./sparql-template-page.vue?vue&type=script&lang=js& */ \"./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=script&lang=js&\");\n/* empty/unused harmony star reexport */ /* harmony default export */ __webpack_exports__[\"default\"] = (_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_script_lang_js___WEBPACK_IMPORTED_MODULE_0__[\"default\"]); //# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9qcy93aHlpc192dWUvY29tcG9uZW50cy9wYWdlcy9zcGFycWwtdGVtcGxhdGVzL3NwYXJxbC10ZW1wbGF0ZS1wYWdlLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qcyYuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9qcy93aHlpc192dWUvY29tcG9uZW50cy9wYWdlcy9zcGFycWwtdGVtcGxhdGVzL3NwYXJxbC10ZW1wbGF0ZS1wYWdlLnZ1ZT8yNjQ0Il0sInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBtb2QgZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvbGliL2luZGV4LmpzPz92dWUtbG9hZGVyLW9wdGlvbnMhLi9zcGFycWwtdGVtcGxhdGUtcGFnZS52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anMmXCI7IGV4cG9ydCBkZWZhdWx0IG1vZDsgZXhwb3J0ICogZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvbGliL2luZGV4LmpzPz92dWUtbG9hZGVyLW9wdGlvbnMhLi9zcGFycWwtdGVtcGxhdGUtcGFnZS52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anMmXCIiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQSIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=script&lang=js&\n");

/***/ }),

/***/ "./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&":
/*!*******************************************************************************************************************************************!*\
  !*** ./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true& ***!
  \*******************************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_vue_style_loader_index_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_resolve_url_loader_index_js_node_modules_sass_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_style_index_0_id_f1f1c9dc_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-style-loader!../../../../../node_modules/css-loader/dist/cjs.js!../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../node_modules/resolve-url-loader!../../../../../node_modules/sass-loader/dist/cjs.js!../../../../../node_modules/vue-loader/lib??vue-loader-options!./sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true& */ \"./node_modules/vue-style-loader/index.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/resolve-url-loader/index.js!./node_modules/sass-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&\");\n/* harmony import */ var _node_modules_vue_style_loader_index_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_resolve_url_loader_index_js_node_modules_sass_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_style_index_0_id_f1f1c9dc_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_vue_style_loader_index_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_resolve_url_loader_index_js_node_modules_sass_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_style_index_0_id_f1f1c9dc_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_0__);\n/* harmony reexport (unknown) */ for(var __WEBPACK_IMPORT_KEY__ in _node_modules_vue_style_loader_index_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_resolve_url_loader_index_js_node_modules_sass_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_style_index_0_id_f1f1c9dc_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_0__) if([\"default\"].indexOf(__WEBPACK_IMPORT_KEY__) < 0) (function(key) { __webpack_require__.d(__webpack_exports__, key, function() { return _node_modules_vue_style_loader_index_js_node_modules_css_loader_dist_cjs_js_node_modules_vue_loader_lib_loaders_stylePostLoader_js_node_modules_resolve_url_loader_index_js_node_modules_sass_loader_dist_cjs_js_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_style_index_0_id_f1f1c9dc_lang_scss_scoped_true___WEBPACK_IMPORTED_MODULE_0__[key]; }) }(__WEBPACK_IMPORT_KEY__));\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9qcy93aHlpc192dWUvY29tcG9uZW50cy9wYWdlcy9zcGFycWwtdGVtcGxhdGVzL3NwYXJxbC10ZW1wbGF0ZS1wYWdlLnZ1ZT92dWUmdHlwZT1zdHlsZSZpbmRleD0wJmlkPWYxZjFjOWRjJmxhbmc9c2NzcyZzY29wZWQ9dHJ1ZSYuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9qcy93aHlpc192dWUvY29tcG9uZW50cy9wYWdlcy9zcGFycWwtdGVtcGxhdGVzL3NwYXJxbC10ZW1wbGF0ZS1wYWdlLnZ1ZT9mMWFjIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCAqIGZyb20gXCItIS4uLy4uLy4uLy4uLy4uL25vZGVfbW9kdWxlcy92dWUtc3R5bGUtbG9hZGVyL2luZGV4LmpzIS4uLy4uLy4uLy4uLy4uL25vZGVfbW9kdWxlcy9jc3MtbG9hZGVyL2Rpc3QvY2pzLmpzIS4uLy4uLy4uLy4uLy4uL25vZGVfbW9kdWxlcy92dWUtbG9hZGVyL2xpYi9sb2FkZXJzL3N0eWxlUG9zdExvYWRlci5qcyEuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvcmVzb2x2ZS11cmwtbG9hZGVyL2luZGV4LmpzIS4uLy4uLy4uLy4uLy4uL25vZGVfbW9kdWxlcy9zYXNzLWxvYWRlci9kaXN0L2Nqcy5qcyEuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9saWIvaW5kZXguanM/P3Z1ZS1sb2FkZXItb3B0aW9ucyEuL3NwYXJxbC10ZW1wbGF0ZS1wYWdlLnZ1ZT92dWUmdHlwZT1zdHlsZSZpbmRleD0wJmlkPWYxZjFjOWRjJmxhbmc9c2NzcyZzY29wZWQ9dHJ1ZSZcIiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQUE7Iiwic291cmNlUm9vdCI6IiJ9\n//# sourceURL=webpack-internal:///./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&\n");

/***/ }),

/***/ "./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true&":
/*!****************************************************************************************************************************!*\
  !*** ./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true& ***!
  \****************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_template_id_f1f1c9dc_scoped_true___WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!../../../../../node_modules/vue-loader/lib??vue-loader-options!./sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true& */ \"./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true&\");\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_template_id_f1f1c9dc_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"render\"]; });\n\n/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, \"staticRenderFns\", function() { return _node_modules_vue_loader_lib_loaders_templateLoader_js_vue_loader_options_node_modules_vue_loader_lib_index_js_vue_loader_options_sparql_template_page_vue_vue_type_template_id_f1f1c9dc_scoped_true___WEBPACK_IMPORTED_MODULE_0__[\"staticRenderFns\"]; });\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9qcy93aHlpc192dWUvY29tcG9uZW50cy9wYWdlcy9zcGFycWwtdGVtcGxhdGVzL3NwYXJxbC10ZW1wbGF0ZS1wYWdlLnZ1ZT92dWUmdHlwZT10ZW1wbGF0ZSZpZD1mMWYxYzlkYyZzY29wZWQ9dHJ1ZSYuanMiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly8vLi9qcy93aHlpc192dWUvY29tcG9uZW50cy9wYWdlcy9zcGFycWwtdGVtcGxhdGVzL3NwYXJxbC10ZW1wbGF0ZS1wYWdlLnZ1ZT9mYmIwIl0sInNvdXJjZXNDb250ZW50IjpbImV4cG9ydCAqIGZyb20gXCItIS4uLy4uLy4uLy4uLy4uL25vZGVfbW9kdWxlcy92dWUtbG9hZGVyL2xpYi9sb2FkZXJzL3RlbXBsYXRlTG9hZGVyLmpzPz92dWUtbG9hZGVyLW9wdGlvbnMhLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvbGliL2luZGV4LmpzPz92dWUtbG9hZGVyLW9wdGlvbnMhLi9zcGFycWwtdGVtcGxhdGUtcGFnZS52dWU/dnVlJnR5cGU9dGVtcGxhdGUmaWQ9ZjFmMWM5ZGMmc2NvcGVkPXRydWUmXCIiXSwibWFwcGluZ3MiOiJBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFBQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true&\n");

/***/ }),

/***/ "./js/whyis_vue/utilities/common-namespaces.js":
/*!*****************************************************!*\
  !*** ./js/whyis_vue/utilities/common-namespaces.js ***!
  \*****************************************************/
/*! exports provided: RDF, RDFS, WHYIS, SCHEMA */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"RDF\", function() { return RDF; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"RDFS\", function() { return RDFS; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"WHYIS\", function() { return WHYIS; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"SCHEMA\", function() { return SCHEMA; });\n\n// TODO: add more prefixes as needed\nconst RDF =  \"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\nconst RDFS = \"http://www.w3.org/2000/01/rdf-schema#\"\nconst WHYIS = \"http://vocab.rpi.edu/whyis/\"\nconst SCHEMA = \"http://schema.org/\"\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9qcy93aHlpc192dWUvdXRpbGl0aWVzL2NvbW1vbi1uYW1lc3BhY2VzLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vanMvd2h5aXNfdnVlL3V0aWxpdGllcy9jb21tb24tbmFtZXNwYWNlcy5qcz83NmYwIl0sInNvdXJjZXNDb250ZW50IjpbIlxuLy8gVE9ETzogYWRkIG1vcmUgcHJlZml4ZXMgYXMgbmVlZGVkXG5leHBvcnQgY29uc3QgUkRGID0gIFwiaHR0cDovL3d3dy53My5vcmcvMTk5OS8wMi8yMi1yZGYtc3ludGF4LW5zI1wiXG5leHBvcnQgY29uc3QgUkRGUyA9IFwiaHR0cDovL3d3dy53My5vcmcvMjAwMC8wMS9yZGYtc2NoZW1hI1wiXG5leHBvcnQgY29uc3QgV0hZSVMgPSBcImh0dHA6Ly92b2NhYi5ycGkuZWR1L3doeWlzL1wiXG5leHBvcnQgY29uc3QgU0NIRU1BID0gXCJodHRwOi8vc2NoZW1hLm9yZy9cIlxuIl0sIm1hcHBpbmdzIjoiQUFBQTtBQUFBO0FBQUE7QUFBQTtBQUFBO0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBOyIsInNvdXJjZVJvb3QiOiIifQ==\n//# sourceURL=webpack-internal:///./js/whyis_vue/utilities/common-namespaces.js\n");

/***/ }),

/***/ "./js/whyis_vue/utilities/debounce.js":
/*!********************************************!*\
  !*** ./js/whyis_vue/utilities/debounce.js ***!
  \********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"default\", function() { return debounce; });\n\nfunction debounce (func, millis) {\n  let timeout\n  return function (...args) {\n    const functionCall = () => func.apply(this, args)\n    clearTimeout(timeout)\n    timeout = setTimeout(functionCall, millis)\n  }\n}\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiLi9qcy93aHlpc192dWUvdXRpbGl0aWVzL2RlYm91bmNlLmpzLmpzIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vLy4vanMvd2h5aXNfdnVlL3V0aWxpdGllcy9kZWJvdW5jZS5qcz80MGZhIl0sInNvdXJjZXNDb250ZW50IjpbIlxuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gZGVib3VuY2UgKGZ1bmMsIG1pbGxpcykge1xuICBsZXQgdGltZW91dFxuICByZXR1cm4gZnVuY3Rpb24gKC4uLmFyZ3MpIHtcbiAgICBjb25zdCBmdW5jdGlvbkNhbGwgPSAoKSA9PiBmdW5jLmFwcGx5KHRoaXMsIGFyZ3MpXG4gICAgY2xlYXJUaW1lb3V0KHRpbWVvdXQpXG4gICAgdGltZW91dCA9IHNldFRpbWVvdXQoZnVuY3Rpb25DYWxsLCBtaWxsaXMpXG4gIH1cbn1cbiJdLCJtYXBwaW5ncyI6IkFBQUE7QUFBQTtBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTsiLCJzb3VyY2VSb290IjoiIn0=\n//# sourceURL=webpack-internal:///./js/whyis_vue/utilities/debounce.js\n");

/***/ }),

/***/ "./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/resolve-url-loader/index.js!./node_modules/sass-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&":
/*!*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/resolve-url-loader!./node_modules/sass-loader/dist/cjs.js!./node_modules/vue-loader/lib??vue-loader-options!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true& ***!
  \*********************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/cssWithMappingToString.js */ \"./node_modules/css-loader/dist/runtime/cssWithMappingToString.js\");\n/* harmony import */ var _node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0__);\n/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../../node_modules/css-loader/dist/runtime/api.js */ \"./node_modules/css-loader/dist/runtime/api.js\");\n/* harmony import */ var _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1__);\n// Imports\n\n\nvar ___CSS_LOADER_EXPORT___ = _node_modules_css_loader_dist_runtime_api_js__WEBPACK_IMPORTED_MODULE_1___default()(_node_modules_css_loader_dist_runtime_cssWithMappingToString_js__WEBPACK_IMPORTED_MODULE_0___default.a);\n// Module\n___CSS_LOADER_EXPORT___.push([module.i, \".sparql-template-page[data-v-f1f1c9dc] {\\n  max-width: 960px;\\n  margin: auto;\\n}\\n.display[data-v-f1f1c9dc] {\\n  display: flex;\\n  flex-direction: row;\\n  justify-content: space-between;\\n  align-items: center;\\n  height: 18em;\\n}\\n.display .template-next[data-v-f1f1c9dc] {\\n  order: 1;\\n}\\n.display .display-text[data-v-f1f1c9dc] {\\n  max-height: calc(100% - 60px);\\n  overflow: auto;\\n  margin: 30px;\\n  font-size: 16px;\\n  line-height: 40px;\\n}\\n.display-count-indicator[data-v-f1f1c9dc] {\\n  text-align: center;\\n  margin-bottom: 20px;\\n  font-weight: 500;\\n}\\n.accordion[data-v-f1f1c9dc] {\\n  margin-bottom: 20px;\\n}\", \"\",{\"version\":3,\"sources\":[\"webpack://./sparql-template-page.vue\"],\"names\":[],\"mappings\":\"AA8QA;EACE,gBAAA;EACA,YAAA;AA7QF;AA+QA;EACE,aAAA;EACA,mBAAA;EACA,8BAAA;EACA,mBAAA;EACA,YAAA;AA5QF;AA6QE;EACE,QAAA;AA3QJ;AA6QE;EACE,6BAAA;EACA,cAAA;EACA,YAAA;EACA,eAAA;EACA,iBAAA;AA3QJ;AA8QA;EACE,kBAAA;EACA,mBAAA;EACA,gBAAA;AA3QF;AA6QA;EACE,mBAAA;AA1QF\",\"sourcesContent\":[\"\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n\\n.sparql-template-page {\\n  max-width: 960px;\\n  margin: auto;\\n}\\n.display {\\n  display: flex;\\n  flex-direction: row;\\n  justify-content: space-between;\\n  align-items: center;\\n  height: 18em;\\n  .template-next {\\n    order: 1;\\n  }\\n  .display-text {\\n    max-height: calc(100% - 60px);\\n    overflow: auto;\\n    margin: 30px;\\n    font-size: 16px;\\n    line-height: 40px;\\n  }\\n}\\n.display-count-indicator {\\n  text-align: center;\\n  margin-bottom: 20px;\\n  font-weight: 500;\\n}\\n.accordion {\\n  margin-bottom: 20px;\\n}\\n\"],\"sourceRoot\":\"\"}]);\n// Exports\n/* harmony default export */ __webpack_exports__[\"default\"] = (___CSS_LOADER_EXPORT___);\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/resolve-url-loader/index.js!./node_modules/sass-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&\n");

/***/ }),

/***/ "./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=script&lang=js&":
/*!************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib??vue-loader-options!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=script&lang=js& ***!
  \************************************************************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vuex */ \"./node_modules/vuex/dist/vuex.esm.js\");\n/* harmony import */ var _utilities_sparql__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../utilities/sparql */ \"./js/whyis_vue/utilities/sparql.js\");\n/* harmony import */ var _utilities_views__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../utilities/views */ \"./js/whyis_vue/utilities/views.js\");\n/* harmony import */ var _load_sparql_templates__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./load-sparql-templates */ \"./js/whyis_vue/components/pages/sparql-templates/load-sparql-templates.js\");\n/* harmony import */ var _utilities_debounce__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../utilities/debounce */ \"./js/whyis_vue/utilities/debounce.js\");\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n//\n\n\n\n\n\n\n\n\nconst stripQVarFormatting = formatted =>\n  formatted\n    .replace(/^{{/, \"\")\n    .replace(/}}$/, \"\")\n    .trim();\nconst qVarRegex = /({{[^{}]+}})/g;\n\n\n/* harmony default export */ __webpack_exports__[\"default\"] = ({\n  data() {\n    return {\n      loadingTemplates: true,\n      queryTemplates: {},\n      TextSegmentType: _load_sparql_templates__WEBPACK_IMPORTED_MODULE_3__[\"TextSegmentType\"],\n      selTemplateId: null,\n      query: \"\",\n      varSelections: {},\n      results: null,\n      execQueryDebounced: Object(_utilities_debounce__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(this.execQuery, 300)\n    };\n  },\n  computed: {\n    templateIds() {\n      return Object.keys(this.queryTemplates);\n    },\n    selectedTemplate() {\n      return this.queryTemplates[this.selTemplateId];\n    },\n    currentIndex() {\n      return this.templateIds.indexOf(this.selTemplateId);\n    },\n    totalTemplateCount() {\n      return this.templateIds.length;\n    },\n  },\n  methods: {\n    ...Object(vuex__WEBPACK_IMPORTED_MODULE_0__[\"mapMutations\"])(\"vizEditor\", [\"setQuery\"]),\n    selectQueryForVizEditor() {\n      this.setQuery(this.query);\n      this.toVizEditor();\n    },\n    toVizEditor() {\n      Object(_utilities_views__WEBPACK_IMPORTED_MODULE_2__[\"goToView\"])(_utilities_views__WEBPACK_IMPORTED_MODULE_2__[\"VIEW_URIS\"].CHART_EDITOR, _utilities_views__WEBPACK_IMPORTED_MODULE_2__[\"DEFAULT_VIEWS\"].NEW);\n    },\n    async loadSparqlTemplates() {\n      this.loadingTemplates = true;\n      try {\n        const templates = await Object(_load_sparql_templates__WEBPACK_IMPORTED_MODULE_3__[\"loadSparqlTemplates\"])();\n        this.queryTemplates = {}\n        templates.forEach(t => this.queryTemplates[t.id] = t)\n        console.log('qtemps', this.queryTemplates)\n        this.selTemplateId = templates.length > 0 ? templates[0].id : null\n      } finally {\n        this.loadingTemplates = false;\n      }\n    },\n    shiftTemplate(amount) {\n      let newIndex = this.currentIndex + amount;\n      while (newIndex >= this.totalTemplateCount) {\n        newIndex -= this.totalTemplateCount;\n      }\n      while (newIndex < 0) {\n        newIndex += this.totalTemplateCount;\n      }\n      this.selTemplateId = this.templateIds[newIndex];\n      console.log(\"shifted\", newIndex, this.selTemplateId, this.templateIds);\n    },\n    populateSelections() {\n      if (!this.selectedTemplate) {\n        return;\n      }\n      this.varSelections = Object.fromEntries(\n        Object.entries(\n          this.selectedTemplate.options\n        ).map(([varName, varOpts]) => [varName, Object.keys(varOpts)[0]])\n      );\n    },\n    getOptVal(varName, optName) {\n      return this.selectedTemplate.options[varName][optName]\n    },\n    buildQuery() {\n      if (!this.selectedTemplate) {\n        return;\n      }\n      this.query = this.selectedTemplate.SPARQL\n\n      this.selectedTemplate.options\n\n      // append VALUES clause to query if there are any active selections\n      const activeSelections = Object.fromEntries(\n        Object.entries(this.varSelections)\n          .filter(selEntry => this.getOptVal(...selEntry).type !== _load_sparql_templates__WEBPACK_IMPORTED_MODULE_3__[\"OptValueType\"].ANY)\n      )\n      if (Object.keys(activeSelections).length > 0) {\n        const varNames = Object.keys(activeSelections)\n          .map(varName => `?${varName}`)\n          .join(\" \")\n\n        const optVals = Object.entries(activeSelections)\n          .map( selEntry => {\n            const optVal = this.getOptVal(...selEntry)\n            let value\n            if (optVal.type === _load_sparql_templates__WEBPACK_IMPORTED_MODULE_3__[\"OptValueType\"].LITERAL) {\n              value = optVal.value\n              if (typeof value !== \"number\") {\n                value = `\"${value}\"`\n              }\n            } else if (optVal.type === _load_sparql_templates__WEBPACK_IMPORTED_MODULE_3__[\"OptValueType\"].IDENTIFIER) {\n              value = `<${optVal.value}>`\n            } else {\n              throw `Unknown option value type: ${optVal.type}`\n            }\n            return value\n          })\n          .join(\" \")\n\n        this.query += `\\nVALUES (${varNames}) {\\n  (${optVals})\\n}\\n`\n      }\n    },\n    async execQuery() {\n      console.log(\"querying....\");\n      this.results = null;\n      this.results = await Object(_utilities_sparql__WEBPACK_IMPORTED_MODULE_1__[\"querySparql\"])(this.query);\n      console.log(\"done\", this.results);\n    }\n  },\n  created() {\n    this.loadSparqlTemplates();\n  },\n  watch: {\n    // The following reactive watchers are used due to limitations of not being\n    // able to deep watch dependencies of computed methods.\n    selectedTemplate: {\n      handler: \"populateSelections\"\n    },\n    varSelections: {\n      handler: \"buildQuery\",\n      deep: true\n    },\n    query: {\n      handler: \"execQueryDebounced\"\n    }\n  }\n});\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=script&lang=js&\n");

/***/ }),

/***/ "./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true&":
/*!**********************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/lib/loaders/templateLoader.js??vue-loader-options!./node_modules/vue-loader/lib??vue-loader-options!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true& ***!
  \**********************************************************************************************************************************************************************************************************************************************************/
/*! exports provided: render, staticRenderFns */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"render\", function() { return render; });\n/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, \"staticRenderFns\", function() { return staticRenderFns; });\nvar render = function() {\n  var _vm = this\n  var _h = _vm.$createElement\n  var _c = _vm._self._c || _h\n  return _c(\"div\", { staticClass: \"sparql-template-page\" }, [\n    _vm.loadingTemplates\n      ? _c(\n          \"div\",\n          [\n            _c(\"md-progress-spinner\", { attrs: { \"md-mode\": \"indeterminate\" } })\n          ],\n          1\n        )\n      : _vm.totalTemplateCount === 0\n      ? _c(\"div\", [_c(\"p\", [_vm._v(\"No templates were loaded\")])])\n      : _c(\n          \"div\",\n          [\n            _c(\"div\", { staticClass: \"button-row\" }, [\n              _c(\n                \"div\",\n                [\n                  _c(\n                    \"md-button\",\n                    {\n                      staticClass: \"md-icon-button\",\n                      nativeOn: {\n                        click: function($event) {\n                          $event.preventDefault()\n                          return _vm.selectQueryForVizEditor()\n                        }\n                      }\n                    },\n                    [\n                      _c(\n                        \"md-tooltip\",\n                        {\n                          staticClass: \"utility-bckg\",\n                          attrs: { \"md-direction\": \"bottom\" }\n                        },\n                        [\n                          _vm._v(\n                            \"\\n            Select current query and return to Viz Editor\\n          \"\n                          )\n                        ]\n                      ),\n                      _vm._v(\" \"),\n                      _c(\"md-icon\", [_vm._v(\"check\")])\n                    ],\n                    1\n                  ),\n                  _vm._v(\" \"),\n                  _c(\n                    \"md-button\",\n                    {\n                      staticClass: \"md-icon-button\",\n                      nativeOn: {\n                        click: function($event) {\n                          $event.preventDefault()\n                          return _vm.toVizEditor()\n                        }\n                      }\n                    },\n                    [\n                      _c(\n                        \"md-tooltip\",\n                        {\n                          staticClass: \"utility-bckg\",\n                          attrs: { \"md-direction\": \"bottom\" }\n                        },\n                        [_vm._v(\" Return to viz editor \")]\n                      ),\n                      _vm._v(\" \"),\n                      _c(\"md-icon\", [_vm._v(\"arrow_back\")])\n                    ],\n                    1\n                  )\n                ],\n                1\n              )\n            ]),\n            _vm._v(\" \"),\n            _c(\"md-toolbar\", [\n              _c(\"h3\", { staticClass: \"md-title\" }, [_vm._v(\"Query Template\")])\n            ]),\n            _vm._v(\" \"),\n            _c(\n              \"div\",\n              { staticClass: \"display\" },\n              [\n                _c(\n                  \"md-button\",\n                  {\n                    staticClass: \"template-back\",\n                    on: {\n                      click: function($event) {\n                        return _vm.shiftTemplate(-1)\n                      }\n                    }\n                  },\n                  [_c(\"md-icon\", [_vm._v(\"chevron_left\")])],\n                  1\n                ),\n                _vm._v(\" \"),\n                _c(\n                  \"md-button\",\n                  {\n                    staticClass: \"template-next\",\n                    on: {\n                      click: function($event) {\n                        return _vm.shiftTemplate(1)\n                      }\n                    }\n                  },\n                  [_c(\"md-icon\", [_vm._v(\"chevron_right\")])],\n                  1\n                ),\n                _vm._v(\" \"),\n                _c(\n                  \"p\",\n                  { staticClass: \"display-text\" },\n                  _vm._l(_vm.selectedTemplate.displaySegments, function(\n                    segment,\n                    index\n                  ) {\n                    return _c(\"span\", { key: index }, [\n                      segment.type == _vm.TextSegmentType.TEXT\n                        ? _c(\"span\", {\n                            domProps: { innerHTML: _vm._s(segment.text) }\n                          })\n                        : _c(\"span\", [\n                            _c(\n                              \"select\",\n                              {\n                                directives: [\n                                  {\n                                    name: \"model\",\n                                    rawName: \"v-model\",\n                                    value: _vm.varSelections[segment.varName],\n                                    expression: \"varSelections[segment.varName]\"\n                                  }\n                                ],\n                                attrs: {\n                                  id: segment.varName,\n                                  name: segment.varName\n                                },\n                                on: {\n                                  change: function($event) {\n                                    var $$selectedVal = Array.prototype.filter\n                                      .call($event.target.options, function(o) {\n                                        return o.selected\n                                      })\n                                      .map(function(o) {\n                                        var val =\n                                          \"_value\" in o ? o._value : o.value\n                                        return val\n                                      })\n                                    _vm.$set(\n                                      _vm.varSelections,\n                                      segment.varName,\n                                      $event.target.multiple\n                                        ? $$selectedVal\n                                        : $$selectedVal[0]\n                                    )\n                                  }\n                                }\n                              },\n                              _vm._l(\n                                _vm.selectedTemplate.options[segment.varName],\n                                function(value, name) {\n                                  return _c(\n                                    \"option\",\n                                    { key: name, domProps: { value: name } },\n                                    [\n                                      _vm._v(\n                                        \"\\n                \" +\n                                          _vm._s(name) +\n                                          \"\\n              \"\n                                      )\n                                    ]\n                                  )\n                                }\n                              ),\n                              0\n                            )\n                          ])\n                    ])\n                  }),\n                  0\n                )\n              ],\n              1\n            ),\n            _vm._v(\" \"),\n            _c(\"div\", { staticClass: \"display-count-indicator\" }, [\n              _c(\"p\", [\n                _vm._v(\n                  \"Query template \" +\n                    _vm._s(_vm.currentIndex + 1) +\n                    \" of \" +\n                    _vm._s(_vm.totalTemplateCount)\n                )\n              ])\n            ]),\n            _vm._v(\" \"),\n            _vm.query\n              ? _c(\n                  \"div\",\n                  { staticClass: \"query\" },\n                  [\n                    _c(\n                      \"accordion\",\n                      { attrs: { startOpen: false, title: \"SPARQL Query\" } },\n                      [\n                        _c(\"yasqe\", {\n                          attrs: { value: _vm.query, readonly: \"true\" }\n                        })\n                      ],\n                      1\n                    )\n                  ],\n                  1\n                )\n              : _vm._e(),\n            _vm._v(\" \"),\n            _c(\n              \"div\",\n              { staticClass: \"results\" },\n              [\n                _c(\n                  \"accordion\",\n                  { attrs: { startOpen: true, title: \"SPARQL Results\" } },\n                  [\n                    _vm.results\n                      ? _c(\n                          \"div\",\n                          [_c(\"yasr\", { attrs: { results: _vm.results } })],\n                          1\n                        )\n                      : _c(\"md-progress-spinner\", {\n                          attrs: {\n                            \"md-diameter\": 30,\n                            \"md-stroke\": 3,\n                            \"md-mode\": \"indeterminate\"\n                          }\n                        })\n                  ],\n                  1\n                )\n              ],\n              1\n            )\n          ],\n          1\n        )\n  ])\n}\nvar staticRenderFns = []\nrender._withStripped = true\n\n//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/vue-loader/lib/loaders/templateLoader.js?!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=template&id=f1f1c9dc&scoped=true&\n");

/***/ }),

/***/ "./node_modules/vue-style-loader/index.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/resolve-url-loader/index.js!./node_modules/sass-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&":
/*!*****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-style-loader!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/resolve-url-loader!./node_modules/sass-loader/dist/cjs.js!./node_modules/vue-loader/lib??vue-loader-options!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true& ***!
  \*****************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

eval("// style-loader: Adds some css to the DOM by adding a <style> tag\n\n// load the styles\nvar content = __webpack_require__(/*! !../../../../../node_modules/css-loader/dist/cjs.js!../../../../../node_modules/vue-loader/lib/loaders/stylePostLoader.js!../../../../../node_modules/resolve-url-loader!../../../../../node_modules/sass-loader/dist/cjs.js!../../../../../node_modules/vue-loader/lib??vue-loader-options!./sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true& */ \"./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/resolve-url-loader/index.js!./node_modules/sass-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&\");\nif(content.__esModule) content = content.default;\nif(typeof content === 'string') content = [[module.i, content, '']];\nif(content.locals) module.exports = content.locals;\n// add the styles to the DOM\nvar add = __webpack_require__(/*! ../../../../../node_modules/vue-style-loader/lib/addStylesClient.js */ \"./node_modules/vue-style-loader/lib/addStylesClient.js\").default\nvar update = add(\"18114352\", content, false, {});\n// Hot Module Replacement\nif(false) {}//# sourceURL=[module]\n//# sourceMappingURL=data:application/json;charset=utf-8;base64,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\n//# sourceURL=webpack-internal:///./node_modules/vue-style-loader/index.js!./node_modules/css-loader/dist/cjs.js!./node_modules/vue-loader/lib/loaders/stylePostLoader.js!./node_modules/resolve-url-loader/index.js!./node_modules/sass-loader/dist/cjs.js!./node_modules/vue-loader/lib/index.js?!./js/whyis_vue/components/pages/sparql-templates/sparql-template-page.vue?vue&type=style&index=0&id=f1f1c9dc&lang=scss&scoped=true&\n");

/***/ })

}]);