/*
 * Decompiled with CFR 0.152.
 */
package edu.rpi.tw.jena.query.fulltext.assembler;

import edu.rpi.tw.jena.query.fulltext.EntityDefinition;
import edu.rpi.tw.jena.query.fulltext.TextIndexException;
import java.util.List;
import org.apache.jena.assembler.Assembler;
import org.apache.jena.assembler.Mode;
import org.apache.jena.assembler.assemblers.AssemblerBase;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ParameterizedSparqlString;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;

public class EntityDefinitionAssembler
extends AssemblerBase
implements Assembler {
    public EntityDefinition open(Assembler a, Resource root, Mode mode) {
        String prologue = "PREFIX : <http://jena.apache.org/fulltext#>   PREFIX list: <http://jena.apache.org/ARQ/list#> ";
        Model model = root.getModel();
        String qs1 = StrUtils.strjoinNL((String[])new String[]{prologue, "SELECT * {", "  ?eMap  :entityField  ?entityField ;", "         :defaultField ?dftField .", "  OPTIONAL {", "    ?eMap :graphField ?graphField", "  }", "  OPTIONAL {", "    ?eMap :langField ?langField", "  }", "  OPTIONAL {", "    ?eMap :uidField ?uidField", "  }", "}"});
        ParameterizedSparqlString pss = new ParameterizedSparqlString(qs1);
        pss.setIri("eMap", root.getURI());
        Query query1 = QueryFactory.create((String)pss.toString());
        QueryExecution qexec1 = QueryExecutionFactory.create((Query)query1, (Model)model);
        ResultSet rs1 = qexec1.execSelect();
        List results = ResultSetFormatter.toList((ResultSet)rs1);
        if (results.size() == 0) {
            Log.warn((Object)((Object)this), (String)("Failed to find a valid EntityMap for : " + root));
            throw new TextIndexException("Failed to find a valid EntityMap for : " + root);
        }
        if (results.size() != 1) {
            Log.warn((Object)((Object)this), (String)("Multiple matches for EntityMap for : " + root));
            throw new TextIndexException("Multiple matches for EntityMap for : " + root);
        }
        QuerySolution qsol1 = (QuerySolution)results.get(0);
        String entityField = qsol1.contains("entityField") ? qsol1.getLiteral("entityField").getLexicalForm() : "uri";
        String graphField = qsol1.contains("graphField") ? qsol1.getLiteral("graphField").getLexicalForm() : "graph";
        String langField = qsol1.contains("langField") ? qsol1.getLiteral("langField").getLexicalForm() : "lang";
        String defaultField = qsol1.contains("dftField") ? qsol1.getLiteral("dftField").getLexicalForm() : null;
        String uniqueIdField = qsol1.contains("uidField") ? qsol1.getLiteral("uidField").getLexicalForm() : null;
        EntityDefinition docDef = new EntityDefinition(entityField, defaultField);
        docDef.setGraphField(graphField);
        docDef.setLangField(langField);
        docDef.setUidField(uniqueIdField);
        return docDef;
    }
}

