/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Supplier;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;

public class MetaData
implements Iterable<HttpField> {
    private final HttpVersion _httpVersion;
    private final HttpFields _fields;
    private final long _contentLength;
    private final Supplier<HttpFields> _trailerSupplier;

    public MetaData(HttpVersion version2, HttpFields fields) {
        this(version2, fields, -1L);
    }

    public MetaData(HttpVersion version2, HttpFields fields, long contentLength) {
        this(version2, fields, contentLength, null);
    }

    public MetaData(HttpVersion version2, HttpFields fields, long contentLength, Supplier<HttpFields> trailerSupplier) {
        this._httpVersion = version2;
        HttpFields httpFields = this._fields = fields == null ? null : fields.asImmutable();
        this._contentLength = contentLength >= 0L ? contentLength : (this._fields == null ? -1L : this._fields.getLongField(HttpHeader.CONTENT_LENGTH));
        this._trailerSupplier = trailerSupplier;
    }

    public boolean isRequest() {
        return false;
    }

    public boolean isResponse() {
        return false;
    }

    public HttpVersion getHttpVersion() {
        return this._httpVersion;
    }

    public HttpFields getFields() {
        return this._fields;
    }

    public Supplier<HttpFields> getTrailerSupplier() {
        return this._trailerSupplier;
    }

    public long getContentLength() {
        return this._contentLength;
    }

    @Override
    public Iterator<HttpField> iterator() {
        if (this._fields == null) {
            return Collections.emptyIterator();
        }
        return this._fields.iterator();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        for (HttpField field : this) {
            out.append(field).append(System.lineSeparator());
        }
        return out.toString();
    }

    public static class Response
    extends MetaData {
        private final int _status;
        private final String _reason;

        public Response(HttpVersion version2, int status, HttpFields fields) {
            this(version2, status, fields, Long.MIN_VALUE);
        }

        public Response(HttpVersion version2, int status, HttpFields fields, long contentLength) {
            this(version2, status, null, fields, contentLength);
        }

        public Response(HttpVersion version2, int status, String reason, HttpFields fields, long contentLength) {
            this(version2, status, reason, fields, contentLength, null);
        }

        public Response(HttpVersion version2, int status, String reason, HttpFields fields, long contentLength, Supplier<HttpFields> trailers) {
            super(version2, fields, contentLength, trailers);
            this._reason = reason;
            this._status = status;
        }

        @Override
        public boolean isResponse() {
            return true;
        }

        public int getStatus() {
            return this._status;
        }

        public String getReason() {
            return this._reason;
        }

        @Override
        public String toString() {
            HttpFields fields = this.getFields();
            return String.format("%s{s=%d,h=%d,cl=%d}", new Object[]{this.getHttpVersion(), this.getStatus(), fields == null ? -1 : fields.size(), this.getContentLength()});
        }
    }

    public static class ConnectRequest
    extends Request {
        private final String _protocol;

        public ConnectRequest(HttpScheme scheme, HostPortHttpField authority, String path, HttpFields fields, String protocol) {
            this(scheme == null ? null : scheme.asString(), authority, path, fields, protocol);
        }

        public ConnectRequest(String scheme, HostPortHttpField authority, String path, HttpFields fields, String protocol) {
            super(HttpMethod.CONNECT.asString(), HttpURI.build().scheme(scheme).host(authority == null ? null : authority.getHost()).port(authority == null ? -1 : authority.getPort()).pathQuery(path), HttpVersion.HTTP_2, fields, Long.MIN_VALUE, null);
            this._protocol = protocol;
        }

        @Override
        public String getProtocol() {
            return this._protocol;
        }
    }

    public static class Request
    extends MetaData {
        private final String _method;
        private final HttpURI _uri;

        public Request(HttpFields fields) {
            this(null, null, null, fields);
        }

        public Request(String method, HttpURI uri, HttpVersion version2, HttpFields fields) {
            this(method, uri, version2, fields, Long.MIN_VALUE);
        }

        public Request(String method, HttpURI uri, HttpVersion version2, HttpFields fields, long contentLength) {
            super(version2, fields, contentLength);
            this._method = method;
            this._uri = uri.asImmutable();
        }

        public Request(String method, String scheme, HostPortHttpField authority, String uri, HttpVersion version2, HttpFields fields, long contentLength) {
            this(method, HttpURI.build().scheme(scheme).host(authority == null ? null : authority.getHost()).port(authority == null ? -1 : authority.getPort()).pathQuery(uri), version2, fields, contentLength);
        }

        public Request(String method, HttpURI uri, HttpVersion version2, HttpFields fields, long contentLength, Supplier<HttpFields> trailers) {
            super(version2, fields, contentLength, trailers);
            this._method = method;
            this._uri = uri;
        }

        @Override
        public boolean isRequest() {
            return true;
        }

        public String getMethod() {
            return this._method;
        }

        public HttpURI getURI() {
            return this._uri;
        }

        public String getURIString() {
            return this._uri == null ? null : this._uri.toString();
        }

        public String getProtocol() {
            return null;
        }

        @Override
        public String toString() {
            HttpFields fields = this.getFields();
            return String.format("%s{u=%s,%s,h=%d,cl=%d,p=%s}", new Object[]{this.getMethod(), this.getURI(), this.getHttpVersion(), fields == null ? -1 : fields.size(), this.getContentLength(), this.getProtocol()});
        }
    }
}

