/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.util.Bits;

final class ReqExclBulkScorer
extends BulkScorer {
    private final BulkScorer req;
    private final DocIdSetIterator excl;

    ReqExclBulkScorer(BulkScorer req, DocIdSetIterator excl) {
        this.req = req;
        this.excl = excl;
    }

    @Override
    public int score(LeafCollector collector, Bits acceptDocs, int min2, int max2) throws IOException {
        int upTo = min2;
        int exclDoc = this.excl.docID();
        while (upTo < max2) {
            if (exclDoc < upTo) {
                exclDoc = this.excl.advance(upTo);
            }
            if (exclDoc == upTo) {
                ++upTo;
                exclDoc = this.excl.nextDoc();
                continue;
            }
            upTo = this.req.score(collector, acceptDocs, upTo, Math.min(exclDoc, max2));
        }
        if (upTo == max2) {
            upTo = this.req.score(collector, acceptDocs, upTo, upTo);
        }
        return upTo;
    }

    @Override
    public long cost() {
        return this.req.cost();
    }
}

