/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.docvalues.DocTermsIndexDocValues;
import org.apache.lucene.queries.function.valuesource.FieldCacheSource;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public class BytesRefFieldSource
extends FieldCacheSource {
    public BytesRefFieldSource(String field) {
        super(field);
    }

    @Override
    public FunctionValues getValues(Map context2, LeafReaderContext readerContext) throws IOException {
        FieldInfo fieldInfo = readerContext.reader().getFieldInfos().fieldInfo(this.field);
        if (fieldInfo != null && fieldInfo.getDocValuesType() == DocValuesType.BINARY) {
            final BinaryDocValues binaryValues = DocValues.getBinary(readerContext.reader(), this.field);
            return new FunctionValues(){
                int lastDocID = -1;

                private BytesRef getValueForDoc(int doc) throws IOException {
                    if (doc < this.lastDocID) {
                        throw new IllegalArgumentException("docs were sent out-of-order: lastDocID=" + this.lastDocID + " vs docID=" + doc);
                    }
                    this.lastDocID = doc;
                    int curDocID = binaryValues.docID();
                    if (doc > curDocID) {
                        curDocID = binaryValues.advance(doc);
                    }
                    if (doc == curDocID) {
                        return binaryValues.binaryValue();
                    }
                    return null;
                }

                @Override
                public boolean exists(int doc) throws IOException {
                    return this.getValueForDoc(doc) != null;
                }

                @Override
                public boolean bytesVal(int doc, BytesRefBuilder target) throws IOException {
                    BytesRef value = this.getValueForDoc(doc);
                    if (value == null || value.length == 0) {
                        return false;
                    }
                    target.copyBytes(value);
                    return true;
                }

                @Override
                public String strVal(int doc) throws IOException {
                    BytesRefBuilder bytes = new BytesRefBuilder();
                    return this.bytesVal(doc, bytes) ? bytes.get().utf8ToString() : null;
                }

                @Override
                public Object objectVal(int doc) throws IOException {
                    return this.strVal(doc);
                }

                @Override
                public String toString(int doc) throws IOException {
                    return BytesRefFieldSource.this.description() + '=' + this.strVal(doc);
                }

                @Override
                public FunctionValues.ValueFiller getValueFiller() {
                    return new FunctionValues.ValueFiller(){
                        private final MutableValueStr mval = new MutableValueStr();

                        @Override
                        public MutableValue getValue() {
                            return this.mval;
                        }

                        @Override
                        public void fillValue(int doc) throws IOException {
                            BytesRef value = this.getValueForDoc(doc);
                            this.mval.exists = value != null;
                            this.mval.value.clear();
                            if (value != null) {
                                this.mval.value.copyBytes(value);
                            }
                        }
                    };
                }
            };
        }
        return new DocTermsIndexDocValues(this, readerContext, this.field){

            @Override
            protected String toTerm(String readableValue) {
                return readableValue;
            }

            @Override
            public Object objectVal(int doc) throws IOException {
                return this.strVal(doc);
            }

            @Override
            public String toString(int doc) throws IOException {
                return BytesRefFieldSource.this.description() + '=' + this.strVal(doc);
            }
        };
    }
}

