/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb2.xloader0;

import java.io.OutputStream;
import java.util.List;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.BitsLong;
import org.apache.jena.atlas.lib.DateTimeUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.dboe.base.file.Location;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIProvider;
import org.apache.jena.irix.SystemIRIx;
import org.apache.jena.riot.system.AsyncParser;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.system.progress.ProgressMonitor;
import org.apache.jena.system.progress.ProgressMonitorOutput;
import org.apache.jena.tdb2.DatabaseMgr;
import org.apache.jena.tdb2.TDB2;
import org.apache.jena.tdb2.solver.stats.Stats;
import org.apache.jena.tdb2.solver.stats.StatsCollectorNodeId;
import org.apache.jena.tdb2.store.DatasetGraphTDB;
import org.apache.jena.tdb2.store.NodeId;
import org.apache.jena.tdb2.store.nodetable.NodeTable;
import org.apache.jena.tdb2.store.nodetupletable.NodeTupleTable;
import org.apache.jena.tdb2.store.value.DoubleNode62;
import org.apache.jena.tdb2.sys.TDBInternal;
import org.apache.jena.tdb2.xloader0.BulkLoaderX0;
import org.apache.jena.tdb2.xloader0.WriteRows;
import org.slf4j.Logger;

public class ProcNodeTableDataBuilder {
    private static Logger cmdLog = TDB2.logLoader;

    public static void exec(String location, String dataFileTriples, String dataFileQuads, List<String> datafiles, boolean collectStats) {
        IRIProvider provider = SystemIRIx.getProvider();
        DatasetGraph dsg = DatabaseMgr.connectDatasetGraph(location);
        ProgressMonitorOutput monitor = ProgressMonitorOutput.create(cmdLog, "Data", (long)BulkLoaderX0.DataTick, BulkLoaderX0.DataSuperTick);
        OutputStream outputTriples = IO.openOutputFile(dataFileTriples);
        OutputStream outputQuads = IO.openOutputFile(dataFileQuads);
        dsg.executeWrite(() -> ProcNodeTableDataBuilder.build(dsg, monitor, outputTriples, outputQuads, datafiles));
        TDBInternal.expel(dsg);
        SystemIRIx.setProvider(provider);
    }

    private static void build(DatasetGraph dsg, ProgressMonitor monitor, OutputStream outputTriples, OutputStream outputQuads, List<String> datafiles) {
        Location location;
        DatasetGraphTDB dsgtdb = TDBInternal.getDatasetGraphTDB(dsg);
        NodeTableBuilder sink = new NodeTableBuilder(dsgtdb, monitor, outputTriples, outputQuads, false);
        Timer timer = new Timer();
        timer.startTimer();
        monitor.start();
        sink.startBulk();
        AsyncParser.asyncParse(datafiles, (StreamRDF)sink);
        sink.finishBulk();
        IO.close(outputTriples);
        IO.close(outputQuads);
        if (sink.getCollector() != null && !(location = dsgtdb.getLocation()).isMem()) {
            Stats.write(location.getPath("stats.opt"), sink.getCollector().results());
        }
        monitor.finish();
        long time = timer.endTimer();
        long total = monitor.getTicks();
        float elapsedSecs = (float)time / 1000.0f;
        float rate = elapsedSecs != 0.0f ? (float)total / elapsedSecs : 0.0f;
        String str2 = String.format("Total: %,d tuples : %,.2f seconds : %,.2f tuples/sec [%s]", total, Float.valueOf(elapsedSecs), Float.valueOf(rate), DateTimeUtils.nowAsString());
        cmdLog.info(str2);
    }

    static class NodeTableBuilder
    implements StreamRDF {
        private DatasetGraphTDB dsg;
        private NodeTable nodeTable;
        private WriteRows writerTriples;
        private WriteRows writerQuads;
        private ProgressMonitor monitor;
        private StatsCollectorNodeId stats;

        NodeTableBuilder(DatasetGraphTDB dsg, ProgressMonitor monitor, OutputStream outputTriples, OutputStream outputQuads, boolean collectStats) {
            this.dsg = dsg;
            this.monitor = monitor;
            NodeTupleTable ntt = dsg.getTripleTable().getNodeTupleTable();
            this.nodeTable = ntt.getNodeTable();
            this.writerTriples = new WriteRows(outputTriples, 3, 100000);
            this.writerQuads = new WriteRows(outputQuads, 4, 100000);
            if (collectStats) {
                this.stats = new StatsCollectorNodeId(this.nodeTable);
            }
        }

        public void startBulk() {
        }

        @Override
        public void start() {
        }

        @Override
        public void finish() {
        }

        public void finishBulk() {
            this.writerTriples.flush();
            this.writerQuads.flush();
            this.nodeTable.sync();
        }

        @Override
        public void triple(Triple triple) {
            Node s = triple.getSubject();
            Node p = triple.getPredicate();
            Node o = triple.getObject();
            this.process(Quad.tripleInQuad, s, p, o);
        }

        @Override
        public void quad(Quad quad) {
            Node s = quad.getSubject();
            Node p = quad.getPredicate();
            Node o = quad.getObject();
            Node g = null;
            if (!quad.isTriple() && !quad.isDefaultGraph()) {
                g = quad.getGraph();
            }
            this.process(g, s, p, o);
        }

        private static long encode(NodeId nodeId) {
            long x = nodeId.getPtrLocation();
            switch (nodeId.type()) {
                case PTR: {
                    return x;
                }
                case XSD_DOUBLE: {
                    x = DoubleNode62.insertType(x);
                    return x;
                }
            }
            x = BitsLong.pack(x, nodeId.getTypeValue(), 56, 62);
            x = BitsLong.set(x, 63);
            return x;
        }

        private void write(WriteRows out, NodeId nodeId) {
            long x = NodeTableBuilder.encode(nodeId);
            out.write(x);
        }

        private void process(Node g, Node s, Node p, Node o) {
            NodeId sId = this.nodeTable.getAllocateNodeId(s);
            NodeId pId = this.nodeTable.getAllocateNodeId(p);
            NodeId oId = this.nodeTable.getAllocateNodeId(o);
            if (g != null) {
                NodeId gId = this.nodeTable.getAllocateNodeId(g);
                this.write(this.writerQuads, gId);
                this.write(this.writerQuads, sId);
                this.write(this.writerQuads, pId);
                this.write(this.writerQuads, oId);
                this.writerQuads.endOfRow();
                if (this.stats != null) {
                    this.stats.record(gId, sId, pId, oId);
                }
            } else {
                this.write(this.writerTriples, sId);
                this.write(this.writerTriples, pId);
                this.write(this.writerTriples, oId);
                this.writerTriples.endOfRow();
                if (this.stats != null) {
                    this.stats.record((Object)null, sId, pId, oId);
                }
            }
            this.monitor.tick();
        }

        public StatsCollectorNodeId getCollector() {
            return this.stats;
        }

        @Override
        public void base(String base) {
        }

        @Override
        public void prefix(String prefix, String iri2) {
            this.dsg.prefixes().add(prefix, iri2);
        }
    }
}

