/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.util;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.core.QueryCheckException;
import org.apache.jena.sparql.lang.SPARQLParserRegistry;
import org.apache.jena.sparql.sse.SSE;
import org.apache.jena.sparql.sse.WriterSSE;

public class QueryUtils {
    public static void checkQuery(Query query2, boolean optimizeAlgebra) {
        QueryUtils.checkParse(query2);
        QueryUtils.checkOp(query2, optimizeAlgebra);
    }

    public static void checkOp(Query query2, boolean optimizeAlgebra) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        Op op = Algebra.compile(query2);
        if (optimizeAlgebra) {
            op = Algebra.optimize(op);
        }
        WriterSSE.out((IndentedWriter)buff, op, (Prologue)query2);
        String str2 = buff.toString();
        Op op2 = SSE.parseOp(str2);
        if (op.hashCode() != op2.hashCode()) {
            op.hashCode();
            op2.hashCode();
            QueryUtils.dump(op, op2);
            throw new QueryCheckException("reparsed algebra expression hashCode does not equal algebra from query");
        }
        if (!op.equals(op2)) {
            QueryUtils.dump(op, op2);
            throw new QueryCheckException("reparsed algebra expression does not equal query algebra");
        }
    }

    private static void dump(Op op, Op op2) {
        System.err.println("***********");
        System.err.println(op);
        System.err.println(op2);
        System.err.println("***********");
    }

    public static void checkParse(Query query2) {
        if (!SPARQLParserRegistry.get().containsFactory(query2.getSyntax())) {
            return;
        }
        IndentedLineBuffer buff = new IndentedLineBuffer();
        query2.serialize(buff, query2.getSyntax());
        String tmp = buff.toString();
        Query query22 = null;
        try {
            String baseURI = null;
            if (!query2.explicitlySetBaseURI()) {
                baseURI = query2.getBaseURI();
            }
            if ((query22 = QueryFactory.create(tmp, baseURI, query2.getSyntax())) == null) {
                return;
            }
        }
        catch (UnsupportedOperationException ex) {
            return;
        }
        catch (QueryException ex) {
            System.err.println(tmp);
            throw new QueryCheckException("could not parse output query", ex);
        }
        if (query2.hashCode() != query22.hashCode()) {
            throw new QueryCheckException("reparsed query hashCode does not equal parsed input query \nQuery (hashCode: " + query2.hashCode() + ")=\n" + query2 + "\n\nQuery2 (hashCode: " + query22.hashCode() + ")=\n" + query22);
        }
        if (!query2.equals(query22)) {
            throw new QueryCheckException("reparsed output does not equal parsed input");
        }
    }
}

