/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.function.library;

import java.util.List;
import org.apache.jena.atlas.lib.Cache;
import org.apache.jena.atlas.lib.CacheFactory;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionBase;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.util.Context;

public class FN_Apply
extends FunctionBase {
    private Cache<String, Function> cache1 = CacheFactory.createOneSlotCache();

    @Override
    public void checkBuild(String uri, ExprList args) {
        if (args.isEmpty()) {
            throw new ExprException("fn:apply: no function to call (minimum number of args is one)");
        }
    }

    @Override
    public NodeValue exec(List<NodeValue> args) {
        throw new InternalErrorException("fn:apply: exec(args) Should not have been called");
    }

    @Override
    public NodeValue exec(List<NodeValue> args, FunctionEnv env) {
        if (args.isEmpty()) {
            throw new ExprException("fn:apply: no function to call (minimum number of args is one)");
        }
        NodeValue functionId = args.get(0);
        List<NodeValue> argExprs = args.subList(1, args.size());
        ExprList exprs = new ExprList();
        argExprs.forEach(exprs::add);
        Node fnNode = functionId.asNode();
        if (fnNode.isBlank()) {
            throw new ExprEvalException("fn:apply: function id is a blank node (must be a URI)");
        }
        if (fnNode.isLiteral()) {
            throw new ExprEvalException("fn:apply: function id is a literal (must be a URI)");
        }
        if (fnNode.isVariable()) {
            throw new ExprEvalException("fn:apply: function id is an unbound variable (must be a URI)");
        }
        if (fnNode.isURI()) {
            String functionIRI = fnNode.getURI();
            Function function = this.cache1.getOrFill(functionIRI, () -> this.buildFunction(functionIRI, env));
            if (function == null) {
                throw new ExprEvalException("fn:apply: Unknown function: <" + functionId + ">");
            }
            if (function instanceof FunctionBase) {
                return ((FunctionBase)function).exec(argExprs);
            }
            function.build(functionIRI, exprs);
            return function.exec(null, exprs, functionIRI, null);
        }
        throw new ExprEvalException("fn:apply: Weird function argument (arg 1): " + functionId);
    }

    private Function buildFunction(String functionIRI, FunctionEnv functionEnv) {
        FunctionRegistry registry = this.chooseRegistry(functionEnv.getContext());
        FunctionFactory ff = registry.get(functionIRI);
        if (ff == null) {
            return null;
        }
        return ff.create(functionIRI);
    }

    private FunctionRegistry chooseRegistry(Context context2) {
        FunctionRegistry registry = FunctionRegistry.get(context2);
        if (registry == null) {
            registry = FunctionRegistry.get();
        }
        return registry;
    }
}

