/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.table;

import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.table.TableWriter;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingLib;
import org.apache.jena.sparql.engine.ref.Evaluator;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.RowSetStream;

public abstract class TableBase
implements Table {
    protected TableBase() {
    }

    @Override
    public final void close() {
        this.closeTable();
    }

    protected abstract void closeTable();

    public final Table eval(Evaluator evaluator) {
        return this;
    }

    @Override
    public void addBinding(Binding binding) {
        throw new UnsupportedOperationException("Table.add");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Binding b) {
        try (QueryIterator qIter = this.iterator(null);){
            while (qIter.hasNext()) {
                Binding b2 = qIter.nextBinding();
                if (!BindingLib.equals(b, b2)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public RowSet toRowSet() {
        return new RowSetStream(this.getVars(), this.rows());
    }

    @Override
    public abstract int size();

    @Override
    public abstract boolean isEmpty();

    public String toString() {
        return TableWriter.asSSE(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        int hash = 0;
        Iterator<Binding> iter = this.rows();
        try {
            while (iter.hasNext()) {
                Binding binding = iter.next();
                hash ^= binding.hashCode();
            }
            int n = hash;
            return n;
        }
        finally {
            Iter.close(iter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Table)) {
            return false;
        }
        Table table = (Table)other;
        if (table.size() != this.size()) {
            return false;
        }
        if (!table.getVars().equals(this.getVars())) {
            return false;
        }
        Iterator<Binding> iter1 = this.rows();
        Iterator<Binding> iter2 = table.rows();
        try {
            while (iter1.hasNext()) {
                Binding bind2;
                Binding bind1 = iter1.next();
                if (BindingLib.equals(bind1, bind2 = iter2.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            Iter.close(iter1);
            Iter.close(iter2);
        }
    }
}

