/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.ShexException;
import org.apache.jena.shex.sys.ShexLib;

public class ValueSetItem {
    String iriStr;
    String langStr;
    Node literal;
    boolean isStem;

    public ValueSetItem(String iriStr, String lang, Node literal, boolean isStem) {
        this.iriStr = iriStr;
        this.langStr = lang;
        this.literal = literal;
        this.isStem = isStem;
        if (literal != null && !literal.isLiteral()) {
            throw new ShexException("Not literal: " + ShexLib.displayStr(literal));
        }
    }

    public void print(IndentedWriter out, NodeFormatter nFmt) {
        if (this.iriStr != null) {
            out.printf("<%s>", this.iriStr);
        } else if (this.langStr != null) {
            out.printf("@%s", this.langStr);
        } else if (this.literal != null) {
            nFmt.format(out, this.literal);
        }
        if (this.isStem) {
            out.print("~");
        }
    }

    public String toString() {
        Object str2 = "invalid";
        if (this.iriStr != null) {
            str2 = "<" + this.iriStr + ">";
        } else if (this.langStr != null) {
            str2 = "@" + this.langStr;
        } else if (this.literal != null) {
            str2 = ShexLib.strDatatype(this.literal);
        }
        if (this.isStem) {
            str2 = (String)str2 + "~";
        }
        return str2;
    }

    public int hashCode() {
        return Objects.hash(this.iriStr, this.isStem, this.langStr, this.literal);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueSetItem other = (ValueSetItem)obj;
        return Objects.equals(this.iriStr, other.iriStr) && this.isStem == other.isStem && Objects.equals(this.langStr, other.langStr) && Objects.equals(this.literal, other.literal);
    }
}

