/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.resultset;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.resultset.ResultSetLang;
import org.apache.jena.riot.resultset.ResultSetWriterFactory;
import org.apache.jena.riot.resultset.rw.ResultSetWriterCSV;
import org.apache.jena.riot.resultset.rw.ResultSetWriterJSON;
import org.apache.jena.riot.resultset.rw.ResultSetWriterNone;
import org.apache.jena.riot.resultset.rw.ResultSetWriterTSV;
import org.apache.jena.riot.resultset.rw.ResultSetWriterText;
import org.apache.jena.riot.resultset.rw.ResultSetWriterThrift;
import org.apache.jena.riot.resultset.rw.ResultSetWriterXML;

public class ResultSetWriterRegistry {
    private static Map<Lang, ResultSetWriterFactory> registry = new ConcurrentHashMap<Lang, ResultSetWriterFactory>();
    private static boolean initialized = false;

    public static ResultSetWriterFactory getFactory(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.get(lang);
    }

    public static boolean isRegistered(Lang lang) {
        Objects.requireNonNull(lang);
        return registry.containsKey(lang);
    }

    public static void register(Lang lang, ResultSetWriterFactory factory) {
        Objects.requireNonNull(lang);
        Objects.requireNonNull(factory);
        registry.put(lang, factory);
    }

    public static void init() {
        if (initialized) {
            return;
        }
        initialized = true;
        ResultSetWriterRegistry.register(ResultSetLang.RS_XML, ResultSetWriterXML.factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_JSON, ResultSetWriterJSON.factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_Thrift, ResultSetWriterThrift.factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_CSV, ResultSetWriterCSV.factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_TSV, ResultSetWriterTSV.factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_Text, ResultSetWriterText.factory);
        ResultSetWriterRegistry.register(ResultSetLang.RS_None, ResultSetWriterNone.factory);
    }
}

