/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.graph;

import java.util.Objects;
import org.apache.jena.datatypes.DatatypeFormatException;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Node_Blank;
import org.apache.jena.graph.Node_Graph;
import org.apache.jena.graph.Node_Literal;
import org.apache.jena.graph.Node_Marker;
import org.apache.jena.graph.Node_Triple;
import org.apache.jena.graph.Node_URI;
import org.apache.jena.graph.Node_Variable;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.graph.impl.LiteralLabelFactory;
import org.apache.jena.sys.JenaSystem;

public class NodeFactory {
    public static RDFDatatype getType(String s) {
        if (s == null) {
            return null;
        }
        return TypeMapper.getInstance().getSafeTypeByName(s);
    }

    public static Node createBlankNode() {
        return NodeFactory.createBlankNode(BlankNodeId.create());
    }

    public static Node createBlankNode(BlankNodeId id) {
        Objects.requireNonNull(id, "Argument to NodeFactory.createBlankNode is null");
        return new Node_Blank(id);
    }

    public static Node createBlankNode(String string) {
        BlankNodeId id = BlankNodeId.create(string);
        return new Node_Blank(id);
    }

    public static Node createLiteral(LiteralLabel lit) {
        Objects.requireNonNull(lit, "Argument to NodeFactory.createLiteral is null");
        return new Node_Literal(lit);
    }

    public static Node createURI(String uri) {
        Objects.requireNonNull(uri, "Argument to NodeFactory.createURI is null");
        return new Node_URI(uri);
    }

    public static Node createVariable(String name) {
        Objects.requireNonNull(name, "Argument to NodeFactory.createVariable is null");
        return new Node_Variable(name);
    }

    public static Node createExt(String name) {
        Objects.requireNonNull(name, "Argument to NodeFactory.createExt is null");
        return new Node_Marker(name);
    }

    public static Node createLiteral(String value) {
        Objects.requireNonNull(value, "Argument to NodeFactory.createLiteral is null");
        return NodeFactory.createLiteral(value, "", false);
    }

    public static Node createLiteral(String lex, String lang, boolean isXml) {
        if (lex == null) {
            throw new NullPointerException("null lexical form for literal");
        }
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, lang, isXml));
    }

    public static Node createLiteral(String lex, String lang) {
        if (lex == null) {
            throw new NullPointerException("null lexical form for literal");
        }
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, lang));
    }

    public static Node createLiteral(String lex, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createLiteral(LiteralLabelFactory.createLiteralLabel(lex, lang, dtype));
    }

    public static Node createLiteral(String lex, RDFDatatype dtype) throws DatatypeFormatException {
        return NodeFactory.createLiteral(LiteralLabelFactory.create(lex, dtype));
    }

    public static Node createLiteralByValue(Object value, RDFDatatype dtype) throws DatatypeFormatException {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return new Node_Literal(LiteralLabelFactory.createByValue(value, "", dtype));
    }

    public static Node createLiteralByValue(Object value, String lang, RDFDatatype dtype) throws DatatypeFormatException {
        Objects.requireNonNull(value, "Argument 'value' to NodeFactory.createLiteralByValue is null");
        return new Node_Literal(LiteralLabelFactory.createByValue(value, lang, dtype));
    }

    public static Node createTripleNode(Node s, Node p, Node o) {
        Triple triple = Triple.create(s, p, o);
        return NodeFactory.createTripleNode(triple);
    }

    public static Node createTripleNode(Triple triple) {
        return new Node_Triple(triple);
    }

    public static Node createGraphNode(Graph graph) {
        return new Node_Graph(graph);
    }

    static {
        JenaSystem.init();
    }
}

