/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.server;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.fuseki.server.Counter;
import org.apache.jena.fuseki.server.CounterName;

public class CounterSet {
    private Map<CounterName, Counter> counters = new HashMap<CounterName, Counter>();

    public Collection<CounterName> counters() {
        return this.counters.keySet();
    }

    public void inc(CounterName c) {
        this.get(c).inc();
    }

    public void dec(CounterName c) {
        this.get(c).dec();
    }

    public long value(CounterName c) {
        return this.get(c).value();
    }

    public void add(CounterName counterName) {
        if (this.counters.containsKey(counterName)) {
            Log.warn(CounterSet.class, "Duplicate counter in counter set: " + counterName);
            return;
        }
        this.counters.put(counterName, new Counter());
    }

    public boolean contains(CounterName cn) {
        return this.counters.containsKey(cn);
    }

    public Counter get(CounterName cn) {
        Counter c = this.counters.get(cn);
        if (c == null) {
            Log.warn(CounterSet.class, "No counter in counter set: " + cn);
        }
        return c;
    }
}

