/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.ctl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.ext.com.google.common.collect.Multimap;
import org.apache.jena.fuseki.system.FusekiNetLib;

public class ActionDumpRequest
extends HttpServlet {
    @Override
    public void doGet(HttpServletRequest req, HttpServletResponse resp) {
        this.doPrintInformation(req, resp);
    }

    @Override
    public void doPost(HttpServletRequest req, HttpServletResponse resp) {
        this.doPrintInformation(req, resp);
    }

    public void doPrintInformation(HttpServletRequest req, HttpServletResponse resp) {
        try {
            PrintWriter out = resp.getWriter();
            resp.setContentType("text/html");
            String now2 = new Date().toString();
            out.println("<html>");
            out.println("<head>");
            out.println("<Title>Dump @ " + now2 + "</Title>");
            out.println("<meta CONTENT=now HTTP-EQUIV=expires>");
            out.println("</head>");
            out.println("<body>");
            out.println("<pre>");
            out.println("Dump : " + now2);
            out.println();
            out.println("==== Request");
            out.println();
            ActionDumpRequest.printRequest(out, req);
            out.println();
            out.println(">>>> Body");
            out.println();
            ActionDumpRequest.printBody(out, req);
            out.println("<<<< Body");
            out.println("</pre>");
            out.println("</body>");
            out.println("</html>");
            out.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void printRequest(PrintWriter pw, HttpServletRequest req) {
        pw.println("Method:                 " + req.getMethod());
        pw.println("getContentLength:       " + Long.toString(req.getContentLengthLong()));
        pw.println("getContentType:         " + req.getContentType());
        pw.println("getRequestURI:          " + req.getRequestURI());
        pw.println("getRequestURL:          " + req.getRequestURL());
        pw.println("getContextPath:         " + req.getContextPath());
        pw.println("getServletPath:         " + req.getServletPath());
        pw.println("getPathInfo:            " + req.getPathInfo());
        pw.println("getPathTranslated:      " + req.getPathTranslated());
        pw.println("getQueryString:         " + req.getQueryString());
        pw.println("getProtocol:            " + req.getProtocol());
        pw.println("getScheme:              " + req.getScheme());
        pw.println("getServerName:          " + req.getServerName());
        pw.println("getServerPort:          " + req.getServerPort());
        pw.println("getRemoteUser:          " + req.getRemoteUser());
        pw.println("getRemoteAddr:          " + req.getRemoteAddr());
        pw.println("getRemoteHost:          " + req.getRemoteHost());
        pw.println("getRequestedSessionId:  " + req.getRequestedSessionId());
    }

    static void printBody(PrintWriter pw, HttpServletRequest req) throws IOException {
        String x;
        BufferedReader in = req.getReader();
        while ((x = in.readLine()) != null) {
            x = x.replaceAll("&", "&amp;");
            x = x.replaceAll("<", "&lt;");
            x = x.replaceAll(">", "&gt;");
            pw.println(x);
        }
    }

    static void printCookies(PrintWriter pw, HttpServletRequest req) {
        Cookie[] c = req.getCookies();
        if (c == null) {
            pw.println("getCookies:            <none>");
        } else {
            for (int i = 0; i < c.length; ++i) {
                pw.println();
                pw.println("Cookie:        " + c[i].getName());
                pw.println("    value:     " + c[i].getValue());
                pw.println("    version:   " + c[i].getVersion());
                pw.println("    comment:   " + c[i].getComment());
                pw.println("    domain:    " + c[i].getDomain());
                pw.println("    maxAge:    " + c[i].getMaxAge());
                pw.println("    path:      " + c[i].getPath());
                pw.println("    secure:    " + c[i].getSecure());
            }
        }
    }

    static void printHeaders(PrintWriter pw, HttpServletRequest req) {
        Enumeration<String> en = req.getHeaderNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            String value = req.getHeader(name);
            pw.println("Head: " + name + " = " + value);
        }
    }

    static void printParameters(PrintWriter pw, HttpServletRequest req) {
        Enumeration<String> en = req.getParameterNames();
        while (en.hasMoreElements()) {
            String name = en.nextElement();
            String value = req.getParameter(name);
            pw.println("Param: " + name + " = " + value);
        }
    }

    static void printQueryString(PrintWriter pw, HttpServletRequest req) {
        Multimap<String, String> map = FusekiNetLib.parseQueryString(req);
        for (String name : map.keys()) {
            for (String value : map.get(name)) {
                pw.println("Param: " + name + " = " + value);
            }
        }
    }

    static void printLocales(PrintWriter pw, HttpServletRequest req) {
        Enumeration<Locale> en = req.getLocales();
        while (en.hasMoreElements()) {
            String name = en.nextElement().toString();
            pw.println("Locale: " + name);
        }
        pw.println();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String printEnvironment() {
        Properties properties = System.getProperties();
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                Enumeration<Object> en = properties.keys();
                while (en.hasMoreElements()) {
                    String key = en.nextElement().toString();
                    pw.println(key + ": '" + properties.getProperty(key) + "'");
                }
                pw.println();
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            IO.exception(e2);
            return null;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String printServletContext() {
        try (StringWriter sw = new StringWriter();){
            PrintWriter pw = new PrintWriter(sw);
            try {
                String key;
                ServletContext sc = this.getServletContext();
                pw.println("majorVersion: '" + sc.getMajorVersion() + "'");
                pw.println("minorVersion: '" + sc.getMinorVersion() + "'");
                pw.println("contextName:  '" + sc.getServletContextName() + "'");
                pw.println("servletInfo:  '" + this.getServletInfo() + "'");
                pw.println("serverInfo:  '" + sc.getServerInfo() + "'");
                Enumeration<String> en = sc.getInitParameterNames();
                if (en != null) {
                    pw.println("initParameters: ");
                    while (en.hasMoreElements()) {
                        key = en.nextElement();
                        pw.println(key + ": '" + sc.getInitParameter(key) + "'");
                    }
                }
                if ((en = sc.getAttributeNames()) != null) {
                    pw.println("attributes: ");
                    while (en.hasMoreElements()) {
                        key = en.nextElement();
                        pw.println(key + ": '" + sc.getAttribute(key) + "'");
                    }
                }
                pw.println();
                String string = sw.toString();
                pw.close();
                return string;
            }
            catch (Throwable throwable) {
                try {
                    pw.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e2) {
            IO.exception(e2);
            return null;
        }
    }

    @Override
    public String getServletInfo() {
        return "Dump";
    }
}

