/*
 * Decompiled with CFR 0.152.
 */
package jena;

import java.io.BufferedReader;
import java.io.File;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.jena.atlas.logging.LogCtl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.InfModel;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.reasoner.rulesys.BuiltinException;
import org.apache.jena.reasoner.rulesys.BuiltinRegistry;
import org.apache.jena.reasoner.rulesys.FBRuleInfGraph;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.reasoner.rulesys.RuleContext;
import org.apache.jena.reasoner.rulesys.builtins.BaseBuiltin;
import org.apache.jena.util.FileUtils;

public class RuleMap {
    public static List<Rule> loadRules(String filename, Map<String, String> prefixes) {
        Object fname = filename;
        if (((String)fname).startsWith("file:///")) {
            fname = File.separator + ((String)fname).substring(8);
        } else if (((String)fname).startsWith("file:/")) {
            fname = File.separator + ((String)fname).substring(6);
        } else if (((String)fname).startsWith("file:")) {
            fname = ((String)fname).substring(5);
        }
        BufferedReader src = FileUtils.openResourceFile((String)fname);
        return RuleMap.loadRules(src, prefixes);
    }

    public static List<Rule> loadRules(BufferedReader src, Map<String, String> prefixes) {
        Rule.Parser parser = Rule.rulesParserFromReader(src);
        List<Rule> rules = Rule.parseRules(parser);
        prefixes.putAll(parser.getPrefixMap());
        return rules;
    }

    public static void main(String[] args) {
        try {
            String usage = "Usage:  RuleMap [-il inlang] [-ol outlang] [-d] rulefile infile (- for stdin)";
            DefaultParser parser = new DefaultParser();
            Options options = new Options().addOption("il", "inputLang", true, "input language").addOption("ol", "outputLang", true, "output language").addOption("d", "Deductions only?");
            CommandLine cl = parser.parse(options, args);
            List<String> filenameArgs = cl.getArgList();
            if (filenameArgs.size() != 2) {
                System.err.println(usage);
                System.exit(1);
            }
            String inLang = cl.getOptionValue("inputLang");
            String fname = filenameArgs.get(1);
            Model inModel = ModelFactory.createDefaultModel();
            if (fname.equals("-")) {
                inModel.read(System.in, null, inLang);
            } else {
                inModel.read(fname, inLang);
            }
            String outLang = cl.hasOption("outputLang") ? cl.getOptionValue("outputLang") : "N3";
            boolean deductionsOnly = cl.hasOption('d');
            BuiltinRegistry.theRegistry.register(new Deduce());
            HashMap<String, String> prefixes = new HashMap<String, String>();
            List<Rule> rules = RuleMap.loadRules(filenameArgs.get(0), prefixes);
            GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
            InfModel infModel = ModelFactory.createInfModel(reasoner, inModel);
            infModel.prepare();
            infModel.setNsPrefixes(prefixes);
            try (PrintWriter writer = new PrintWriter(System.out);){
                if (deductionsOnly) {
                    Model deductions = infModel.getDeductionsModel();
                    deductions.setNsPrefixes(prefixes);
                    deductions.setNsPrefixes(inModel);
                    deductions.write(writer, outLang);
                } else {
                    infModel.write(writer, outLang);
                }
            }
        }
        catch (Throwable t) {
            System.err.println("An error occured: \n" + t);
            t.printStackTrace();
        }
    }

    static {
        LogCtl.setLogging();
    }

    static class Deduce
    extends BaseBuiltin {
        Deduce() {
        }

        @Override
        public String getName() {
            return "deduce";
        }

        @Override
        public int getArgLength() {
            return 3;
        }

        @Override
        public void headAction(Node[] args, int length, RuleContext context2) {
            if (!(context2.getGraph() instanceof FBRuleInfGraph)) {
                throw new BuiltinException(this, context2, "Only usable in FBrule graphs");
            }
            Triple t = new Triple(args[0], args[1], args[2]);
            ((FBRuleInfGraph)context2.getGraph()).addDeduction(t);
        }
    }
}

