/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.uri;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.lang.Keywords;
import java.net.URI;

public final class UriUtils {
    private UriUtils() {
    }

    public static final boolean isURI(String value) {
        return value != null && StringUtils.isNotBlank(value) && !Keywords.matchForm(StringUtils.strip(value)) && UriUtils.create(StringUtils.strip(value)) != null;
    }

    public static final URI create(String uri) {
        if (uri == null) {
            throw new IllegalArgumentException("The uri cannot be null.");
        }
        Object uriValue = StringUtils.strip(uri);
        if (uri.endsWith(":")) {
            uriValue = uri + ".";
        } else if (uri.endsWith("[") || uri.endsWith("]")) {
            uriValue = uri.substring(0, uri.length() - 1);
        }
        try {
            return URI.create((String)uriValue);
        }
        catch (IllegalArgumentException e2) {
            return null;
        }
    }

    public static final boolean endsWithGenDelim(String uri) {
        return uri.endsWith(":") || uri.endsWith("/") || uri.endsWith("?") || uri.endsWith("#") || uri.endsWith("[") || uri.endsWith("]") || uri.endsWith("@");
    }

    public static final boolean isNotURI(String uri) {
        return uri == null || StringUtils.isNotBlank(uri) && (Keywords.matchForm(StringUtils.strip(uri)) || UriUtils.create(StringUtils.strip(uri)) == null);
    }

    public static final boolean isNotAbsoluteUri(String uri) {
        return !UriUtils.isAbsoluteUri(uri);
    }

    public static final boolean isAbsoluteUri(String uri) {
        try {
            return URI.create(uri).isAbsolute();
        }
        catch (IllegalArgumentException e2) {
            return false;
        }
    }

    protected static final String recompose(String scheme, String authority, String path, String query2, String fragment) {
        StringBuilder builder = new StringBuilder();
        if (UriUtils.isDefined(scheme)) {
            builder.append(scheme);
            builder.append(":");
        }
        if (authority != null) {
            builder.append("//");
            builder.append(authority);
        }
        if (UriUtils.isDefined(path)) {
            builder.append(path);
        }
        if (UriUtils.isDefined(query2)) {
            builder.append('?');
            builder.append(query2);
        }
        if (UriUtils.isDefined(fragment)) {
            builder.append('#');
            builder.append(fragment);
        }
        return builder.toString();
    }

    protected static final boolean isDefined(String value) {
        return value != null && StringUtils.isNotBlank(value);
    }

    protected static final boolean isNotDefined(String value) {
        return value == null || StringUtils.isBlank(value);
    }
}

