/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.Keywords;
import com.apicatalog.jsonld.lang.ValueObject;
import com.apicatalog.jsonld.uri.UriUtils;
import jakarta.json.JsonObject;
import jakarta.json.JsonValue;
import java.util.Arrays;
import java.util.Map;

public final class NodeObject {
    private NodeObject() {
    }

    public static final boolean isNodeObject(JsonValue value) {
        return JsonUtils.isObject(value) && (!value.asJsonObject().containsKey("@value") && !value.asJsonObject().containsKey("@list") && !value.asJsonObject().containsKey("@set") || Arrays.asList("@context", "@graph").containsAll(value.asJsonObject().keySet()));
    }

    public static final boolean isNotNodeObject(JsonValue value) {
        return !NodeObject.isNodeObject(value);
    }

    public static final boolean isNodeReference(JsonValue value) {
        return JsonUtils.isObject(value) && value.asJsonObject().size() == 1 && value.asJsonObject().containsKey("@id");
    }

    public static final boolean isEmbeddedNode(JsonValue value) {
        if (JsonUtils.isNotObject(value)) {
            return false;
        }
        JsonObject node = value.asJsonObject();
        boolean found = false;
        for (Map.Entry property : node.entrySet()) {
            if (((String)property.getKey()).equals("@index") || ((String)property.getKey()).equals("@context") || ((String)property.getKey()).equals("@reverse")) {
                return false;
            }
            if (!"@type".equals(property.getKey()) && Keywords.matchForm((String)property.getKey())) continue;
            if (!found && ("@type".equals(property.getKey()) || UriUtils.isURI((String)property.getKey()))) {
                JsonValue propertyValue = (JsonValue)property.getValue();
                if (JsonUtils.isArray(propertyValue)) {
                    if (propertyValue.asJsonArray().size() != 1) {
                        return false;
                    }
                    propertyValue = (JsonValue)propertyValue.asJsonArray().get(0);
                }
                if (ValueObject.isValueObject(propertyValue)) {
                    propertyValue = ValueObject.getValue(propertyValue).orElse(null);
                }
                if (JsonUtils.isString(propertyValue) || JsonUtils.isObject(propertyValue) && NodeObject.isEmbeddedNode(propertyValue.asJsonObject())) {
                    found = true;
                    continue;
                }
            }
            return false;
        }
        return true;
    }

    public static final boolean isNotAnnotationObject(JsonValue annotation) {
        return !NodeObject.isAnnotationObject(annotation);
    }

    public static final boolean isAnnotationObject(JsonValue annotation) {
        JsonValue value = annotation;
        if (JsonUtils.isArray(value)) {
            return value.asJsonArray().stream().allMatch(NodeObject::isAnnotationObject);
        }
        if (JsonUtils.isNotObject(value)) {
            return false;
        }
        for (Map.Entry property : value.asJsonObject().entrySet()) {
            if ("@annotation".equals(property.getKey()) && !NodeObject.isAnnotationObject((JsonValue)property.getValue())) {
                return false;
            }
            if (!Keywords.matchForm((String)property.getKey()) || "@type".equals(property.getKey()) || "@reverse".equals(property.getKey())) continue;
            return false;
        }
        return true;
    }
}

