/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.Prologue;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.util.QueryExecUtils;

public class ModResultsOut
extends ModBase {
    protected final ArgDecl resultsFmtDecl = new ArgDecl(true, "results", "out", "rfmt");
    private ResultsFormat resultsFormat = ResultsFormat.FMT_UNKNOWN;

    @Override
    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.resultsFmtDecl)) {
            String rFmt = cmdline.getValue(this.resultsFmtDecl);
            this.resultsFormat = ResultsFormat.lookup(rFmt);
            if (this.resultsFormat == null) {
                cmdline.cmdError("Unrecognized output format: " + rFmt);
            }
        }
    }

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Results");
        cmdLine.add(this.resultsFmtDecl, "--results=", "Results format (Result set: text, XML, JSON, CSV, TSV; Graph: RDF serialization)");
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    public void printResultSet(ResultSet resultSet, Prologue prologue) {
        QueryExecUtils.outputResultSet(resultSet, prologue, this.resultsFormat, System.out);
    }

    public ResultsFormat getResultsFormat() {
        return this.resultsFormat;
    }
}

