/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import java.io.PrintStream;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdArgModule;
import org.apache.jena.cmd.CmdGeneral;
import org.apache.jena.cmd.ModBase;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.MappingRegistry;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.sys.JenaSystem;

public class ModContext
extends ModBase {
    protected final ArgDecl setDecl = new ArgDecl(true, "set", "define", "defn", "def");
    private Context context = new Context();

    @Override
    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Symbol definition");
        cmdLine.add(this.setDecl, "--set", "Set a configuration symbol to a value");
    }

    public void checkCommandLine(CmdArgModule cmdLine) {
    }

    @Override
    public void processArgs(CmdArgModule cmdLine) {
        if (cmdLine.getValues(this.setDecl) == null || cmdLine.getValues(this.setDecl).size() == 0) {
            return;
        }
        for (String arg : cmdLine.getValues(this.setDecl)) {
            String[] frags = arg.split("=", 2);
            if (frags.length != 2) {
                throw new RuntimeException("Can't split '" + arg + "' -- looking for '=' to separate name and value");
            }
            String symbolName = frags[0];
            String value = frags[1];
            symbolName = MappingRegistry.mapPrefixName(symbolName);
            Symbol symbol = Symbol.create(symbolName);
            this.context.set(symbol, value);
        }
        ARQ.getContext().putAll(this.context);
    }

    public void verbose() {
        this.verbose(System.out);
    }

    public void verbose(PrintStream stream) {
        IndentedWriter out = new IndentedWriter(stream);
        this.verbose(out);
        out.flush();
    }

    public void verbose(IndentedWriter out) {
        for (Symbol symbol : this.context.keys()) {
            String value = this.context.getAsString(symbol);
            out.println(symbol + " -> " + value);
        }
    }

    static {
        JenaSystem.init();
    }
}

