# coding: utf-8

"""
    Lightly API

    Lightly.ai enables you to do self-supervised learning in an easy and intuitive way. The lightly.ai OpenAPI spec defines how one can interact with our REST API to unleash the full potential of lightly.ai  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@lightly.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from lightly.openapi_generated.swagger_client.configuration import Configuration


class SampleCreateRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'file_name': 'str',
        'thumb_name': 'str',
        'exif': 'dict(str, object)',
        'meta_data': 'SampleMetaData',
        'custom_meta_data': 'CustomSampleMetaData'
    }

    attribute_map = {
        'file_name': 'fileName',
        'thumb_name': 'thumbName',
        'exif': 'exif',
        'meta_data': 'metaData',
        'custom_meta_data': 'customMetaData'
    }

    def __init__(self, file_name=None, thumb_name=None, exif=None, meta_data=None, custom_meta_data=None, _configuration=None):  # noqa: E501
        """SampleCreateRequest - a model defined in Swagger"""  # noqa: E501
        if _configuration is None:
            _configuration = Configuration()
        self._configuration = _configuration

        self._file_name = None
        self._thumb_name = None
        self._exif = None
        self._meta_data = None
        self._custom_meta_data = None
        self.discriminator = None

        self.file_name = file_name
        if thumb_name is not None:
            self.thumb_name = thumb_name
        if exif is not None:
            self.exif = exif
        if meta_data is not None:
            self.meta_data = meta_data
        if custom_meta_data is not None:
            self.custom_meta_data = custom_meta_data

    @property
    def file_name(self):
        """Gets the file_name of this SampleCreateRequest.  # noqa: E501


        :return: The file_name of this SampleCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._file_name

    @file_name.setter
    def file_name(self, file_name):
        """Sets the file_name of this SampleCreateRequest.


        :param file_name: The file_name of this SampleCreateRequest.  # noqa: E501
        :type: str
        """
        if self._configuration.client_side_validation and file_name is None:
            raise ValueError("Invalid value for `file_name`, must not be `None`")  # noqa: E501

        self._file_name = file_name

    @property
    def thumb_name(self):
        """Gets the thumb_name of this SampleCreateRequest.  # noqa: E501


        :return: The thumb_name of this SampleCreateRequest.  # noqa: E501
        :rtype: str
        """
        return self._thumb_name

    @thumb_name.setter
    def thumb_name(self, thumb_name):
        """Sets the thumb_name of this SampleCreateRequest.


        :param thumb_name: The thumb_name of this SampleCreateRequest.  # noqa: E501
        :type: str
        """

        self._thumb_name = thumb_name

    @property
    def exif(self):
        """Gets the exif of this SampleCreateRequest.  # noqa: E501


        :return: The exif of this SampleCreateRequest.  # noqa: E501
        :rtype: dict(str, object)
        """
        return self._exif

    @exif.setter
    def exif(self, exif):
        """Sets the exif of this SampleCreateRequest.


        :param exif: The exif of this SampleCreateRequest.  # noqa: E501
        :type: dict(str, object)
        """

        self._exif = exif

    @property
    def meta_data(self):
        """Gets the meta_data of this SampleCreateRequest.  # noqa: E501


        :return: The meta_data of this SampleCreateRequest.  # noqa: E501
        :rtype: SampleMetaData
        """
        return self._meta_data

    @meta_data.setter
    def meta_data(self, meta_data):
        """Sets the meta_data of this SampleCreateRequest.


        :param meta_data: The meta_data of this SampleCreateRequest.  # noqa: E501
        :type: SampleMetaData
        """

        self._meta_data = meta_data

    @property
    def custom_meta_data(self):
        """Gets the custom_meta_data of this SampleCreateRequest.  # noqa: E501


        :return: The custom_meta_data of this SampleCreateRequest.  # noqa: E501
        :rtype: CustomSampleMetaData
        """
        return self._custom_meta_data

    @custom_meta_data.setter
    def custom_meta_data(self, custom_meta_data):
        """Sets the custom_meta_data of this SampleCreateRequest.


        :param custom_meta_data: The custom_meta_data of this SampleCreateRequest.  # noqa: E501
        :type: CustomSampleMetaData
        """

        self._custom_meta_data = custom_meta_data

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(SampleCreateRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SampleCreateRequest):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, SampleCreateRequest):
            return True

        return self.to_dict() != other.to_dict()
