# pulp_file-client
Fetch, Upload, Organize, and Distribute Software Packages

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: v3
- Package version: 1.10.5
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://pulpproject.org](https://pulpproject.org)

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import pulpcore.client.pulp_file
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pulpcore.client.pulp_file
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import pulpcore.client.pulp_file
from pulpcore.client.pulp_file.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://pulp
# See configuration.py for a list of all supported configuration parameters.
configuration = pulpcore.client.pulp_file.Configuration(
    host = "https://pulp"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure HTTP basic authorization: basicAuth
configuration = pulpcore.client.pulp_file.Configuration(
    username = 'YOUR_USERNAME',
    password = 'YOUR_PASSWORD'
)

# Configure API key authorization: cookieAuth
configuration = pulpcore.client.pulp_file.Configuration(
    host = "https://pulp",
    api_key = {
        'sessionid': 'YOUR_API_KEY'
    }
)
# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['sessionid'] = 'Bearer'


# Enter a context with an instance of the API client
with pulpcore.client.pulp_file.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pulpcore.client.pulp_file.AcsFileApi(api_client)
    file_file_alternate_content_source = pulpcore.client.pulp_file.FileFileAlternateContentSource() # FileFileAlternateContentSource | 

    try:
        # Create a file alternate content source
        api_response = api_instance.create(file_file_alternate_content_source)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AcsFileApi->create: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *https://pulp*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AcsFileApi* | [**create**](docs/AcsFileApi.md#create) | **POST** /pulp/api/v3/acs/file/file/ | Create a file alternate content source
*AcsFileApi* | [**delete**](docs/AcsFileApi.md#delete) | **DELETE** {file_file_alternate_content_source_href} | Delete a file alternate content source
*AcsFileApi* | [**list**](docs/AcsFileApi.md#list) | **GET** /pulp/api/v3/acs/file/file/ | List file alternate content sources
*AcsFileApi* | [**partial_update**](docs/AcsFileApi.md#partial_update) | **PATCH** {file_file_alternate_content_source_href} | Update a file alternate content source
*AcsFileApi* | [**read**](docs/AcsFileApi.md#read) | **GET** {file_file_alternate_content_source_href} | Inspect a file alternate content source
*AcsFileApi* | [**refresh**](docs/AcsFileApi.md#refresh) | **POST** {file_file_alternate_content_source_href}refresh/ | 
*AcsFileApi* | [**update**](docs/AcsFileApi.md#update) | **PUT** {file_file_alternate_content_source_href} | Update a file alternate content source
*ContentFilesApi* | [**create**](docs/ContentFilesApi.md#create) | **POST** /pulp/api/v3/content/file/files/ | Create a file content
*ContentFilesApi* | [**list**](docs/ContentFilesApi.md#list) | **GET** /pulp/api/v3/content/file/files/ | List file contents
*ContentFilesApi* | [**read**](docs/ContentFilesApi.md#read) | **GET** {file_file_content_href} | Inspect a file content
*DistributionsFileApi* | [**create**](docs/DistributionsFileApi.md#create) | **POST** /pulp/api/v3/distributions/file/file/ | Create a file distribution
*DistributionsFileApi* | [**delete**](docs/DistributionsFileApi.md#delete) | **DELETE** {file_file_distribution_href} | Delete a file distribution
*DistributionsFileApi* | [**list**](docs/DistributionsFileApi.md#list) | **GET** /pulp/api/v3/distributions/file/file/ | List file distributions
*DistributionsFileApi* | [**partial_update**](docs/DistributionsFileApi.md#partial_update) | **PATCH** {file_file_distribution_href} | Update a file distribution
*DistributionsFileApi* | [**read**](docs/DistributionsFileApi.md#read) | **GET** {file_file_distribution_href} | Inspect a file distribution
*DistributionsFileApi* | [**update**](docs/DistributionsFileApi.md#update) | **PUT** {file_file_distribution_href} | Update a file distribution
*PublicationsFileApi* | [**create**](docs/PublicationsFileApi.md#create) | **POST** /pulp/api/v3/publications/file/file/ | Create a file publication
*PublicationsFileApi* | [**delete**](docs/PublicationsFileApi.md#delete) | **DELETE** {file_file_publication_href} | Delete a file publication
*PublicationsFileApi* | [**list**](docs/PublicationsFileApi.md#list) | **GET** /pulp/api/v3/publications/file/file/ | List file publications
*PublicationsFileApi* | [**read**](docs/PublicationsFileApi.md#read) | **GET** {file_file_publication_href} | Inspect a file publication
*RemotesFileApi* | [**create**](docs/RemotesFileApi.md#create) | **POST** /pulp/api/v3/remotes/file/file/ | Create a file remote
*RemotesFileApi* | [**delete**](docs/RemotesFileApi.md#delete) | **DELETE** {file_file_remote_href} | Delete a file remote
*RemotesFileApi* | [**list**](docs/RemotesFileApi.md#list) | **GET** /pulp/api/v3/remotes/file/file/ | List file remotes
*RemotesFileApi* | [**partial_update**](docs/RemotesFileApi.md#partial_update) | **PATCH** {file_file_remote_href} | Update a file remote
*RemotesFileApi* | [**read**](docs/RemotesFileApi.md#read) | **GET** {file_file_remote_href} | Inspect a file remote
*RemotesFileApi* | [**update**](docs/RemotesFileApi.md#update) | **PUT** {file_file_remote_href} | Update a file remote
*RepositoriesFileApi* | [**create**](docs/RepositoriesFileApi.md#create) | **POST** /pulp/api/v3/repositories/file/file/ | Create a file repository
*RepositoriesFileApi* | [**delete**](docs/RepositoriesFileApi.md#delete) | **DELETE** {file_file_repository_href} | Delete a file repository
*RepositoriesFileApi* | [**list**](docs/RepositoriesFileApi.md#list) | **GET** /pulp/api/v3/repositories/file/file/ | List file repositorys
*RepositoriesFileApi* | [**modify**](docs/RepositoriesFileApi.md#modify) | **POST** {file_file_repository_href}modify/ | Modify Repository Content
*RepositoriesFileApi* | [**partial_update**](docs/RepositoriesFileApi.md#partial_update) | **PATCH** {file_file_repository_href} | Update a file repository
*RepositoriesFileApi* | [**read**](docs/RepositoriesFileApi.md#read) | **GET** {file_file_repository_href} | Inspect a file repository
*RepositoriesFileApi* | [**sync**](docs/RepositoriesFileApi.md#sync) | **POST** {file_file_repository_href}sync/ | 
*RepositoriesFileApi* | [**update**](docs/RepositoriesFileApi.md#update) | **PUT** {file_file_repository_href} | Update a file repository
*RepositoriesFileVersionsApi* | [**delete**](docs/RepositoriesFileVersionsApi.md#delete) | **DELETE** {file_file_repository_version_href} | Delete a repository version
*RepositoriesFileVersionsApi* | [**list**](docs/RepositoriesFileVersionsApi.md#list) | **GET** {file_file_repository_href}versions/ | List repository versions
*RepositoriesFileVersionsApi* | [**read**](docs/RepositoriesFileVersionsApi.md#read) | **GET** {file_file_repository_version_href} | Inspect a repository version
*RepositoriesFileVersionsApi* | [**repair**](docs/RepositoriesFileVersionsApi.md#repair) | **POST** {file_file_repository_version_href}repair/ | 


## Documentation For Models

 - [AsyncOperationResponse](docs/AsyncOperationResponse.md)
 - [ContentSummary](docs/ContentSummary.md)
 - [ContentSummaryResponse](docs/ContentSummaryResponse.md)
 - [FileFileAlternateContentSource](docs/FileFileAlternateContentSource.md)
 - [FileFileAlternateContentSourceResponse](docs/FileFileAlternateContentSourceResponse.md)
 - [FileFileContent](docs/FileFileContent.md)
 - [FileFileContentResponse](docs/FileFileContentResponse.md)
 - [FileFileDistribution](docs/FileFileDistribution.md)
 - [FileFileDistributionResponse](docs/FileFileDistributionResponse.md)
 - [FileFilePublication](docs/FileFilePublication.md)
 - [FileFilePublicationResponse](docs/FileFilePublicationResponse.md)
 - [FileFileRemote](docs/FileFileRemote.md)
 - [FileFileRemoteResponse](docs/FileFileRemoteResponse.md)
 - [FileFileRepository](docs/FileFileRepository.md)
 - [FileFileRepositoryResponse](docs/FileFileRepositoryResponse.md)
 - [PaginatedRepositoryVersionResponseList](docs/PaginatedRepositoryVersionResponseList.md)
 - [PaginatedfileFileAlternateContentSourceResponseList](docs/PaginatedfileFileAlternateContentSourceResponseList.md)
 - [PaginatedfileFileContentResponseList](docs/PaginatedfileFileContentResponseList.md)
 - [PaginatedfileFileDistributionResponseList](docs/PaginatedfileFileDistributionResponseList.md)
 - [PaginatedfileFilePublicationResponseList](docs/PaginatedfileFilePublicationResponseList.md)
 - [PaginatedfileFileRemoteResponseList](docs/PaginatedfileFileRemoteResponseList.md)
 - [PaginatedfileFileRepositoryResponseList](docs/PaginatedfileFileRepositoryResponseList.md)
 - [PatchedfileFileAlternateContentSource](docs/PatchedfileFileAlternateContentSource.md)
 - [PatchedfileFileDistribution](docs/PatchedfileFileDistribution.md)
 - [PatchedfileFileRemote](docs/PatchedfileFileRemote.md)
 - [PatchedfileFileRepository](docs/PatchedfileFileRepository.md)
 - [PolicyEnum](docs/PolicyEnum.md)
 - [RepositoryAddRemoveContent](docs/RepositoryAddRemoveContent.md)
 - [RepositorySyncURL](docs/RepositorySyncURL.md)
 - [RepositoryVersion](docs/RepositoryVersion.md)
 - [RepositoryVersionResponse](docs/RepositoryVersionResponse.md)
 - [TaskGroupOperationResponse](docs/TaskGroupOperationResponse.md)


## Documentation For Authorization


## basicAuth

- **Type**: HTTP basic authentication


## cookieAuth

- **Type**: API key
- **API key parameter name**: sessionid
- **Location**: 


## Author

pulp-list@redhat.com


