import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * A Cloudflare resource for managing load-balancing across pools
 *
 * @schema CfnLoadBalancerProps
 */
export interface CfnLoadBalancerProps {
    /**
     * The zone ID to add the load balancer to.
     *
     * @schema CfnLoadBalancerProps#ZoneId
     */
    readonly zoneId: string;
    /**
     * The DNS name (FQDN, including the zone) to associate with the load balancer.
     *
     * @schema CfnLoadBalancerProps#Name
     */
    readonly name?: string;
    /**
     * he pool ID to use when all other pools are detected as unhealthy.
     *
     * @schema CfnLoadBalancerProps#FallbackPool
     */
    readonly fallbackPool?: string;
    /**
     * Free text description.
     *
     * @schema CfnLoadBalancerProps#Description
     */
    readonly description?: string;
    /**
     * Time to live (TTL) of this load balancer's DNS name. Conflicts with proxied - this cannot be set for proxied load balancers. Default is 30.
     *
     * @default 30.
     * @schema CfnLoadBalancerProps#Ttl
     */
    readonly ttl?: number;
    /**
     * Determine which method the load balancer uses to determine the fastest route to your origin
     *
     * @schema CfnLoadBalancerProps#SteeringPolicy
     */
    readonly steeringPolicy?: string;
    /**
     * Whether the hostname gets Cloudflare's origin protection. Defaults to false.
     *
     * @default false.
     * @schema CfnLoadBalancerProps#Proxied
     */
    readonly proxied?: boolean;
    /**
     * Enable or disable the load balancer. Defaults to true (enabled).
     *
     * @default true (enabled).
     * @schema CfnLoadBalancerProps#Enabled
     */
    readonly enabled?: boolean;
    /**
     * A list of pool IDs ordered by their failover priority. Pools defined here are used by default, or when region_pools are not configured for a given region
     *
     * @schema CfnLoadBalancerProps#DefaultPools
     */
    readonly defaultPools?: string[];
    /**
     * A set containing mappings of region codes to a list of pool IDs (ordered by their failover priority) for the given region
     *
     * @schema CfnLoadBalancerProps#RegionPools
     */
    readonly regionPools?: any;
    /**
     * A set containing mappings of country codes to a list of pool IDs (ordered by their failover priority) for the given country
     *
     * @schema CfnLoadBalancerProps#CountryPools
     */
    readonly countryPools?: any;
    /**
     * A set containing mappings of Cloudflare Point-of-Presence (PoP) identifiers to a list of pool IDs (ordered by their failover priority) for the PoP (datacenter). This feature is only available to enterprise customers
     *
     * @schema CfnLoadBalancerProps#PopPools
     */
    readonly popPools?: any;
    /**
     * Configures pool weights for random steering. When steering_policy is 'random', a random pool is selected with probability proportional to these pool weights
     *
     * @schema CfnLoadBalancerProps#RandomSteering
     */
    readonly randomSteering?: CfnLoadBalancerPropsRandomSteering;
    /**
     * Associates all requests coming from an end-user with a single origin. Cloudflare will set a cookie on the initial response to the client, such that consequent requests with the cookie in the request will go to the same origin, so long as it is available
     *
     * @schema CfnLoadBalancerProps#SessionAffinity
     */
    readonly sessionAffinity?: string;
    /**
     * Time, in seconds, until this load balancers session affinity cookie expires after being created. This parameter is ignored unless a supported session affinity policy is set. The current default of 23 hours will be used unless session_affinity_ttl is explicitly set. Once the expiry time has been reached, subsequent requests may get sent to a different origin server. Valid values are between 1800 and 604800.
     *
     * @schema CfnLoadBalancerProps#SessionAffinityTtl
     */
    readonly sessionAffinityTtl?: number;
    /**
     * Configure cookie attributes for session affinity cookie
     *
     * @schema CfnLoadBalancerProps#SessionAffinityAttributes
     */
    readonly sessionAffinityAttributes?: any;
    /**
     * A list of conditions and overrides for each load balancer operation
     *
     * @schema CfnLoadBalancerProps#Rules
     */
    readonly rules?: any[];
}
/**
 * Converts an object of type 'CfnLoadBalancerProps' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerProps(obj: CfnLoadBalancerProps | undefined): Record<string, any> | undefined;
/**
 * Configures pool weights for random steering. When steering_policy is 'random', a random pool is selected with probability proportional to these pool weights
 *
 * @schema CfnLoadBalancerPropsRandomSteering
 */
export interface CfnLoadBalancerPropsRandomSteering {
    /**
     * @schema CfnLoadBalancerPropsRandomSteering#DefaultWeight
     */
    readonly defaultWeight?: number;
}
/**
 * Converts an object of type 'CfnLoadBalancerPropsRandomSteering' to JSON representation.
 */
export declare function toJson_CfnLoadBalancerPropsRandomSteering(obj: CfnLoadBalancerPropsRandomSteering | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `Cloudflare::LoadBalancer::LoadBalancer`
 *
 * @cloudformationResource Cloudflare::LoadBalancer::LoadBalancer
 * @stability external
 * @link https://github.com/aws-ia/cloudformation-cloudflare-resource-providers.git
 */
export declare class CfnLoadBalancer extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "Cloudflare::LoadBalancer::LoadBalancer";
    /**
     * Resource props.
     */
    readonly props: CfnLoadBalancerProps;
    /**
     * Attribute `Cloudflare::LoadBalancer::LoadBalancer.Id`
     * @link https://github.com/aws-ia/cloudformation-cloudflare-resource-providers.git
     */
    readonly attrId: string;
    /**
     * Attribute `Cloudflare::LoadBalancer::LoadBalancer.ModifiedOn`
     * @link https://github.com/aws-ia/cloudformation-cloudflare-resource-providers.git
     */
    readonly attrModifiedOn: string;
    /**
     * Attribute `Cloudflare::LoadBalancer::LoadBalancer.CreatedOn`
     * @link https://github.com/aws-ia/cloudformation-cloudflare-resource-providers.git
     */
    readonly attrCreatedOn: string;
    /**
     * Create a new `Cloudflare::LoadBalancer::LoadBalancer`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnLoadBalancerProps);
}
