# Generated by Django 3.1.5 on 2021-03-07 12:55

import secrets

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("core", "0004_auto_20210305_1855"),
    ]

    operations = [
        migrations.CreateModel(
            name="GuestUser",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                ("email", models.EmailField(max_length=254, verbose_name="email address")),
                ("first_name", models.CharField(max_length=254, verbose_name="first name")),
                ("last_name", models.CharField(max_length=254, verbose_name="last name")),
                ("date_of_birth", models.DateField(verbose_name="date of birth")),
                (
                    "phone",
                    models.CharField(blank=True, max_length=254, verbose_name="phone number"),
                ),
                (
                    "access_token",
                    models.CharField(default=secrets.token_urlsafe, max_length=254, unique=True),
                ),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                (
                    "event",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="core.event"),
                ),
                ("qualifications", models.ManyToManyField(to="core.Qualification")),
            ],
            options={
                "unique_together": {("event", "email", "first_name", "last_name")},
            },
        ),
        migrations.CreateModel(
            name="GuestParticipation",
            fields=[
                (
                    "abstractparticipation_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="core.abstractparticipation",
                    ),
                ),
                (
                    "guest_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="guests.guestuser"
                    ),
                ),
            ],
            options={
                "abstract": False,
                "base_manager_name": "objects",
            },
            bases=("core.abstractparticipation",),
        ),
        migrations.CreateModel(
            name="EventGuestShare",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True, primary_key=True, serialize=False, verbose_name="ID"
                    ),
                ),
                (
                    "token",
                    models.CharField(default=secrets.token_urlsafe, max_length=254, unique=True),
                ),
                ("active", models.BooleanField(default=False)),
                (
                    "event",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="guest_share",
                        to="core.event",
                    ),
                ),
            ],
        ),
    ]
