##
# File:    ChemCompSchemaDef.py
# Author:  J. Westbrook
# Date:    12-Jan-2013
# Version: 0.001 Initial version
#
# Updates:
#    5-Dec-2016 jdw add program and program version to pdbx_chem_comp_identifier table
##
"""
Database schema defintions for chemical component definitions.

"""
__docformat__ = "restructuredtext en"
__author__    = "John Westbrook"
__email__     = "jwest@rcsb.rutgers.edu"
__license__   = "Creative Commons Attribution 3.0 Unported"
__version__   = "V0.001"

import sys
from wwpdb.utils.db.SchemaDefBase import SchemaDefBase


class ChemCompSchemaDef(SchemaDefBase):
    """ A data class containing schema definitions chemical component definitions.
    """
    _databaseName="compv4"
    _schemaDefDict ={
        'CHEM_COMP': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID',
                                     'FORMULA': 'formula',
                                     'FORMULA_WEIGHT': 'formula_weight',
                                     'ID': 'id',
                                     'MODEL_DETAILS': 'model_details',
                                     'MODEL_ERF': 'model_erf',
                                     'MODEL_SOURCE': 'model_source',
                                     'MON_NSTD_CLASS': 'mon_nstd_class',
                                     'MON_NSTD_DETAILS': 'mon_nstd_details',
                                     'MON_NSTD_FLAG': 'mon_nstd_flag',
                                     'MON_NSTD_PARENT': 'mon_nstd_parent',
                                     'MON_NSTD_PARENT_COMP_ID': 'mon_nstd_parent_comp_id',
                                     'NAME': 'name',
                                     'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                     'NUMBER_ATOMS_NH': 'number_atoms_nh',
                                     'ONE_LETTER_CODE': 'one_letter_code',
                                     'PDBX_AMBIGUOUS_FLAG': 'pdbx_ambiguous_flag',
                                     'PDBX_COMPONENT_NO': 'pdbx_component_no',
                                     'PDBX_FORMAL_CHARGE': 'pdbx_formal_charge',
                                     'PDBX_IDEAL_COORDINATES_DETAILS': 'pdbx_ideal_coordinates_details',
                                     'PDBX_IDEAL_COORDINATES_MISSING_FLAG': 'pdbx_ideal_coordinates_missing_flag',
                                     'PDBX_INITIAL_DATE': 'pdbx_initial_date',
                                     'PDBX_MODEL_COORDINATES_DB_CODE': 'pdbx_model_coordinates_db_code',
                                     'PDBX_MODEL_COORDINATES_DETAILS': 'pdbx_model_coordinates_details',
                                     'PDBX_MODEL_COORDINATES_MISSING_FLAG': 'pdbx_model_coordinates_missing_flag',
                                     'PDBX_MODIFICATION_DETAILS': 'pdbx_modification_details',
                                     'PDBX_MODIFIED_DATE': 'pdbx_modified_date',
                                     'PDBX_PROCESSING_SITE': 'pdbx_processing_site',
                                     'PDBX_RELEASE_STATUS': 'pdbx_release_status',
                                     'PDBX_REPLACED_BY': 'pdbx_replaced_by',
                                     'PDBX_REPLACES': 'pdbx_replaces',
                                     'PDBX_SUBCOMPONENT_LIST': 'pdbx_subcomponent_list',
                                     'PDBX_SYNONYMS': 'pdbx_synonyms',
                                     'PDBX_TYPE': 'pdbx_type',
                                     'THREE_LETTER_CODE': 'three_letter_code',
                                     'TYPE': 'type'},
                      'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                          'ORDER': 1,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                         'FORMULA': {'NULLABLE': True,
                                                     'ORDER': 2,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': False,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 200},
                                         'FORMULA_WEIGHT': {'NULLABLE': True,
                                                            'ORDER': 3,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                         'ID': {'NULLABLE': False,
                                                'ORDER': 4,
                                                'PRECISION': 0,
                                                'PRIMARY_KEY': True,
                                                'SQL_TYPE': 'VARCHAR',
                                                'WIDTH': 10},
                                         'MODEL_DETAILS': {'NULLABLE': True,
                                                           'ORDER': 6,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 200},
                                         'MODEL_ERF': {'NULLABLE': True,
                                                       'ORDER': 7,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                         'MODEL_SOURCE': {'NULLABLE': True,
                                                          'ORDER': 8,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                         'MON_NSTD_CLASS': {'NULLABLE': True,
                                                            'ORDER': 9,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 200},
                                         'MON_NSTD_DETAILS': {'NULLABLE': True,
                                                              'ORDER': 10,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 200},
                                         'MON_NSTD_FLAG': {'NULLABLE': True,
                                                           'ORDER': 11,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                         'MON_NSTD_PARENT': {'NULLABLE': True,
                                                             'ORDER': 12,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 20},
                                         'MON_NSTD_PARENT_COMP_ID': {'NULLABLE': True,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 50},
                                         'NAME': {'NULLABLE': True,
                                                  'ORDER': 13,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 1024},
                                         'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                              'ORDER': 14,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'INT',
                                                              'WIDTH': 10},
                                         'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                         'ONE_LETTER_CODE': {'NULLABLE': True,
                                                             'ORDER': 16,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 5},
                                         'PDBX_AMBIGUOUS_FLAG': {'NULLABLE': True,
                                                                 'ORDER': 23,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                         'PDBX_COMPONENT_NO': {'NULLABLE': True,
                                                               'ORDER': 21,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                         'PDBX_FORMAL_CHARGE': {'NULLABLE': True,
                                                                'ORDER': 26,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'INT',
                                                                'WIDTH': 10},
                                         'PDBX_IDEAL_COORDINATES_DETAILS': {'NULLABLE': True,
                                                                            'ORDER': 28,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                         'PDBX_IDEAL_COORDINATES_MISSING_FLAG': {'NULLABLE': True,
                                                                                 'ORDER': 29,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                         'PDBX_INITIAL_DATE': {'NULLABLE': True,
                                                               'ORDER': 35,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'DATETIME',
                                                               'WIDTH': 15},
                                         'PDBX_MODEL_COORDINATES_DB_CODE': {'NULLABLE': True,
                                                                            'ORDER': 31,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 30},
                                         'PDBX_MODEL_COORDINATES_DETAILS': {'NULLABLE': True,
                                                                            'ORDER': 27,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 200},
                                         'PDBX_MODEL_COORDINATES_MISSING_FLAG': {'NULLABLE': True,
                                                                                 'ORDER': 30,
                                                                                 'PRECISION': 0,
                                                                                 'PRIMARY_KEY': False,
                                                                                 'SQL_TYPE': 'VARCHAR',
                                                                                 'WIDTH': 10},
                                         'PDBX_MODIFICATION_DETAILS': {'NULLABLE': True,
                                                                       'ORDER': 20,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 80},
                                         'PDBX_MODIFIED_DATE': {'NULLABLE': True,
                                                                'ORDER': 36,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'DATETIME',
                                                                'WIDTH': 15},
                                         'PDBX_PROCESSING_SITE': {'NULLABLE': True,
                                                                  'ORDER': 34,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                         'PDBX_RELEASE_STATUS': {'NULLABLE': True,
                                                                 'ORDER': 33,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 8},
                                         'PDBX_REPLACED_BY': {'NULLABLE': True,
                                                              'ORDER': 24,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                         'PDBX_REPLACES': {'NULLABLE': True,
                                                           'ORDER': 25,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 80},
                                         'PDBX_SUBCOMPONENT_LIST': {'NULLABLE': True,
                                                                    'ORDER': 32,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80},
                                         'PDBX_SYNONYMS': {'NULLABLE': True,
                                                           'ORDER': 19,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 512},
                                         'PDBX_TYPE': {'NULLABLE': True,
                                                       'ORDER': 22,
                                                       'PRECISION': 0,
                                                       'PRIMARY_KEY': False,
                                                       'SQL_TYPE': 'VARCHAR',
                                                       'WIDTH': 80},
                                         'THREE_LETTER_CODE': {'NULLABLE': True,
                                                               'ORDER': 17,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 5},
                                         'TYPE': {'NULLABLE': True,
                                                  'ORDER': 18,
                                                  'PRECISION': 0,
                                                  'PRIMARY_KEY': False,
                                                  'SQL_TYPE': 'VARCHAR',
                                                  'WIDTH': 80}},
                      'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                        'FORMULA': ('chem_comp', 'formula', None, None),
                                        'FORMULA_WEIGHT': ('chem_comp', 'formula_weight', None, None),
                                        'ID': ('chem_comp', 'id', None, None),
                                        'MODEL_DETAILS': ('chem_comp', 'model_details', None, None),
                                        'MODEL_ERF': ('chem_comp', 'model_erf', None, None),
                                        'MODEL_SOURCE': ('chem_comp', 'model_source', None, None),
                                        'MON_NSTD_CLASS': ('chem_comp', 'mon_nstd_class', None, None),
                                        'MON_NSTD_DETAILS': ('chem_comp', 'mon_nstd_details', None, None),
                                        'MON_NSTD_FLAG': ('chem_comp', 'mon_nstd_flag', None, None),
                                        'MON_NSTD_PARENT': ('chem_comp', 'mon_nstd_parent', None, None),
                                        'MON_NSTD_PARENT_COMP_ID': ('chem_comp', 'mon_nstd_parent_comp_id', None, None),
                                        'NAME': ('chem_comp', 'name', None, None),
                                        'NUMBER_ATOMS_ALL': ('chem_comp', 'number_atoms_all', None, None),
                                        'NUMBER_ATOMS_NH': ('chem_comp', 'number_atoms_nh', None, None),
                                        'ONE_LETTER_CODE': ('chem_comp', 'one_letter_code', None, None),
                                        'PDBX_AMBIGUOUS_FLAG': ('chem_comp', 'pdbx_ambiguous_flag', None, None),
                                        'PDBX_COMPONENT_NO': ('chem_comp', 'pdbx_component_no', None, None),
                                        'PDBX_FORMAL_CHARGE': ('chem_comp', 'pdbx_formal_charge', None, None),
                                        'PDBX_IDEAL_COORDINATES_DETAILS': ('chem_comp',
                                                                           'pdbx_ideal_coordinates_details',
                                                                           None,
                                                                           None),
                                        'PDBX_IDEAL_COORDINATES_MISSING_FLAG': ('chem_comp',
                                                                                'pdbx_ideal_coordinates_missing_flag',
                                                                                None,
                                                                                None),
                                        'PDBX_INITIAL_DATE': ('chem_comp', 'pdbx_initial_date', None, None),
                                        'PDBX_MODEL_COORDINATES_DB_CODE': ('chem_comp',
                                                                           'pdbx_model_coordinates_db_code',
                                                                           None,
                                                                           None),
                                        'PDBX_MODEL_COORDINATES_DETAILS': ('chem_comp',
                                                                           'pdbx_model_coordinates_details',
                                                                           None,
                                                                           None),
                                        'PDBX_MODEL_COORDINATES_MISSING_FLAG': ('chem_comp',
                                                                                'pdbx_model_coordinates_missing_flag',
                                                                                None,
                                                                                None),
                                        'PDBX_MODIFICATION_DETAILS': ('chem_comp', 'pdbx_modification_details', None, None),
                                        'PDBX_MODIFIED_DATE': ('chem_comp', 'pdbx_modified_date', None, None),
                                        'PDBX_PROCESSING_SITE': ('chem_comp', 'pdbx_processing_site', None, None),
                                        'PDBX_RELEASE_STATUS': ('chem_comp', 'pdbx_release_status', None, None),
                                        'PDBX_REPLACED_BY': ('chem_comp', 'pdbx_replaced_by', None, None),
                                        'PDBX_REPLACES': ('chem_comp', 'pdbx_replaces', None, None),
                                        'PDBX_SUBCOMPONENT_LIST': ('chem_comp', 'pdbx_subcomponent_list', None, None),
                                        'PDBX_SYNONYMS': ('chem_comp', 'pdbx_synonyms', None, None),
                                        'PDBX_TYPE': ('chem_comp', 'pdbx_type', None, None),
                                        'THREE_LETTER_CODE': ('chem_comp', 'three_letter_code', None, None),
                                        'TYPE': ('chem_comp', 'type', None, None)},
                      'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                  's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                      'MAP_MERGE_INDICES': {'chem_comp': {'ATTRIBUTES': ('id',), 'TYPE': 'EQUI-JOIN'}},
                      'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                      'TABLE_ID': 'CHEM_COMP',
                      'TABLE_NAME': 'chem_comp',
                      'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_ANGLE': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                           'ATOM_ID_2': 'atom_id_2',
                                           'ATOM_ID_3': 'atom_id_3',
                                           'COMPONENT_ID': 'Component_ID',
                                           'COMP_ID': 'comp_id',
                                           'VALUE_ANGLE': 'value_angle',
                                           'VALUE_ANGLE_ESD': 'value_angle_esd',
                                           'VALUE_DIST': 'value_dist',
                                           'VALUE_DIST_ESD': 'value_dist_esd'},
                            'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 6},
                                               'ATOM_ID_2': {'NULLABLE': False,
                                                             'ORDER': 4,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 6},
                                               'ATOM_ID_3': {'NULLABLE': False,
                                                             'ORDER': 5,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'VARCHAR',
                                                             'WIDTH': 6},
                                               'COMPONENT_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                               'COMP_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                               'VALUE_ANGLE': {'NULLABLE': True,
                                                               'ORDER': 6,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                               'VALUE_ANGLE_ESD': {'NULLABLE': True,
                                                                   'ORDER': 7,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10},
                                               'VALUE_DIST': {'NULLABLE': True,
                                                              'ORDER': 8,
                                                              'PRECISION': 6,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'FLOAT',
                                                              'WIDTH': 10},
                                               'VALUE_DIST_ESD': {'NULLABLE': True,
                                                                  'ORDER': 9,
                                                                  'PRECISION': 6,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'FLOAT',
                                                                  'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'ATOM_ID_1': ('chem_comp_angle', 'atom_id_1', None, None),
                                              'ATOM_ID_2': ('chem_comp_angle', 'atom_id_2', None, None),
                                              'ATOM_ID_3': ('chem_comp_angle', 'atom_id_3', None, None),
                                              'COMPONENT_ID': (None, None, 'datablockid()', None),
                                              'COMP_ID': ('chem_comp_angle', 'comp_id', None, None),
                                              'VALUE_ANGLE': ('chem_comp_angle', 'value_angle', None, None),
                                              'VALUE_ANGLE_ESD': ('chem_comp_angle', 'value_angle_esd', None, None),
                                              'VALUE_DIST': ('chem_comp_angle', 'value_dist', None, None),
                                              'VALUE_DIST_ESD': ('chem_comp_angle', 'value_dist_esd', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID',
                                                              'COMP_ID',
                                                              'ATOM_ID_1',
                                                              'ATOM_ID_2',
                                                              'ATOM_ID_3'),
                                               'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'chem_comp_angle': {'ATTRIBUTES': ('comp_id',
                                                                                     'atom_id_1',
                                                                                     'atom_id_2',
                                                                                     'atom_id_3'),
                                                                      'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                            'TABLE_ID': 'CHEM_COMP_ANGLE',
                            'TABLE_NAME': 'chem_comp_angle',
                            'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_ATOM': {'ATTRIBUTES': {'ALT_ATOM_ID': 'alt_atom_id',
                                          'ATOM_ID': 'atom_id',
                                          'CHARGE': 'charge',
                                          'COMPONENT_ID': 'Component_ID',
                                          'COMP_ID': 'comp_id',
                                          'MODEL_CARTN_X': 'model_Cartn_x',
                                          'MODEL_CARTN_X_ESD': 'model_Cartn_x_esd',
                                          'MODEL_CARTN_Y': 'model_Cartn_y',
                                          'MODEL_CARTN_Y_ESD': 'model_Cartn_y_esd',
                                          'MODEL_CARTN_Z': 'model_Cartn_z',
                                          'MODEL_CARTN_Z_ESD': 'model_Cartn_z_esd',
                                          'PARTIAL_CHARGE': 'partial_charge',
                                          'PDBX_ALIGN': 'pdbx_align',
                                          'PDBX_ALT_ATOM_ID': 'pdbx_alt_atom_id',
                                          'PDBX_ALT_COMP_ID': 'pdbx_alt_comp_id',
                                          'PDBX_AROMATIC_FLAG': 'pdbx_aromatic_flag',
                                          'PDBX_LEAVING_ATOM_FLAG': 'pdbx_leaving_atom_flag',
                                          'PDBX_MODEL_CARTN_X_IDEAL': 'pdbx_model_Cartn_x_ideal',
                                          'PDBX_MODEL_CARTN_Y_IDEAL': 'pdbx_model_Cartn_y_ideal',
                                          'PDBX_MODEL_CARTN_Z_IDEAL': 'pdbx_model_Cartn_z_ideal',
                                          'PDBX_ORDINAL': 'pdbx_ordinal',
                                          'PDBX_STEREO_CONFIG': 'pdbx_stereo_config',
                                          'PDBX_STND_ATOM_ID': 'pdbx_stnd_atom_id',
                                          'SUBSTRUCT_CODE': 'substruct_code',
                                          'TYPE_SYMBOL': 'type_symbol'},
                           'ATTRIBUTE_INFO': {'ALT_ATOM_ID': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 80},
                                              'ATOM_ID': {'NULLABLE': False,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 6},
                                              'CHARGE': {'NULLABLE': True,
                                                         'ORDER': 5,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': False,
                                                         'SQL_TYPE': 'INT',
                                                         'WIDTH': 10},
                                              'COMPONENT_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'COMP_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'MODEL_CARTN_X': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_X_ESD': {'NULLABLE': True,
                                                                    'ORDER': 7,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'MODEL_CARTN_Y': {'NULLABLE': True,
                                                                'ORDER': 8,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_Y_ESD': {'NULLABLE': True,
                                                                    'ORDER': 9,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'MODEL_CARTN_Z': {'NULLABLE': True,
                                                                'ORDER': 10,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                              'MODEL_CARTN_Z_ESD': {'NULLABLE': True,
                                                                    'ORDER': 11,
                                                                    'PRECISION': 6,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'FLOAT',
                                                                    'WIDTH': 10},
                                              'PARTIAL_CHARGE': {'NULLABLE': True,
                                                                 'ORDER': 12,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                              'PDBX_ALIGN': {'NULLABLE': True,
                                                             'ORDER': 15,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'INT',
                                                             'WIDTH': 10},
                                              'PDBX_ALT_ATOM_ID': {'NULLABLE': True,
                                                                   'ORDER': 17,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 6},
                                              'PDBX_ALT_COMP_ID': {'NULLABLE': True,
                                                                   'ORDER': 18,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                              'PDBX_AROMATIC_FLAG': {'NULLABLE': True,
                                                                     'ORDER': 23,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'PDBX_LEAVING_ATOM_FLAG': {'NULLABLE': True,
                                                                         'ORDER': 24,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_X_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 19,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_Y_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 20,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_MODEL_CARTN_Z_IDEAL': {'NULLABLE': True,
                                                                           'ORDER': 21,
                                                                           'PRECISION': 6,
                                                                           'PRIMARY_KEY': False,
                                                                           'SQL_TYPE': 'FLOAT',
                                                                           'WIDTH': 10},
                                              'PDBX_ORDINAL': {'NULLABLE': True,
                                                               'ORDER': 16,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                              'PDBX_STEREO_CONFIG': {'NULLABLE': True,
                                                                     'ORDER': 22,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'PDBX_STND_ATOM_ID': {'NULLABLE': True,
                                                                    'ORDER': 25,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 6},
                                              'SUBSTRUCT_CODE': {'NULLABLE': True,
                                                                 'ORDER': 13,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10},
                                              'TYPE_SYMBOL': {'NULLABLE': True,
                                                              'ORDER': 14,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ALT_ATOM_ID': ('chem_comp_atom', 'alt_atom_id', None, None),
                                             'ATOM_ID': ('chem_comp_atom', 'atom_id', None, None),
                                             'CHARGE': ('chem_comp_atom', 'charge', None, None),
                                             'COMPONENT_ID': (None, None, 'datablockid()', None),
                                             'COMP_ID': ('chem_comp_atom', 'comp_id', None, None),
                                             'MODEL_CARTN_X': ('chem_comp_atom', 'model_Cartn_x', None, None),
                                             'MODEL_CARTN_X_ESD': ('chem_comp_atom', 'model_Cartn_x_esd', None, None),
                                             'MODEL_CARTN_Y': ('chem_comp_atom', 'model_Cartn_y', None, None),
                                             'MODEL_CARTN_Y_ESD': ('chem_comp_atom', 'model_Cartn_y_esd', None, None),
                                             'MODEL_CARTN_Z': ('chem_comp_atom', 'model_Cartn_z', None, None),
                                             'MODEL_CARTN_Z_ESD': ('chem_comp_atom', 'model_Cartn_z_esd', None, None),
                                             'PARTIAL_CHARGE': ('chem_comp_atom', 'partial_charge', None, None),
                                             'PDBX_ALIGN': ('chem_comp_atom', 'pdbx_align', None, None),
                                             'PDBX_ALT_ATOM_ID': ('chem_comp_atom', 'pdbx_alt_atom_id', None, None),
                                             'PDBX_ALT_COMP_ID': ('chem_comp_atom', 'pdbx_alt_comp_id', None, None),
                                             'PDBX_AROMATIC_FLAG': ('chem_comp_atom', 'pdbx_aromatic_flag', None, None),
                                             'PDBX_LEAVING_ATOM_FLAG': ('chem_comp_atom',
                                                                        'pdbx_leaving_atom_flag',
                                                                        None,
                                                                        None),
                                             'PDBX_MODEL_CARTN_X_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_x_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_MODEL_CARTN_Y_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_y_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_MODEL_CARTN_Z_IDEAL': ('chem_comp_atom',
                                                                          'pdbx_model_Cartn_z_ideal',
                                                                          None,
                                                                          None),
                                             'PDBX_ORDINAL': ('chem_comp_atom', 'pdbx_ordinal', None, None),
                                             'PDBX_STEREO_CONFIG': ('chem_comp_atom', 'pdbx_stereo_config', None, None),
                                             'PDBX_STND_ATOM_ID': ('chem_comp_atom', 'pdbx_stnd_atom_id', None, None),
                                             'SUBSTRUCT_CODE': ('chem_comp_atom', 'substruct_code', None, None),
                                             'TYPE_SYMBOL': ('chem_comp_atom', 'type_symbol', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'ATOM_ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_atom': {'ATTRIBUTES': ('comp_id', 'atom_id'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                           'TABLE_ID': 'CHEM_COMP_ATOM',
                           'TABLE_NAME': 'chem_comp_atom',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_BOND': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                          'ATOM_ID_2': 'atom_id_2',
                                          'COMPONENT_ID': 'Component_ID',
                                          'COMP_ID': 'comp_id',
                                          'PDBX_AROMATIC_FLAG': 'pdbx_aromatic_flag',
                                          'PDBX_ORDINAL': 'pdbx_ordinal',
                                          'PDBX_STEREO_CONFIG': 'pdbx_stereo_config',
                                          'VALUE_DIST': 'value_dist',
                                          'VALUE_DIST_ESD': 'value_dist_esd',
                                          'VALUE_ORDER': 'value_order'},
                           'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': False,
                                                            'ORDER': 3,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 6},
                                              'ATOM_ID_2': {'NULLABLE': False,
                                                            'ORDER': 4,
                                                            'PRECISION': 0,
                                                            'PRIMARY_KEY': True,
                                                            'SQL_TYPE': 'VARCHAR',
                                                            'WIDTH': 6},
                                              'COMPONENT_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'COMP_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'PDBX_AROMATIC_FLAG': {'NULLABLE': True,
                                                                     'ORDER': 10,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'PDBX_ORDINAL': {'NULLABLE': True,
                                                               'ORDER': 8,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'INT',
                                                               'WIDTH': 10},
                                              'PDBX_STEREO_CONFIG': {'NULLABLE': True,
                                                                     'ORDER': 9,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                              'VALUE_DIST': {'NULLABLE': True,
                                                             'ORDER': 6,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                              'VALUE_DIST_ESD': {'NULLABLE': True,
                                                                 'ORDER': 7,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                              'VALUE_ORDER': {'NULLABLE': True,
                                                              'ORDER': 5,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ATOM_ID_1': ('chem_comp_bond', 'atom_id_1', None, None),
                                             'ATOM_ID_2': ('chem_comp_bond', 'atom_id_2', None, None),
                                             'COMPONENT_ID': (None, None, 'datablockid()', None),
                                             'COMP_ID': ('chem_comp_bond', 'comp_id', None, None),
                                             'PDBX_AROMATIC_FLAG': ('chem_comp_bond', 'pdbx_aromatic_flag', None, None),
                                             'PDBX_ORDINAL': ('chem_comp_bond', 'pdbx_ordinal', None, None),
                                             'PDBX_STEREO_CONFIG': ('chem_comp_bond', 'pdbx_stereo_config', None, None),
                                             'VALUE_DIST': ('chem_comp_bond', 'value_dist', None, None),
                                             'VALUE_DIST_ESD': ('chem_comp_bond', 'value_dist_esd', None, None),
                                             'VALUE_ORDER': ('chem_comp_bond', 'value_order', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'ATOM_ID_1', 'ATOM_ID_2'),
                                              'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_bond': {'ATTRIBUTES': ('comp_id', 'atom_id_1', 'atom_id_2'),
                                                                    'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                           'TABLE_ID': 'CHEM_COMP_BOND',
                           'TABLE_NAME': 'chem_comp_bond',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_CHIR': {'ATTRIBUTES': {'ATOM_CONFIG': 'atom_config',
                                          'ATOM_ID': 'atom_id',
                                          'COMPONENT_ID': 'Component_ID',
                                          'COMP_ID': 'comp_id',
                                          'ID': 'id',
                                          'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                          'NUMBER_ATOMS_NH': 'number_atoms_nh',
                                          'VOLUME_FLAG': 'volume_flag',
                                          'VOLUME_THREE': 'volume_three',
                                          'VOLUME_THREE_ESD': 'volume_three_esd'},
                           'ATTRIBUTE_INFO': {'ATOM_CONFIG': {'NULLABLE': True,
                                                              'ORDER': 4,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'ATOM_ID': {'NULLABLE': True,
                                                          'ORDER': 3,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 6},
                                              'COMPONENT_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'COMP_ID': {'NULLABLE': False,
                                                          'ORDER': 2,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'ID': {'NULLABLE': False,
                                                     'ORDER': 5,
                                                     'PRECISION': 0,
                                                     'PRIMARY_KEY': True,
                                                     'SQL_TYPE': 'VARCHAR',
                                                     'WIDTH': 10},
                                              'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                                   'ORDER': 6,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                              'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                                  'ORDER': 7,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'INT',
                                                                  'WIDTH': 10},
                                              'VOLUME_FLAG': {'NULLABLE': True,
                                                              'ORDER': 8,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'VOLUME_THREE': {'NULLABLE': True,
                                                               'ORDER': 9,
                                                               'PRECISION': 6,
                                                               'PRIMARY_KEY': False,
                                                               'SQL_TYPE': 'FLOAT',
                                                               'WIDTH': 10},
                                              'VOLUME_THREE_ESD': {'NULLABLE': True,
                                                                   'ORDER': 10,
                                                                   'PRECISION': 6,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'FLOAT',
                                                                   'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'ATOM_CONFIG': ('chem_comp_chir', 'atom_config', None, None),
                                             'ATOM_ID': ('chem_comp_chir', 'atom_id', None, None),
                                             'COMPONENT_ID': (None, None, 'datablockid()', None),
                                             'COMP_ID': ('chem_comp_chir', 'comp_id', None, None),
                                             'ID': ('chem_comp_chir', 'id', None, None),
                                             'NUMBER_ATOMS_ALL': ('chem_comp_chir', 'number_atoms_all', None, None),
                                             'NUMBER_ATOMS_NH': ('chem_comp_chir', 'number_atoms_nh', None, None),
                                             'VOLUME_FLAG': ('chem_comp_chir', 'volume_flag', None, None),
                                             'VOLUME_THREE': ('chem_comp_chir', 'volume_three', None, None),
                                             'VOLUME_THREE_ESD': ('chem_comp_chir', 'volume_three_esd', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_chir': {'ATTRIBUTES': ('comp_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                           'TABLE_ID': 'CHEM_COMP_CHIR',
                           'TABLE_NAME': 'chem_comp_chir',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_CHIR_ATOM': {'ATTRIBUTES': {'ATOM_ID': 'atom_id',
                                               'CHIR_ID': 'chir_id',
                                               'COMPONENT_ID': 'Component_ID',
                                               'COMP_ID': 'comp_id',
                                               'DEV': 'dev'},
                                'ATTRIBUTE_INFO': {'ATOM_ID': {'NULLABLE': False,
                                                               'ORDER': 3,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 6},
                                                   'CHIR_ID': {'NULLABLE': False,
                                                               'ORDER': 4,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'COMPONENT_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'COMP_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'DEV': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 6,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'FLOAT',
                                                           'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ATOM_ID': ('chem_comp_chir_atom', 'atom_id', None, None),
                                                  'CHIR_ID': ('chem_comp_chir_atom', 'chir_id', None, None),
                                                  'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                  'COMP_ID': ('chem_comp_chir_atom', 'comp_id', None, None),
                                                  'DEV': ('chem_comp_chir_atom', 'dev', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'ATOM_ID', 'CHIR_ID'),
                                                   'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'chem_comp_chir_atom': {'ATTRIBUTES': ('comp_id', 'atom_id', 'chir_id'),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                'TABLE_ID': 'CHEM_COMP_CHIR_ATOM',
                                'TABLE_NAME': 'chem_comp_chir_atom',
                                'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_LINK': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID',
                                          'DETAILS': 'details',
                                          'LINK_ID': 'link_id',
                                          'TYPE_COMP_1': 'type_comp_1',
                                          'TYPE_COMP_2': 'type_comp_2'},
                           'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                               'ORDER': 1,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                              'DETAILS': {'NULLABLE': True,
                                                          'ORDER': 5,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': False,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 200},
                                              'LINK_ID': {'NULLABLE': False,
                                                          'ORDER': 4,
                                                          'PRECISION': 0,
                                                          'PRIMARY_KEY': True,
                                                          'SQL_TYPE': 'VARCHAR',
                                                          'WIDTH': 10},
                                              'TYPE_COMP_1': {'NULLABLE': True,
                                                              'ORDER': 2,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                              'TYPE_COMP_2': {'NULLABLE': True,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': False,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                           'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                             'DETAILS': ('chem_comp_link', 'details', None, None),
                                             'LINK_ID': ('chem_comp_link', 'link_id', None, None),
                                             'TYPE_COMP_1': ('chem_comp_link', 'type_comp_1', None, None),
                                             'TYPE_COMP_2': ('chem_comp_link', 'type_comp_2', None, None)},
                           'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'LINK_ID'), 'TYPE': 'UNIQUE'},
                                       's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                           'MAP_MERGE_INDICES': {'chem_comp_link': {'ATTRIBUTES': ('link_id',), 'TYPE': 'EQUI-JOIN'}},
                           'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                           'TABLE_ID': 'CHEM_COMP_LINK',
                           'TABLE_NAME': 'chem_comp_link',
                           'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_PLANE': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID',
                                           'COMP_ID': 'comp_id',
                                           'ID': 'id',
                                           'NUMBER_ATOMS_ALL': 'number_atoms_all',
                                           'NUMBER_ATOMS_NH': 'number_atoms_nh'},
                            'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                'ORDER': 1,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                               'COMP_ID': {'NULLABLE': False,
                                                           'ORDER': 2,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': True,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 10},
                                               'ID': {'NULLABLE': False,
                                                      'ORDER': 3,
                                                      'PRECISION': 0,
                                                      'PRIMARY_KEY': True,
                                                      'SQL_TYPE': 'VARCHAR',
                                                      'WIDTH': 10},
                                               'NUMBER_ATOMS_ALL': {'NULLABLE': True,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10},
                                               'NUMBER_ATOMS_NH': {'NULLABLE': True,
                                                                   'ORDER': 5,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': False,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10}},
                            'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                              'COMP_ID': ('chem_comp_plane', 'comp_id', None, None),
                                              'ID': ('chem_comp_plane', 'id', None, None),
                                              'NUMBER_ATOMS_ALL': ('chem_comp_plane', 'number_atoms_all', None, None),
                                              'NUMBER_ATOMS_NH': ('chem_comp_plane', 'number_atoms_nh', None, None)},
                            'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                        's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                            'MAP_MERGE_INDICES': {'chem_comp_plane': {'ATTRIBUTES': ('comp_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                            'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                            'TABLE_ID': 'CHEM_COMP_PLANE',
                            'TABLE_NAME': 'chem_comp_plane',
                            'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_PLANE_ATOM': {'ATTRIBUTES': {'ATOM_ID': 'atom_id',
                                                'COMPONENT_ID': 'Component_ID',
                                                'COMP_ID': 'comp_id',
                                                'DIST_ESD': 'dist_esd',
                                                'PLANE_ID': 'plane_id'},
                                 'ATTRIBUTE_INFO': {'ATOM_ID': {'NULLABLE': False,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 6},
                                                    'COMPONENT_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                    'COMP_ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                    'DIST_ESD': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                    'PLANE_ID': {'NULLABLE': False,
                                                                 'ORDER': 4,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10}},
                                 'ATTRIBUTE_MAP': {'ATOM_ID': ('chem_comp_plane_atom', 'atom_id', None, None),
                                                   'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                   'COMP_ID': ('chem_comp_plane_atom', 'comp_id', None, None),
                                                   'DIST_ESD': ('chem_comp_plane_atom', 'dist_esd', None, None),
                                                   'PLANE_ID': ('chem_comp_plane_atom', 'plane_id', None, None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'ATOM_ID', 'PLANE_ID'),
                                                    'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'chem_comp_plane_atom': {'ATTRIBUTES': ('comp_id',
                                                                                               'atom_id',
                                                                                               'plane_id'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                 'TABLE_ID': 'CHEM_COMP_PLANE_ATOM',
                                 'TABLE_NAME': 'chem_comp_plane_atom',
                                 'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_TOR': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                         'ATOM_ID_2': 'atom_id_2',
                                         'ATOM_ID_3': 'atom_id_3',
                                         'ATOM_ID_4': 'atom_id_4',
                                         'COMPONENT_ID': 'Component_ID',
                                         'COMP_ID': 'comp_id',
                                         'ID': 'id'},
                          'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': True,
                                                           'ORDER': 3,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                             'ATOM_ID_2': {'NULLABLE': True,
                                                           'ORDER': 4,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                             'ATOM_ID_3': {'NULLABLE': True,
                                                           'ORDER': 5,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                             'ATOM_ID_4': {'NULLABLE': True,
                                                           'ORDER': 6,
                                                           'PRECISION': 0,
                                                           'PRIMARY_KEY': False,
                                                           'SQL_TYPE': 'VARCHAR',
                                                           'WIDTH': 6},
                                             'COMPONENT_ID': {'NULLABLE': False,
                                                              'ORDER': 1,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10},
                                             'COMP_ID': {'NULLABLE': False,
                                                         'ORDER': 2,
                                                         'PRECISION': 0,
                                                         'PRIMARY_KEY': True,
                                                         'SQL_TYPE': 'VARCHAR',
                                                         'WIDTH': 10},
                                             'ID': {'NULLABLE': False,
                                                    'ORDER': 7,
                                                    'PRECISION': 0,
                                                    'PRIMARY_KEY': True,
                                                    'SQL_TYPE': 'VARCHAR',
                                                    'WIDTH': 10}},
                          'ATTRIBUTE_MAP': {'ATOM_ID_1': ('chem_comp_tor', 'atom_id_1', None, None),
                                            'ATOM_ID_2': ('chem_comp_tor', 'atom_id_2', None, None),
                                            'ATOM_ID_3': ('chem_comp_tor', 'atom_id_3', None, None),
                                            'ATOM_ID_4': ('chem_comp_tor', 'atom_id_4', None, None),
                                            'COMPONENT_ID': (None, None, 'datablockid()', None),
                                            'COMP_ID': ('chem_comp_tor', 'comp_id', None, None),
                                            'ID': ('chem_comp_tor', 'id', None, None)},
                          'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'ID'), 'TYPE': 'UNIQUE'},
                                      's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                          'MAP_MERGE_INDICES': {'chem_comp_tor': {'ATTRIBUTES': ('comp_id', 'id'), 'TYPE': 'EQUI-JOIN'}},
                          'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                          'TABLE_ID': 'CHEM_COMP_TOR',
                          'TABLE_NAME': 'chem_comp_tor',
                          'TABLE_TYPE': 'transactional'},
        'CHEM_COMP_TOR_VALUE': {'ATTRIBUTES': {'ANGLE': 'angle',
                                               'ANGLE_ESD': 'angle_esd',
                                               'COMPONENT_ID': 'Component_ID',
                                               'COMP_ID': 'comp_id',
                                               'DIST': 'dist',
                                               'DIST_ESD': 'dist_esd',
                                               'TOR_ID': 'tor_id'},
                                'ATTRIBUTE_INFO': {'ANGLE': {'NULLABLE': True,
                                                             'ORDER': 4,
                                                             'PRECISION': 6,
                                                             'PRIMARY_KEY': False,
                                                             'SQL_TYPE': 'FLOAT',
                                                             'WIDTH': 10},
                                                   'ANGLE_ESD': {'NULLABLE': True,
                                                                 'ORDER': 5,
                                                                 'PRECISION': 6,
                                                                 'PRIMARY_KEY': False,
                                                                 'SQL_TYPE': 'FLOAT',
                                                                 'WIDTH': 10},
                                                   'COMPONENT_ID': {'NULLABLE': False,
                                                                    'ORDER': 1,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                   'COMP_ID': {'NULLABLE': False,
                                                               'ORDER': 2,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 10},
                                                   'DIST': {'NULLABLE': True,
                                                            'ORDER': 6,
                                                            'PRECISION': 6,
                                                            'PRIMARY_KEY': False,
                                                            'SQL_TYPE': 'FLOAT',
                                                            'WIDTH': 10},
                                                   'DIST_ESD': {'NULLABLE': True,
                                                                'ORDER': 7,
                                                                'PRECISION': 6,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'FLOAT',
                                                                'WIDTH': 10},
                                                   'TOR_ID': {'NULLABLE': False,
                                                              'ORDER': 3,
                                                              'PRECISION': 0,
                                                              'PRIMARY_KEY': True,
                                                              'SQL_TYPE': 'VARCHAR',
                                                              'WIDTH': 10}},
                                'ATTRIBUTE_MAP': {'ANGLE': ('chem_comp_tor_value', 'angle', None, None),
                                                  'ANGLE_ESD': ('chem_comp_tor_value', 'angle_esd', None, None),
                                                  'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                  'COMP_ID': ('chem_comp_tor_value', 'comp_id', None, None),
                                                  'DIST': ('chem_comp_tor_value', 'dist', None, None),
                                                  'DIST_ESD': ('chem_comp_tor_value', 'dist_esd', None, None),
                                                  'TOR_ID': ('chem_comp_tor_value', 'tor_id', None, None)},
                                'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'TOR_ID'), 'TYPE': 'UNIQUE'},
                                            's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                'MAP_MERGE_INDICES': {'chem_comp_tor_value': {'ATTRIBUTES': ('comp_id', 'tor_id'),
                                                                              'TYPE': 'EQUI-JOIN'}},
                                'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                'TABLE_ID': 'CHEM_COMP_TOR_VALUE',
                                'TABLE_NAME': 'chem_comp_tor_value',
                                'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_ATOM_EDIT': {'ATTRIBUTES': {'ATOM_ID': 'atom_id',
                                                    'COMPONENT_ID': 'Component_ID',
                                                    'COMP_ID': 'comp_id',
                                                    'EDIT_ATOM_ID': 'edit_atom_id',
                                                    'EDIT_ATOM_VALUE': 'edit_atom_value',
                                                    'EDIT_OP': 'edit_op',
                                                    'ORDINAL': 'ordinal'},
                                     'ATTRIBUTE_INFO': {'ATOM_ID': {'NULLABLE': True,
                                                                    'ORDER': 5,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 6},
                                                        'COMPONENT_ID': {'NULLABLE': False,
                                                                         'ORDER': 1,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                        'COMP_ID': {'NULLABLE': True,
                                                                    'ORDER': 3,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                        'EDIT_ATOM_ID': {'NULLABLE': True,
                                                                         'ORDER': 6,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': False,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 6},
                                                        'EDIT_ATOM_VALUE': {'NULLABLE': True,
                                                                            'ORDER': 7,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 80},
                                                        'EDIT_OP': {'NULLABLE': True,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                        'ORDINAL': {'NULLABLE': False,
                                                                    'ORDER': 2,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10}},
                                     'ATTRIBUTE_MAP': {'ATOM_ID': ('pdbx_chem_comp_atom_edit', 'atom_id', None, None),
                                                       'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                       'COMP_ID': ('pdbx_chem_comp_atom_edit', 'comp_id', None, None),
                                                       'EDIT_ATOM_ID': ('pdbx_chem_comp_atom_edit',
                                                                        'edit_atom_id',
                                                                        None,
                                                                        None),
                                                       'EDIT_ATOM_VALUE': ('pdbx_chem_comp_atom_edit',
                                                                           'edit_atom_value',
                                                                           None,
                                                                           None),
                                                       'EDIT_OP': ('pdbx_chem_comp_atom_edit', 'edit_op', None, None),
                                                       'ORDINAL': ('pdbx_chem_comp_atom_edit', 'ordinal', None, None)},
                                     'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'ORDINAL'), 'TYPE': 'UNIQUE'},
                                                 's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                     'MAP_MERGE_INDICES': {'pdbx_chem_comp_atom_edit': {'ATTRIBUTES': ('ordinal',),
                                                                                        'TYPE': 'EQUI-JOIN'}},
                                     'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                     'TABLE_ID': 'PDBX_CHEM_COMP_ATOM_EDIT',
                                     'TABLE_NAME': 'pdbx_chem_comp_atom_edit',
                                     'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_ATOM_RELATED': {'ATTRIBUTES': {'ATOM_ID': 'atom_id',
                                                       'COMPONENT_ID': 'Component_ID',
                                                       'COMP_ID': 'comp_id',
                                                       'ORDINAL': 'ordinal',
                                                       'RELATED_ATOM_ID': 'related_atom_id',
                                                       'RELATED_COMP_ID': 'related_comp_id',
                                                       'RELATED_TYPE': 'related_type'},
                                        'ATTRIBUTE_INFO': {'ATOM_ID': {'NULLABLE': True,
                                                                       'ORDER': 5,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': False,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 6},
                                                           'COMPONENT_ID': {'NULLABLE': False,
                                                                            'ORDER': 1,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 10},
                                                           'COMP_ID': {'NULLABLE': False,
                                                                       'ORDER': 2,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                           'ORDINAL': {'NULLABLE': False,
                                                                       'ORDER': 4,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'INT',
                                                                       'WIDTH': 10},
                                                           'RELATED_ATOM_ID': {'NULLABLE': True,
                                                                               'ORDER': 6,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': False,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 6},
                                                           'RELATED_COMP_ID': {'NULLABLE': False,
                                                                               'ORDER': 3,
                                                                               'PRECISION': 0,
                                                                               'PRIMARY_KEY': True,
                                                                               'SQL_TYPE': 'VARCHAR',
                                                                               'WIDTH': 10},
                                                           'RELATED_TYPE': {'NULLABLE': True,
                                                                            'ORDER': 7,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 80}},
                                        'ATTRIBUTE_MAP': {'ATOM_ID': ('pdbx_chem_comp_atom_related', 'atom_id', None, None),
                                                          'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                          'COMP_ID': ('pdbx_chem_comp_atom_related', 'comp_id', None, None),
                                                          'ORDINAL': ('pdbx_chem_comp_atom_related', 'ordinal', None, None),
                                                          'RELATED_ATOM_ID': ('pdbx_chem_comp_atom_related',
                                                                              'related_atom_id',
                                                                              None,
                                                                              None),
                                                          'RELATED_COMP_ID': ('pdbx_chem_comp_atom_related',
                                                                              'related_comp_id',
                                                                              None,
                                                                              None),
                                                          'RELATED_TYPE': ('pdbx_chem_comp_atom_related',
                                                                           'related_type',
                                                                           None,
                                                                           None)},
                                        'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID',
                                                                          'COMP_ID',
                                                                          'RELATED_COMP_ID',
                                                                          'ORDINAL'),
                                                           'TYPE': 'UNIQUE'},
                                                    's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                        'MAP_MERGE_INDICES': {'pdbx_chem_comp_atom_related': {'ATTRIBUTES': ('comp_id',
                                                                                                             'related_comp_id',
                                                                                                             'ordinal'),
                                                                                              'TYPE': 'EQUI-JOIN'}},
                                        'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                        'TABLE_ID': 'PDBX_CHEM_COMP_ATOM_RELATED',
                                        'TABLE_NAME': 'pdbx_chem_comp_atom_related',
                                        'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_AUDIT': {'ATTRIBUTES': {'ACTION_TYPE': 'action_type',
                                                'ANNOTATOR': 'annotator',
                                                'COMPONENT_ID': 'Component_ID',
                                                'COMP_ID': 'comp_id',
                                                'DATE': 'date'},
                                 'ATTRIBUTE_INFO': {'ACTION_TYPE': {'NULLABLE': False,
                                                                    'ORDER': 5,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 80},
                                                    'ANNOTATOR': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                    'COMPONENT_ID': {'NULLABLE': False,
                                                                     'ORDER': 1,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                    'COMP_ID': {'NULLABLE': False,
                                                                'ORDER': 2,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 10},
                                                    'DATE': {'NULLABLE': False,
                                                             'ORDER': 3,
                                                             'PRECISION': 0,
                                                             'PRIMARY_KEY': True,
                                                             'SQL_TYPE': 'DATETIME',
                                                             'WIDTH': 15}},
                                 'ATTRIBUTE_MAP': {'ACTION_TYPE': ('pdbx_chem_comp_audit', 'action_type', None, None),
                                                   'ANNOTATOR': ('pdbx_chem_comp_audit', 'annotator', None, None),
                                                   'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                   'COMP_ID': ('pdbx_chem_comp_audit', 'comp_id', None, None),
                                                   'DATE': ('pdbx_chem_comp_audit', 'date', None, None)},
                                 'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'DATE', 'ACTION_TYPE'),
                                                    'TYPE': 'UNIQUE'},
                                             's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                 'MAP_MERGE_INDICES': {'pdbx_chem_comp_audit': {'ATTRIBUTES': ('comp_id',
                                                                                               'date',
                                                                                               'action_type'),
                                                                                'TYPE': 'EQUI-JOIN'}},
                                 'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                 'TABLE_ID': 'PDBX_CHEM_COMP_AUDIT',
                                 'TABLE_NAME': 'pdbx_chem_comp_audit',
                                 'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_BOND_EDIT': {'ATTRIBUTES': {'ATOM_ID_1': 'atom_id_1',
                                                    'ATOM_ID_2': 'atom_id_2',
                                                    'COMPONENT_ID': 'Component_ID',
                                                    'COMP_ID': 'comp_id',
                                                    'EDIT_BOND_VALUE': 'edit_bond_value',
                                                    'EDIT_OP': 'edit_op',
                                                    'ORDINAL': 'ordinal'},
                                     'ATTRIBUTE_INFO': {'ATOM_ID_1': {'NULLABLE': False,
                                                                      'ORDER': 5,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 6},
                                                        'ATOM_ID_2': {'NULLABLE': False,
                                                                      'ORDER': 6,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 6},
                                                        'COMPONENT_ID': {'NULLABLE': False,
                                                                         'ORDER': 1,
                                                                         'PRECISION': 0,
                                                                         'PRIMARY_KEY': True,
                                                                         'SQL_TYPE': 'VARCHAR',
                                                                         'WIDTH': 10},
                                                        'COMP_ID': {'NULLABLE': False,
                                                                    'ORDER': 3,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                        'EDIT_BOND_VALUE': {'NULLABLE': True,
                                                                            'ORDER': 7,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': False,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 80},
                                                        'EDIT_OP': {'NULLABLE': False,
                                                                    'ORDER': 4,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': True,
                                                                    'SQL_TYPE': 'VARCHAR',
                                                                    'WIDTH': 10},
                                                        'ORDINAL': {'NULLABLE': True,
                                                                    'ORDER': 2,
                                                                    'PRECISION': 0,
                                                                    'PRIMARY_KEY': False,
                                                                    'SQL_TYPE': 'INT',
                                                                    'WIDTH': 10}},
                                     'ATTRIBUTE_MAP': {'ATOM_ID_1': ('pdbx_chem_comp_bond_edit', 'atom_id_1', None, None),
                                                       'ATOM_ID_2': ('pdbx_chem_comp_bond_edit', 'atom_id_2', None, None),
                                                       'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                       'COMP_ID': ('pdbx_chem_comp_bond_edit', 'comp_id', None, None),
                                                       'EDIT_BOND_VALUE': ('pdbx_chem_comp_bond_edit',
                                                                           'edit_bond_value',
                                                                           None,
                                                                           None),
                                                       'EDIT_OP': ('pdbx_chem_comp_bond_edit', 'edit_op', None, None),
                                                       'ORDINAL': ('pdbx_chem_comp_bond_edit', 'ordinal', None, None)},
                                     'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID',
                                                                       'COMP_ID',
                                                                       'EDIT_OP',
                                                                       'ATOM_ID_1',
                                                                       'ATOM_ID_2'),
                                                        'TYPE': 'UNIQUE'},
                                                 's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                     'MAP_MERGE_INDICES': {'pdbx_chem_comp_bond_edit': {'ATTRIBUTES': ('comp_id',
                                                                                                       'edit_op',
                                                                                                       'atom_id_1',
                                                                                                       'atom_id_2'),
                                                                                        'TYPE': 'EQUI-JOIN'}},
                                     'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                     'TABLE_ID': 'PDBX_CHEM_COMP_BOND_EDIT',
                                     'TABLE_NAME': 'pdbx_chem_comp_bond_edit',
                                     'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_DESCRIPTOR': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID',
                                                     'COMP_ID': 'comp_id',
                                                     'DESCRIPTOR': 'descriptor',
                                                     'ORDINAL': 'ordinal',
                                                     'PROGRAM': 'program',
                                                     'PROGRAM_VERSION': 'program_version',
                                                     'TYPE': 'type'},
                                      'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                          'ORDER': 1,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                         'COMP_ID': {'NULLABLE': False,
                                                                     'ORDER': 2,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                         'DESCRIPTOR': {'NULLABLE': True,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 2048},
                                                         'ORDINAL': {'NULLABLE': True,
                                                                     'ORDER': 7,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': 10},
                                                         'PROGRAM': {'NULLABLE': False,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 80},
                                                         'PROGRAM_VERSION': {'NULLABLE': False,
                                                                             'ORDER': 6,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 80},
                                                         'TYPE': {'NULLABLE': False,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80}},
                                      'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                        'COMP_ID': ('pdbx_chem_comp_descriptor', 'comp_id', None, None),
                                                        'DESCRIPTOR': ('pdbx_chem_comp_descriptor', 'descriptor', None, None),
                                                        'ORDINAL': ('pdbx_chem_comp_descriptor', 'ordinal', None, None),
                                                        'PROGRAM': ('pdbx_chem_comp_descriptor', 'program', None, None),
                                                        'PROGRAM_VERSION': ('pdbx_chem_comp_descriptor',
                                                                            'program_version',
                                                                            None,
                                                                            None),
                                                        'TYPE': ('pdbx_chem_comp_descriptor', 'type', None, None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID',
                                                                        'COMP_ID',
                                                                        'TYPE',
                                                                        'PROGRAM',
                                                                        'PROGRAM_VERSION'),
                                                         'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'pdbx_chem_comp_descriptor': {'ATTRIBUTES': ('comp_id',
                                                                                                         'type',
                                                                                                         'program',
                                                                                                         'program_version'),
                                                                                          'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                      'TABLE_ID': 'PDBX_CHEM_COMP_DESCRIPTOR',
                                      'TABLE_NAME': 'pdbx_chem_comp_descriptor',
                                      'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_FEATURE': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID',
                                                  'COMP_ID': 'comp_id',
                                                  'SOURCE': 'source',
                                                  'SUPPORT': 'support',
                                                  'TYPE': 'type',
                                                  'VALUE': 'value'},
                                   'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                       'ORDER': 1,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                      'COMP_ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                      'SOURCE': {'NULLABLE': False,
                                                                 'ORDER': 6,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 80},
                                                      'SUPPORT': {'NULLABLE': True,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                      'TYPE': {'NULLABLE': False,
                                                               'ORDER': 3,
                                                               'PRECISION': 0,
                                                               'PRIMARY_KEY': True,
                                                               'SQL_TYPE': 'VARCHAR',
                                                               'WIDTH': 80},
                                                      'VALUE': {'NULLABLE': False,
                                                                'ORDER': 5,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': True,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 200}},
                                   'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                     'COMP_ID': ('pdbx_chem_comp_feature', 'comp_id', None, None),
                                                     'SOURCE': ('pdbx_chem_comp_feature', 'source', None, None),
                                                     'SUPPORT': ('pdbx_chem_comp_feature', 'support', None, None),
                                                     'TYPE': ('pdbx_chem_comp_feature', 'type', None, None),
                                                     'VALUE': ('pdbx_chem_comp_feature', 'value', None, None)},
                                   'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID', 'TYPE', 'VALUE', 'SOURCE'),
                                                      'TYPE': 'UNIQUE'},
                                               's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                   'MAP_MERGE_INDICES': {'pdbx_chem_comp_feature': {'ATTRIBUTES': ('comp_id',
                                                                                                   'type',
                                                                                                   'value',
                                                                                                   'source'),
                                                                                    'TYPE': 'EQUI-JOIN'}},
                                   'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                   'TABLE_ID': 'PDBX_CHEM_COMP_FEATURE',
                                   'TABLE_NAME': 'pdbx_chem_comp_feature',
                                   'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_IDENTIFIER': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID',
                                                     'COMP_ID': 'comp_id',
                                                     'IDENTIFIER': 'identifier',
                                                     'ORDINAL': 'ordinal',
                                                     'PROGRAM': 'program',
                                                     'PROGRAM_VERSION': 'program_version',
                                                     'TYPE': 'type'},
                                      'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                          'ORDER': 1,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                         'COMP_ID': {'NULLABLE': False,
                                                                     'ORDER': 2,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 10},
                                                         'IDENTIFIER': {'NULLABLE': True,
                                                                        'ORDER': 3,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': False,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 2048},
                                                         'ORDINAL': {'NULLABLE': True,
                                                                     'ORDER': 7,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': False,
                                                                     'SQL_TYPE': 'INT',
                                                                     'WIDTH': 10},
                                                         'PROGRAM': {'NULLABLE': False,
                                                                     'ORDER': 5,
                                                                     'PRECISION': 0,
                                                                     'PRIMARY_KEY': True,
                                                                     'SQL_TYPE': 'VARCHAR',
                                                                     'WIDTH': 80},
                                                         'PROGRAM_VERSION': {'NULLABLE': False,
                                                                             'ORDER': 6,
                                                                             'PRECISION': 0,
                                                                             'PRIMARY_KEY': True,
                                                                             'SQL_TYPE': 'VARCHAR',
                                                                             'WIDTH': 80},
                                                         'TYPE': {'NULLABLE': False,
                                                                  'ORDER': 4,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 80}},
                                      'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                        'COMP_ID': ('pdbx_chem_comp_identifier', 'comp_id', None, None),
                                                        'IDENTIFIER': ('pdbx_chem_comp_identifier', 'identifier', None, None),
                                                        'ORDINAL': ('pdbx_chem_comp_identifier', 'ordinal', None, None),
                                                        'PROGRAM': ('pdbx_chem_comp_identifier', 'program', None, None),
                                                        'PROGRAM_VERSION': ('pdbx_chem_comp_identifier',
                                                                            'program_version',
                                                                            None,
                                                                            None),
                                                        'TYPE': ('pdbx_chem_comp_identifier', 'type', None, None)},
                                      'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID',
                                                                        'COMP_ID',
                                                                        'TYPE',
                                                                        'PROGRAM',
                                                                        'PROGRAM_VERSION'),
                                                         'TYPE': 'UNIQUE'},
                                                  's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                      'MAP_MERGE_INDICES': {'pdbx_chem_comp_identifier': {'ATTRIBUTES': ('comp_id',
                                                                                                         'type',
                                                                                                         'program',
                                                                                                         'program_version'),
                                                                                          'TYPE': 'EQUI-JOIN'}},
                                      'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                      'TABLE_ID': 'PDBX_CHEM_COMP_IDENTIFIER',
                                      'TABLE_NAME': 'pdbx_chem_comp_identifier',
                                      'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_IMPORT': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID', 'COMP_ID': 'comp_id'},
                                  'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                      'ORDER': 1,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': True,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 10},
                                                     'COMP_ID': {'NULLABLE': False,
                                                                 'ORDER': 2,
                                                                 'PRECISION': 0,
                                                                 'PRIMARY_KEY': True,
                                                                 'SQL_TYPE': 'VARCHAR',
                                                                 'WIDTH': 10}},
                                  'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                    'COMP_ID': ('pdbx_chem_comp_import', 'comp_id', None, None)},
                                  'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'COMP_ID'), 'TYPE': 'UNIQUE'},
                                              's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                  'MAP_MERGE_INDICES': {'pdbx_chem_comp_import': {'ATTRIBUTES': ('comp_id',),
                                                                                  'TYPE': 'EQUI-JOIN'}},
                                  'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                  'TABLE_ID': 'PDBX_CHEM_COMP_IMPORT',
                                  'TABLE_NAME': 'pdbx_chem_comp_import',
                                  'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_RELATED': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID',
                                                  'COMP_ID': 'comp_id',
                                                  'DETAILS': 'details',
                                                  'RELATED_COMP_ID': 'related_comp_id',
                                                  'RELATIONSHIP_TYPE': 'relationship_type'},
                                   'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                       'ORDER': 1,
                                                                       'PRECISION': 0,
                                                                       'PRIMARY_KEY': True,
                                                                       'SQL_TYPE': 'VARCHAR',
                                                                       'WIDTH': 10},
                                                      'COMP_ID': {'NULLABLE': False,
                                                                  'ORDER': 2,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': True,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 10},
                                                      'DETAILS': {'NULLABLE': True,
                                                                  'ORDER': 5,
                                                                  'PRECISION': 0,
                                                                  'PRIMARY_KEY': False,
                                                                  'SQL_TYPE': 'VARCHAR',
                                                                  'WIDTH': 200},
                                                      'RELATED_COMP_ID': {'NULLABLE': False,
                                                                          'ORDER': 3,
                                                                          'PRECISION': 0,
                                                                          'PRIMARY_KEY': True,
                                                                          'SQL_TYPE': 'VARCHAR',
                                                                          'WIDTH': 10},
                                                      'RELATIONSHIP_TYPE': {'NULLABLE': False,
                                                                            'ORDER': 4,
                                                                            'PRECISION': 0,
                                                                            'PRIMARY_KEY': True,
                                                                            'SQL_TYPE': 'VARCHAR',
                                                                            'WIDTH': 80}},
                                   'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                     'COMP_ID': ('pdbx_chem_comp_related', 'comp_id', None, None),
                                                     'DETAILS': ('pdbx_chem_comp_related', 'details', None, None),
                                                     'RELATED_COMP_ID': ('pdbx_chem_comp_related',
                                                                         'related_comp_id',
                                                                         None,
                                                                         None),
                                                     'RELATIONSHIP_TYPE': ('pdbx_chem_comp_related',
                                                                           'relationship_type',
                                                                           None,
                                                                           None)},
                                   'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID',
                                                                     'COMP_ID',
                                                                     'RELATED_COMP_ID',
                                                                     'RELATIONSHIP_TYPE'),
                                                      'TYPE': 'UNIQUE'},
                                               's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                   'MAP_MERGE_INDICES': {'pdbx_chem_comp_related': {'ATTRIBUTES': ('comp_id',
                                                                                                   'related_comp_id',
                                                                                                   'relationship_type'),
                                                                                    'TYPE': 'EQUI-JOIN'}},
                                   'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                   'TABLE_ID': 'PDBX_CHEM_COMP_RELATED',
                                   'TABLE_NAME': 'pdbx_chem_comp_related',
                                   'TABLE_TYPE': 'transactional'},
        'PDBX_CHEM_COMP_SYNONYMS': {'ATTRIBUTES': {'COMPONENT_ID': 'Component_ID',
                                                   'COMP_ID': 'comp_id',
                                                   'NAME': 'name',
                                                   'ORDINAL': 'ordinal',
                                                   'PROVENANCE': 'provenance',
                                                   'TYPE': 'type'},
                                    'ATTRIBUTE_INFO': {'COMPONENT_ID': {'NULLABLE': False,
                                                                        'ORDER': 1,
                                                                        'PRECISION': 0,
                                                                        'PRIMARY_KEY': True,
                                                                        'SQL_TYPE': 'VARCHAR',
                                                                        'WIDTH': 10},
                                                       'COMP_ID': {'NULLABLE': False,
                                                                   'ORDER': 4,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'VARCHAR',
                                                                   'WIDTH': 10},
                                                       'NAME': {'NULLABLE': True,
                                                                'ORDER': 3,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 1024},
                                                       'ORDINAL': {'NULLABLE': False,
                                                                   'ORDER': 2,
                                                                   'PRECISION': 0,
                                                                   'PRIMARY_KEY': True,
                                                                   'SQL_TYPE': 'INT',
                                                                   'WIDTH': 10},
                                                       'PROVENANCE': {'NULLABLE': True,
                                                                      'ORDER': 5,
                                                                      'PRECISION': 0,
                                                                      'PRIMARY_KEY': False,
                                                                      'SQL_TYPE': 'VARCHAR',
                                                                      'WIDTH': 80},
                                                       'TYPE': {'NULLABLE': True,
                                                                'ORDER': 6,
                                                                'PRECISION': 0,
                                                                'PRIMARY_KEY': False,
                                                                'SQL_TYPE': 'VARCHAR',
                                                                'WIDTH': 80}},
                                    'ATTRIBUTE_MAP': {'COMPONENT_ID': (None, None, 'datablockid()', None),
                                                      'COMP_ID': ('pdbx_chem_comp_synonyms', 'comp_id', None, None),
                                                      'NAME': ('pdbx_chem_comp_synonyms', 'name', None, None),
                                                      'ORDINAL': ('pdbx_chem_comp_synonyms', 'ordinal', None, None),
                                                      'PROVENANCE': ('pdbx_chem_comp_synonyms', 'provenance', None, None),
                                                      'TYPE': ('pdbx_chem_comp_synonyms', 'type', None, None)},
                                    'INDICES': {'p1': {'ATTRIBUTES': ('COMPONENT_ID', 'ORDINAL', 'COMP_ID'), 'TYPE': 'UNIQUE'},
                                                's1': {'ATTRIBUTES': ('COMPONENT_ID',), 'TYPE': 'SEARCH'}},
                                    'MAP_MERGE_INDICES': {'pdbx_chem_comp_synonyms': {'ATTRIBUTES': ('ordinal', 'comp_id'),
                                                                                      'TYPE': 'EQUI-JOIN'}},
                                    'TABLE_DELETE_ATTRIBUTE': 'COMPONENT_ID',
                                    'TABLE_ID': 'PDBX_CHEM_COMP_SYNONYMS',
                                    'TABLE_NAME': 'pdbx_chem_comp_synonyms',
                                    'TABLE_TYPE': 'transactional'}}

    

    def __init__(self,verbose=True,log=sys.stderr):
        super(ChemCompSchemaDef,self).__init__(databaseName=ChemCompSchemaDef._databaseName,schemaDefDict=ChemCompSchemaDef._schemaDefDict,
                                           verbose=verbose,log=log)


if __name__ == "__main__":
    sd=ChemCompSchemaDef()
    tableIdList=sd.getTableIdList()

    for tableId in tableIdList:
        aIdL=sd.getAttributeIdList(tableId)
        tObj=sd.getTable(tableId)
        attributeIdList=tObj.getAttributeIdList()
        attributeNameList=tObj.getAttributeNameList()
        sys.stdout.write("Ordered attribute Id   list %s\n" % (str(attributeIdList)))
        sys.stdout.write("Ordered attribute name list %s\n" % (str(attributeNameList)))
        #
        mAL=tObj.getMapAttributeNameList()
        sys.stdout.write("Ordered mapped attribute name list %s\n" % (str(mAL)))

        mAL=tObj.getMapAttributeIdList()
        sys.stdout.write("Ordered mapped attribute id   list %s\n" % (str(mAL)))

        cL=tObj.getMapInstanceCategoryList()
        sys.stdout.write("Mapped category list %s\n" % (str(cL)))
        for c in cL:
            aL=tObj.getMapInstanceAttributeList(c)
            sys.stdout.write("Mapped attribute list in %s :  %s\n" % (c,str(aL)))


