# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['async_rx',
 'async_rx.multicast',
 'async_rx.observable',
 'async_rx.protocol',
 'async_rx.subject']

package_data = \
{'': ['*']}

install_requires = \
['curio>=1,<2']

extras_require = \
{':python_version < "3.8"': ['typing-extensions>=3.7.4.2,<4.0.0.0']}

setup_kwargs = {
    'name': 'async-rx',
    'version': '1.0.4',
    'description': 'Rx or the observable pattern with curio async.',
    'long_description': '# async-rx\n\n\n[![Unix Build Status](https://img.shields.io/travis/geronimo-iia/async-rx/master.svg?label=unix)](https://travis-ci.com/geronimo-iia/async-rx)\n[![Codacy Badge](https://api.codacy.com/project/badge/Grade/fe669a02b4aa46b5b1faf619ba2bf382)](https://www.codacy.com/app/geronimo-iia/async-rx?utm_source=github.com&amp;utm_medium=referral&amp;utm_content=geronimo-iia/async-rx&amp;utm_campaign=Badge_Grade)\n[![Coverage Status](https://coveralls.io/repos/github/geronimo-iia/async-rx/badge.svg?branch=master)](https://coveralls.io/github/geronimo-iia/async-rx?branch=master)[![Scrutinizer Code Quality](https://img.shields.io/scrutinizer/g/geronimo-iia/async-rx.svg)](https://scrutinizer-ci.com/g/geronimo-iia/async-rx/?branch=master)[![PyPI Version](https://img.shields.io/pypi/v/async-rx.svg)](https://pypi.org/project/async-rx)\n[![PyPI License](https://img.shields.io/pypi/l/async-rx.svg)](https://pypi.org/project/async-rx)\n\nVersions following [Semantic Versioning](https://semver.org/)\n\n\n## Overview\n\nA free implementation of "rx" alias "react" alias "the power of observable pattern and his children" for application server side.\n\nImplementation is based on:\n\n- async function with curio framework\n- user Protocol declaration for type checking\n- our friends: poetry, flake8, black, isort, pytest, mypy, sphinx, tox, travis ...\n- a taste of namedtuple\n- a lot of closed variable, clojure function, inner function\n- a taste of curiosity\n- shake it, again a little bit and tadaa !\n\n\n## Installation\n\nInstall this library directly into an activated virtual environment:\n\n```text\n$ pip install async-rx\n```\n\nor add it to your [Poetry](https://poetry.eustace.io/) project:\n\n```text\n$ poetry add async-rx\n```\n\nNote about Python version support:\n\n- python code and test use python 3.8+\n- typing extensions give us an optional python < 3.8 support\n\n\n## API and Usage\n\nAfter installation, the package can imported:\n\n```text\n$ python\n>>> import async_rx\n>>> async_rx.__version__\n```\n\nTake a look on [documentation](https://geronimo-iia.github.io/async-rx) and [API](https://geronimo-iia.github.io/async-rx/api.html).\n\n\n\n| Function Name                                                                                                               | Description                                                                          |\n| --------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------ |\n| [rx_observer(on_next, on_error, on_completed)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_observer) | Return an observer.                                                                  |\n| [rx_observer_from(observer, on_next, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_observer_from)       | Build an observer from another one.                                                  |\n| [rx_collector(initial_value)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_collector)                  | Create an observer collector.                                                        |\n| [rx_create(subscribe, ensure_contract, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_create)     | Create an observable with specific delayed execution ‘subscribe’.                    |\n| [rx_defer(observable_factory)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_defer)                 | Create an observable when a subscription occurs.                                     |\n| [rx_distinct(observable, frame_size)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_distinct)          | Create an observable which send distinct event inside a windows of size #frame_size. |\n| [rx_empty()](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_empty)                                   | Create an empty Observable.                                                          |\n| [rx_filter(observable, predicate, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_filter)                                                                                        | Create an observable which event are filtered by a predicate function.               |\n| [rx_first(observable)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_first)                                                                                                       | Create an observale which only take the first event and complete.                    |\n| [rx_forward(observable, except_complet, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_forward)                                                                                  | Create an observable wich forward event.                                             |\n| [rx_from(observable_input)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_from)                                                                                                  | Convert almost anything to an Observable.                                            |\n| [rx_last(observable, count)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_last)                                                                                                 | Create an observale which only take #count (or less) last events and complete.       |\n| [rx_of(*args)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_of)                                                                                                               | Convert arguments into an observable sequence.                                       |\n| [rx_range(start, stop, step)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_range)                                                                                                | Create an observable sequence of range.                                              |\n| [rx_skip(observable, count)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_skip)                                                                                                 | Create an obervable wich skip #count event on source.                                |\n| [rx_take(observable, count)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_take)                                                                                                 | Create an observable which take only first #count event maximum (could be less).     |\n| [rx_throw(error)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_throw)                                                                                                            | Create an observable wich always call error.                                         |\n| [rx_reduce(observable, accumulator, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_reduce)                                                                                      | Create an observable which reduce source with accumulator and seed value.            |\n| [rx_count(observable)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_count)                                                                                                       | Create an observable wich counts the emissions on the source and emits result.       |\n| [rx_max(observable)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_max)                                                                                                         | Create an observable wich returns the maximal item in the source when completes.     |\n| [rx_min(observable)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_min)                                                                                                         | Create an observable wich returns minimal item in the source when completes.         |\n| [rx_sum(observable)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_sum)                                                                                                         | Create an observable wich return the sum items in the source when completes.         |\n| [rx_avg(observable)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_avg)                                                                                                         | Create an observable wich return the average items in the source when completes.     |\n| [rx_buffer(observable, buffer_size)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_buffer)                                                                                         | Buffer operator.                                                                     |\n| [rx_window(observable, buffer_size)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_window)                                                                                         | Window operator.                                                                     |\n| [rx_merge(*observables)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_merge)                                                                                                     | Flattens multiple Observables together by blending their values into one Observable. |\n| [rx_concat(*observables)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_concat)                                                                                                    | Concat operator.                                                                     |\n| [rx_zip(*observables)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_zip)                                                                                                       | Combine multiple Observables to create an Observable.                                |\n| [rx_amb(*observables)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_amb)                                                                                                       | Amb operator.                                                                        |\n| [rx_map(observable, transform, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_map)                                                                                           | Map operator.                                                                        |\n| [rx_merge_map(*observables, transform)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_merge_map)                                                                                      | Merge map operator.                                                                  |\n| [rx_group_by(observable, key_selector)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_group_by)                                                                                      | Group by operator.                                                                   |\n| [rx_sample(observable, duration)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_sample)                                                                                            | Sample operator used to rate-limit the sequence.                                     |\n| [rx_throttle(observable, duration)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_throttle)                                                                                          | Throttle operator.                                                                   |\n| [rx_delay(observable, duration, buffer_size, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_delay)                                                                             | Delay operator.                                                                      |\n| [rx_debounce(an_observable, duration)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_debounce)                                                                                       | Debounce operator.                                                                   |\n| [rx_dict(initial_value)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_dict)                                                                                                     | Create an observable on dictionnary.                                                 |\n| [rx_list(initial_value)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_list)                                                                                                     | Create an observable on list.                                                        |\n| [rx_repeat(duration, producer)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_repeat)                                                                                              | Repeat data.                                                                         |\n| [rx_repeat_series(source, ratio)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_repeat_series)                                                                                            | Repeat a series (delay, value) as an observable for each subscription.               |\n| [rx_subject(subject_handler)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_subject)                                                                                                | Create a subject.                                                                    |\n| [rx_subject_from(a_subject, subscribe, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_subject_from)                                                                                   | Build a subject from another one by override some function.                          |\n| [rx_subject_replay(buffer_size, subject_handler)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_subject_replay)                                                                            | Create a replay subject.                                                             |\n| [rx_subject_behavior(subject_handler)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_subject_behavior)                                                                                       | Create a behavior subject.                                                           |\n| [rx_publish(an_observable, subject_handler, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_publish)                                                                              | Create a Connectable Observable.                                                     |\n| [rx_publish_replay(an_observable, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_publish_replay)                                                                                        | Create a publish_replay.                                                             |\n| [rx_publish_behavior(an_observable, …)](https://geronimo-iia.github.io/async-rx/api.html#async_rx.rx_publish_behavior)                                                                                      | Create a publish_behavior.                                                           |\n\n## A short sample\n\nWith this amazing observer:\n\n```python\nclass ObserverCounterCollector:\n    def __init__(self):\n        self.on_next_count = 0\n        self.on_completed_count = 0\n        self.on_error_count = 0\n        self.items: Any = list([]) # a bad idea isn\'t it\n\n    async def on_next(self, item: Any) -> None:\n        """Process item."""\n        self.items.append(item)\n        self.on_next_count += 1\n\n    async def on_completed(self) -> None:\n        """Signal completion of this observable."""\n        self.on_completed_count += 1\n\n    async def on_error(self, err: Any) -> None:\n        self.on_error_count += 1\n\n```\n\nWe will going to select odd number:\n\n```python\nasync def _predicate(item: int) -> bool:\n    return item % 2 == 0\n\nseeker = ObserverCounterCollector()\n\nobservable = rx_range(start=0, stop=100) # create an observable of [0, 1, ..., 99]\nsub = await rx_filter(observable=observable, predicate=_predicate).subscribe(an_observer=seeker) # filter and subscribe\nsub() # release resource\n\n# we have :\nassert seeker.on_next_count == 50\nassert seeker.on_completed_count == 1\nassert seeker.on_error_count == 0\nassert seeker.items[0:6] == [0, 2, 4, 6, 8, 10]\n\n```\n\n\n## Your new on react/rx and wanna taste it ?\n\nFirst question: Where to begin ?\n\nIf you read this page, you probably ever doing lot of search on google & co, and probably loose as me about\nreact component in html/js/whatever.\nI can\'t purpose your the best state of the explanation, but... AMHPOV, if you like to known how slug are done behind the scene, you should remember:\n\n- what is Observable pattern (or listener, alias callback)\n- what is an event emiter (something which send event ?)\n\nok, with this in mind:\n\n- an observer receive event from an observable when he subscribe on it\n- events are "on_next(item)", "on_completed()", and ... "on_error(err)"\n\nTake a look in "protocole.py" and come back :)\n\nDid you see Observer/Observable/XXXHandler/Subscribe ? And Subcription (yes it will called for unsubscribe) ?\n\nSo ```rx_from([1, 2, ...])``` create an observable which will send items of list in sequence when an observer subscribe on it.\nTake time to look at test unit :)\nYou can go into observable module and see all rx_from, rx_defer, rx_last, ...\n\nBut but but, what is a freaking "subject" ?\n\nIt\'s like an observer AND an observable which can multicast items from an observable to several observers.\nAs it is an observer, it can receive data from somewhere. \nAs it is an observable, observer can subscribe on it.\n\nTake a look under subject module and test unit, see what is a replay_subject, funny no ?\nSee the function [subject](https://geronimo-iia.github.io/async-rx/api.html#async_rx.Subject).\n\nAt the last for the goods: the big gun, the "ConnectableObservable" alias multicast. oh my god, they kill kenny!\n\nIts like a subject which you can connect/disconnect as you want or automatically (with a call on ref_count).\n"connect" mean that subject start to receive from observable, so items will be send on observers.\n\nI hope this could help you a little bit :)\n\n\n## Reference\n\n - [RxPy](https://github.com/ReactiveX/RxPY)\n - [reactivex](http://reactivex.io/documentation/observable.html)\n - [reactjs](https://reactjs.org/)\n - [The Reactive Manifesto](https://www.reactivemanifesto.org/)\n - [working with unreliable observers using reactive extensions](https://www.ru.nl/publish/pages/769526/dorus_peelen.pdf)\n - ...\n\n\n\n\n\n\n',
    'author': 'Jerome Guibert',
    'author_email': 'jguibert@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://pypi.org/project/async_rx',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
