"use strict";(self.webpackChunkcodechecker=self.webpackChunkcodechecker||[]).push([[820],{93820:(e,n,t)=>{t.r(n),t.d(n,{default:()=>s});const s='WEB GUI User Guide\n==================\n\n**CodeChecker** is a static analysis infrastructure built on the [LLVM/Clang\nStatic Analyzer](http://clang-analyzer.llvm.org) toolchain, alternative tool\nfor [`scan-build`](http://clang-analyzer.llvm.org/scan-build.html) in a Linux\nor macOS (OS X) development environment.\n\n<div class="github">More descriptions and guides available\n<a href="https://github.com/Ericsson/codechecker/blob/master/docs/README.md">\non GitHub</a>\n</div>\n\nTable of Contents\n=================\n\n- [WEB GUI User Guide](#web-gui-user-guide)\n- [Table of Contents](#table-of-contents)\n- [Products](#products)\n  - [Managing products](#managing-products)\n    - [Add new product](#add-new-product)\n      - [Disable review status change](#disable-review-status-change)\n      - [Confidentiality classification](#confidentiality-classification)\n    - [Edit product configuration](#edit-product-configuration)\n    - [Remove a product](#remove-a-product)\n  - [Managing permissions](#managing-permissions)\n  - [Notification banner](#notification-banner)\n- [Runs and history events](#runs-and-history-events)\n  - [Runs](#runs)\n    - [Show description](#show-description)\n    - [Show check command](#show-check-command)\n    - [Show analyzer statistics](#show-analyzer-statistics)\n    - [Filter runs](#filter-runs)\n    - [Compare runs](#compare-runs)\n    - [Sorting runs](#sorting-runs)\n    - [Delete runs](#delete-runs)\n  - [Run history](#run-history)\n    - [Compare run history events](#compare-run-history-events)\n    - [Filter run history events](#filter-run-history-events)\n- [Reports](#reports)\n  - [Review status](#review-status)\n  - [Detection status](#detection-status)\n  - [Severity levels](#severity-levels)\n  - [Filtering reports](#filtering-reports)\n    - [Date filters](#date-filters)\n    - [Regex based filters](#regex-based-filters)\n    - [Report count](#report-count)\n    - [Remove filtered reports](#remove-filtered-reports)\n    - [Clear report filters](#clear-report-filters)\n    - [Unique reports](#unique-reports)\n  - [Compare mode](#compare-mode)\n    - [Compare two different runs](#compare-two-different-runs)\n    - [Compare two different tagged versions of the same](#compare-two-different-tagged-versions-of-the-same)\n  - [Manage source components](#manage-source-components)\n  - [Manage cleanup plans](#manage-cleanup-plans)\n  - [Assign reports to cleanup plans](#assign-reports-to-cleanup-plans)\n- [Report details](#report-details)\n  - [Report Navigation Tree](#report-navigation-tree)\n  - [Button pane](#button-pane)\n    - [Report info](#report-info)\n    - [Show documentation](#show-documentation)\n    - [Change review status](#change-review-status)\n  - [Same reports](#same-reports)\n  - [Bug path view](#bug-path-view)\n  - [Comment](#comment)\n- [Statistics](#statistics)\n  - [Statistics pages](#statistics-pages)\n    - [Product overview](#product-overview)\n    - [Checker statistics](#checker-statistics)\n    - [Severity statistics](#severity-statistics)\n    - [Component statistics](#component-statistics)\n  - [Filtering statistics](#filtering-statistics)\n    - [Uniqueing checker statistics](#uniqueing-checker-statistics)\n\n# Products\nThe product system allows a single CodeChecker server to serve multiple\nseparate result databases, named `products`, under the same IP address and\nauthentication domain. Each product can be configured to use a separate\ndatabase and the access control can be configured separately for each product\nby product administrators.\n\nMost of the time a product represents a single GIT repository. For example we\ncan create separate CodeChecker products for\n[postgresql](https://github.com/postgres/postgres),\n[curl](https://github.com/curl/curl),\n[bitcoin](https://github.com/bitcoin/bitcoin) or\n[openssl](https://github.com/openssl/openssl) repositories.\n\n**Note**: comparison and statistics features can be used inside one product and\nnot between multiple products.\n\n![Products](images/products/products.png)\n\nIn the product list table you can see the following information:\n- `Product name`: display name of the product.\n- `Confidentiality classification`: The confidentiality category this product\nbelongs to.\n- `Description`: short description of the product.\n- `Administrator names`: product admins have the right to allow access for\nindividual people or LDAP groups.\n- `Number of runs`: number of runs in the product.\n- `Latest store to the product`: date of the latest run storage.\n- `Run store in progress`: show run names if a storage is in progress.\n- `Action buttons` (only for ADMINS): action buttons to edit and remove\nproducts.\n\n**Note**: if you don\'t have permission for a product and you see the following\nmessage, ask permission from a product admin:\n\n![Products](images/products/no_permission.png)\n\n## Managing products\n### Add new product\nClick to the *NEW PRODUCT* button above the product list table, then fill the\nform presented. The values that need to be filled here are the same as the\narguments for `CodeChecker cmd products add`.\n\n**NOTE**: only users with `Super Users` access can add a new product.\n\n![New product](images/products/new_product.png)\n\nIf the product creation is successful, the window will disappear and the\nproduct will appear in the product list.\n\n#### Disable review status change\nReview status change can be disabled on the WEB UI to force programmers to use\ninline source code comments. This can be configured on the product editing\nwindow by administrators of a product.\n\n![Disable review status change](images/products/disable_review_status_change.png)\n\n#### Confidentiality classification\nThe confidentiality level of the product can be set here. There are three options:\n* Confidential classified\n* Internal classified\n* Open classified\n\n![Confidentiality classification](images/products/confidentiality.png)\n\n### Edit product configuration\nEditing a product configuration is done through the pencil icon which can be\nfound in the latest *Actions* column of the product list table.\n\n![Edit product](images/products/edit_product.png)\n\n### Remove a product\nProducts can be deleted by clicking on the red trash bin in the *Actions*\ncolumn of the product list table. This way the product is only unmounted from\nthe server (losing access control data and connection), but\n**no analysis results are deleted**. Database needs to be deleted separately.\n\n![Remove product](images/products/remove_product.png)\n\n## Managing permissions\n* Server-wide permissions can be edited by clicking *EDIT GLOBAL PERMISSION*\nbutton above the product list page. Only users with `Super Users` access can\nedit global permissions.\n* Product-level permissions can be edited by clicking the edit icon\n(blue pencil) for the product you want to configure the permissions.\n\nThe two lists show the users and groups known to the system - if a tick is\npresent in its row, the given user or group has the permission directly\ngranted. (Users who only have a certain permission through permission\ninheritance are not shown with a tick.)\n\n![Product permissions](images/products/product_permissions.png)\n\nOnly the permissions you have rights to manage are shown.\n\nYou can edit multiple permissions opening the window only once. Simply tick or\nuntick the users/groups you want to give the permission to or revoke from them.\nClicking *SAVE* will save the changes to the database.\n\n## Notification banner\nThere is an option to set a global notification text, that will show on top of\nevery page below the header bar.\n\n![Notification](images/products/notification.png)\n\nYou can edit this alert on the products page with `EDIT ANNOUNCEMENT` button,\nbut **Super User** permissions are necessary.\n\n![Products](images/products/edit_announcement_btn.png)\n\nYou can remove the current notification by saving an empty text.\n\n![Notification Dialog](images/products/notificaiton_dialog.png)\n\n# Runs and history events\n## Runs\nA run represents subsequent analysis activities for the same source code with\nthe same analysis settings (checker configurations). We are storing analysis\nresults to a run within a product:\n\n```sh\nCodeChecker store \\\n  --name master_xerces \\\n  --url https://my.codechecker.server.com/xerces\n  ./reports\n```\n\n![Runs](images/runs/runs.png)\n\nThis page contains the analysis runs available on the server under the selected\nproduct.\n\nEach run has the following fields/columns:\n- `Delete`: in the first column of the run list table you can select multiple\nruns which will be removed by clicking on the *DELETE* button. For more\ninformation [see](#delete-runs).\n- `Unique name` which identifies a run. If an already existing run name is\nused during the storage, the run will be updated: a new history event will\nbe created for the run and the detection status will be changed for each\nreport.\n  - `Version tag` (optional): a unique identifier for this individual store of\nresults in the run\'s history.\n  - `Description` (optional): a custom textual description to be shown alongside\nthe run. You can find more information how to see the description\n[here](#show-description).\n  - `Check command` which was used to analyze your project. You can find more\n  information how to see the check command [here](#show-check-command).\n  - `Detection status counts`: show the number of reports distributed by\n  detection statuses.\n- `Number of unresolved reports`: number of non unique reports excluding\n*Resolved*, *False positive* and *Intentional* reports.\n- `Analyzer statistics`: information about the analysis. You can find more\ninformation how to see the analysis statistics\n[here](#show-analyzer-statistics).\n- `Latest storage date`: latest storage/update date of the run.\n- `Analysis duration`: the length of the analysis.\n- `CodeChecker version` which was used during the analysis.\n- `Diff`: in this column you can select two runs (*baseline* and\n*compared to*) which will be compared to each other by click on the *DIFF*\nbutton. For more information [see](#compare-runs).\n\n### Show description\nDescription is a custom textual description to be shown alongside the run and\ngiven by the `CodeChecker store` command:\n```sh\nCodeChecker store \\\n  --name xerces \\\n  --description "Analysis results of the Xerces-C++ project." \\\n  --url https://my.codechecker.server.com/xerces \\\n  ./reports\n```\n\nClick on the [i] button beside the run name to show the description.\n\n![Show description](images/runs/show_description.png)\n\n### Show check command\nCheck/Analyze command is the command which was used to analyze your project:\n```sh\nCodeChecker analyze \\\n  -o ./reports \\\n  -e sensitive \\\n  ./compilation_database.json\n```\n\nClick on the console button under the run name to show the check command.\n\n![Show check command](images/runs/show_check_command_btn.png)\n\n![Check command](images/runs/check_command.png)\n\n### Show analyzer statistics\nAnalyzer statistics show the following information for each analyzer\n(Clang Static Analyzer, Clang Tidy):\n- Analyzer version.\n- Number of successfully analyzed files.\n- Number of files which failed to analyze.\n- List of files which failed to analyze.\n\nClick on the *Analyzer statistics column* to show analyzer statistics for a\nrun.\n![Show analyzer statistics](images/runs/show_analyzer_statistics_btn.png)\n\n![Analyzer statistics](images/runs/analyzer_statistics.png)\n\nNote that analysis failure may come with incomplete results. Possible reasons\nof analysis failure are gcc/clang incompatibility (thus compilation error),\nanalyzer runtime crash, etc.\n\n### Filter runs\nYou can filter runs by run name using the input box above the run list table.\nThe filter is **case insensitive** and does a **substring matching**. If we\nstart typing some phrase in this input box, the list are being\n*filtered automatically*.\n\n![Filter runs](images/runs/filter_runs.png)\n\n**NOTE**:\n- other filters in beside the run name filter can be used to filter\nrun history events.\n- filters will be saved in the URL query parameter list.\n\n### Compare runs\nCalculates the difference between two analyses of the project, showing which\nreports have been fixed and which are newly introduced.\n\nTo compare analysis results you have to do the following:\n- select *BASELINE** runs with the first checkbox in the *Diff* column of the\nrun list table.\n- select *COMPARE TO** runs with the second checkbox in the *Diff* column of\nthe run list table.\n- click on the `Diff` button above the run list table.\n\n![Compare runs](images/runs/compare_runs.png)\n\n### Sorting runs\nIt is possible to change the order of the runs by clicking on a cell at the\nheader of the run list table. For example, you can sort the run list by the\nstorage date or the run name.\n\n![Sort runs](images/runs/sort_runs.png)\n\n### Delete runs\nYou can delete multiple runs by selecting them with the checkboxes in the first\ncolumn of the run list table and clicking on the `DELETE` button above the run\nlist table. It will remove the run and all related data from the database.\n\n![Delete runs](images/runs/delete_runs.png)\n\n**IMPORTANT**: be careful when you delete a run because this operation can not\nbe undone.\n\n## Run history\nOn every run storage event a history event is created for the run. You can\nsee the history events for a run if you click to the expand arrow (`v` icon)\nbeside the run name column.\n\nYou will see the following information for each history event:\n- `Storage date` when the run was stored to the server.\n- `User name` who performed the `CodeChecker store` operation.\n- `Show statistics` button which can be used to show the statistics for this\nhistory event.\n- `Check command` which was used to analyze your project. You can click to the\nconsole style button (`>_` icon) to see the actual check command of the\nhistory event.\n- `CodeChecker version` which was used during the analysis.\n- `Analyzer statistics`: information about the analysis. You can click to this\nsection to see the details.\n\n![Run history](images/runs/show_run_history.png)\n\n### Compare run history events\nCalculates difference between two analyses of the same run storage, showing\nwhich reports have been fixed and which are newly introduced.\n\nTo compare analysis history events you have to do the following:\n- select *BASELINE** runs with the first checkbox in the *Diff* column of the\nrun list table for a history event.\n- select *COMPARE TO** runs with the second checkbox in the *Diff* column of\nthe run list table for a history event.\n- click on the `Diff` button above the run list table.\n\n### Filter run history events\nYou can filter run history events with the tag name and storage date input\nboxes above the run list table.\n\n![Filter run history events](images/runs/filter_run_history_events.png)\n\n*Note*: the filters will be saved in the URL query parameter list.\n\n# Reports\nIf you select a run at the [list of runs](#runs) view, you get to this page.\nThis page lists the analysis result for the given run.\n\n![Reports](images/reports/reports.png)\n\nEvery report has the following fields:\n- `Unique report identifier` (repot hash). You can find more information how\nthese hashes are generated [here](https://github.com/Ericsson/codechecker/blob/master/docs/analyzer/report_identification.md).\n- `File path`: file path where the report is found.\n- `Line and column numbers` of the report where the bug is.\n- `Checker name` which found the report during the analysis.\n- `Checker message`: description about the report.\n- `Analyzer name` which found the problem during the analysis.\n- [`Severity`](#severity-levels)\n- `Bug path length`: length of the bug path. Reports with longer bug path\nare more difficult to understand.\n- [`Latest review status`](#review-status)\n- [`Latest detection status`](#detection-status). This column is visible only\nwhen uniqueing is disabled.\n- `Detection date`: the storage date when the report was stored to the server\nfor the first time. This field is visible only when you hover your mouse over\nthe *Detection status* icon.\n- `Fix date`: storage date when the report is dissapeared from a run update.\nThis field is visible only when you hover your mouse over the\n*Detection status* icon.\n\n## Review status\nReports can be assigned a review status of the following values:\n- <span class="customIcon review-status-unreviewed"></span> **Unreviewed**\n(_default_): Nobody has seen this report.\n- <span class="customIcon review-status-confirmed"></span> **Confirmed**:\nThis is really a bug.\n- <span class="customIcon review-status-false-positive"></span>\n**False positive**: This is not a bug. Before marking a bug false positive\nyou should read the [false positive how to](https://github.com/Ericsson/codechecker/blob/master/docs/analyzer/false_positives.md).\n- <span class="customIcon review-status-intentional"></span> **Intentional**:\nThis report is a bug but we don\'t want to fix it.\n\n![Review statuses](images/reports/review_statuses.png)\n\n\nReview status can be set on the [GUI](#userguide-change-review-status) or by using\n[source code comments ](https://github.com/Ericsson/codechecker/blob/master/docs/analyzer/user_guide.md#source-code-comments)\n(*codechecker_false_positive*, *codechecker_confirmed*, etc.)\n\nReview status set in source comments are applied on the individual report instances, while\nreview status set in the GUI are added as Review Status Rules connected to\n[report hashes](https://github.com/Ericsson/codechecker/blob/master/docs/analyzer/report_identification.md).\n\nSo when  you chang the review status of a report in the GUI,\nit will change the review status in all reports with the same hash\nin all runs. Reports stored in the future with the same hash will also get the same review status.\n\nSo once you set the review status in the GUI,\nthere is no need to set the same review status again in other runs.\n\n\n\n**Note**: source code comment is stronger and can overwrite the value in the\ndatabase.\n\nReview status values added in the WEB GUI are stored as Review Status Rules\nand can be managed in the Configuration/ReviewStatusRules tab.\n![Review Status Rules](images/review_status_rules/review_status.rules.png)\n\n\n## Detection status\nThe detection status is the state of a bug report in a run.\n\n- The detection status of a report is connected to the **report ID**. It means\nthat every report has a separate detection status.\n- It will be *calculated automatically* by the server on run storage events\nbased on the reports in the last storage and the current storage.\n- Changing the review status by using source code comments will not affect\nthe detection status change.\n\nWhen storing the results of a run from scratch then each report has\ndetection status <span class="customIcon detection-status-new"></span> **New**.\nWhen the reports stored again with the same run name then the detection status\ncan change to one of the following options:\n- <span class="customIcon detection-status-resolved"></span> **Resolved**: when\nthe bug report can\'t be found after the subsequent storage.\n- <span class="customIcon detection-status-unresolved"></span> **Unresolved**:\nwhen the bug report is still among the results after the subsequent storage.\n- <span class="customIcon detection-status-reopened"></span> **Reopened**: when\na resolved bug appears again.\n- <span class="customIcon detection-status-off"></span> **Off**: were reported\nby a checker that is switched off during the last analysis which results were\nstored.\n- <span class="customIcon detection-status-unavailable"></span> **Unavailable**:\nwere reported by a checker that does not exists anymore because it was removed\nor renamed.\n\n![Detection statuses](images/reports/detection_statuses.png)\n\nThe diagram below shows the detection status transition which may happen when\nstoring results to the server. For example if the detection status of a report\nin the database is **New** the server will change it to **Unresolved**,\n**Resolved**, **Off** or **Unavailable** based on the conditions above.\n\n![Detection status change](images/reports/detection_status_flow_chart.png)\n\n## Severity levels\nWe are mapping checker names to different severity levels:\n- <span class="customIcon icon-severity-critical"></span> **Critical**:\nclang-diagnostic-error (compilation error and the analysis was not successful).\n- <span class="customIcon icon-severity-high"></span> **High**:\n*core.DivideZero*, *core.NullDereference*, *cplusplus.NewDelete*, etc.\n- <span class="customIcon icon-severity-medium"></span> **Medium**:\n*unix.Malloc*, *core.uninitialized.Assign*, etc.\n- <span class="customIcon icon-severity-low"></span> **Low**\n*deadcode.DeadStores*, *misc-unused-parameters*, etc.\n- <span class="customIcon icon-severity-style"></span> **Style**:\n*modernize-raw-string-literal*, *modernize-use-auto*, etc.\n- <span class="customIcon icon-severity-unspecified"></span> **Unspecified**:\n*android-cloexec-dup*, etc.\n\n![Severity levels](images/reports/severity_levels.png)\n\n## Filtering reports\nWhen opening the Reports list view on the left sidebar you will see the\nfollowing:\n\n![Report filters](images/reports/filters.png)\n\nThe following filter options are available:\n- [`Unique reports`](#unique-reports) - You can uniqueing the reports by\nchecking this. For more information click [here](#unique-reports).\n- **Baseline**\n  - `Run / Tag Filter` - You can select one or more run names with tags. The\n  result list is restricted on the findings in these runs/tags. By selecting a\n  specific run in the *runs* view this field is filled by default.\n  When runs are stored in update mode (i.e. on the same run name), then the\n  specific runs can be tagged in order to be easier to identify them. By this\n  field you can also select the reports found during a specific run event. For\n  this you can use the cogwheel button beside each run after hovering on the\n  run to specify a tag.\n  - `Outstanding reports on a given date` - Filter reports that were\n  <i>DETECTED BEFORE</i> the given date and <i>NOT FIXED BEFORE</i> the given\n  date.\n- [**Compare to**](#diff-mode)\n  - `Run / Tag Filter` - Here you can select multiple runs / tags which you\n  want to compare against the baseline filter set.\n  - `Outstanding reports on a given date` - Here you can select date which\n  you want to compare against the baseline filter set.\n  - `Diff type` - Here you can set if you\'d like to see the reports which\n  appear only in the **Baseline**, **Compare to** or both.\n- `File path`: You can choose a set of files to restrict the list of bug\nreports.\n- `Checker name` - If you are interested in specific type of bugs then here\nyou can choose them.\n- [`Severity`](#severity-levels) - The nature of the reports is sorted\nin different severity levels. For example, a division by zero or a null pointer\ndereference is more serious than an unused variable. By this field you can\nselect the reports on the given severity levels.\n- [`Latest Review Status`](#review-status) - You can select the reports\nwith the given review status to check only *False positive*, *Unreviewed*, etc.\nreports.\n- [`Latest Detection Status`](#detection-status) - You can select the\nreports with the given detection status to check only *Unresolved*, *Resolved*,\netc. reports.\n- `Analyzer name` - If you are interested in specific type of reports which\nwere detected by an analyzer (Clang Tidy, CppCheck etc.) then here you can\nchoose them.\n- [`Source component`](https://github.com/Ericsson/codechecker/blob/master/docs/web/user_guide.md#source-components) -\nHere you can select multiple source components which are named collections of\ndirectories specified as directory filter.\n- `Checker message` - The static analysis tools provide a message to indicate\nthe reason of a specific bug. This message is also filterable.\n- **Dates**\n  - `Detection date` - Filter reports that were detected between the given\n  interval.\n  - `Fix date` - Filter reports that were fixed between the given interval.\n- `Report hash` - Every report has a unique (hash) identifier called Report\nIdentifier which can be filtered by using this input box.\n- `Bug path length` - A bug path length interval can restrict the list of\ndisplayed bug reports. In these fields you can choose the minimum and maximum\nvalues of bug path length.\n\nEvery filter is collapsed by default to save more space in the UI. To expand\nthe filter and see the selected filter items you can click on the down arrow\n(`v` icon) beside each filter name.\n\n### Date filters\nEvery report has a detection date and a fix date.\n- `Detection date`: the storage date when the report was stored to the server\nfor the first time.\n- `Fix date`: storage date when the report is dissapeared from a run update.\n\nAvailable date filters:\n- `Detection date`: get results which were detected between the given dates.\n- `Fix date`: get results which were fixed between the given dates.\n- `Outstanding reports on a given date`: get results which were\n<i>DETECTED BEFORE</i> the given date and <i>NOT FIXED BEFORE</i> the given\ndate.\n\n### Regex based filters\nAt `Run / Tag filter`, `File path`, `Checker message` and `Report hash` filters\nyou can filter the results by using the `*` quantifiers which matches any\nnumber of characters (zero or more). So if you have for example `run_1_a_name`,\n`run_2_b_name`, `run_2_c_name`, `run_3_d_name` then `run_2*` will select\n`run_2_b_name` and `run_2_c_name`.\n\n![Filter runs](images/reports/filter_runs.png)\n\n### Report count\nWhen you select a filter option on any field then a number indicates on the\nright side of the option the number of reports which belong to that specific\noption. If the report count could not be determined this value will be *N/A*.\n\n### Remove filtered reports\nFiltered reports can be removed by clicking on the **REMOVE FILTERED REPORS**\nbutton at the bottom of the filter bar.\n\n**!!!WARNING!!!**: once you have removed filtered reports it can not be undone.\nPlease make sure that you want to remove all filtered results before clicking\non this button.\n\n![Remove filtered reports](images/reports/remove_filtered_reports.png)\n\n### Clear report filters\nFilter options can be cleared separately by clicking on the trash icon beside\na filter or all filters can be cleared by using *CLEAR ALL FILTERS* button at\nthe top of the filter bar.\n\n![Clear all filters](images/reports/clear_all_filters.png)\n\n![Clear report filters](images/reports/clear_report_filters.png)\n\n### Unique reports\nAt the top of the filter panel there is a `Unique reports` checkbox. This\nnarrows the report list to unique bug (group findings that have the same\n*Report Identifier* (report hash) within or across multiple runs).\n\nThe same bug may appear several times if it is found on different control\npaths, i.e. through different function calls or in multiple runs. By checking\n`Unique reports` a report appears only once even if it is found on several\npaths.\n\n![Unique reports](images/reports/unqiue_reports.png)\n\nReports can be expanded to see all the reports with the same hash by using the\nexpand arrow (`v` icon) beside the report hash.\n\n**Note**: detection status is not shown in this view and only the file name is\nshown because same report may have different detection statuses or can be\nfound under different file paths.\n\n## Compare mode\nIn compare mode you can calculate the difference between multiple analyses of\nthe project, showing which reports have been fixed and which are newly\nintroduced or which can be found in all runs.\n\nAt the **Baseline** filter section you can select the run names / tags against\nwhich you want to check the difference.\n\nAt the **Compare to** filter section you can select the run names / tags which\nyou want to compare against the *Baseline* runs and run tags.\n\nYou can also use the `Outstanding report on a given date` filter to compare\nreports by dates.\n\nBy **Diff type** field it can be chosen whether reports **Only in Baseline**,\n**Only in Compare to** or **Both in Baseline and Compare to** should be shown.\nAt each option the number of reports is displayed for the given category. Note,\nthat the number of **Both in Baseline and Compare to** plus the number of\n**Only in Compare to** add up the number of **Compare to**, but this addition\nmay not work for the number of **Baseline** reports. This behavior can be\ndemonstrated by the following example. Suppose that two analyses are stored\nwith the following reports. Some reports are occurring multiple times in a run.\nThese can be made unique by [Unique reports](#unique-reports) tick-box.\n\n| Baseline        | Compare to      |\n|-----------------|---------------- |\n| `report_hash_1` |                 |\n| `report_hash_1` |                 |\n| `report_hash_2` | `report_hash_2` |\n| `report_hash_2` | `report_hash_2` |\n| `report_hash_2` | `report_hash_2` |\n|                 | `report_hash_2` |\n|                 | `report_hash_3` |\n\nThe multiplicity of comparison categories:\n\n- **Only in Baseline**: `report_hash_1` (2x)\n- **Only in Compare to**: `report_hash_3` (1x)\n- **Both in Baseline and Compare to**: `report_hash_2` (4x)\n\nNote that `report_hash_2` is displayed 4 times like in **Compare to** and not\n3 times like in **Baseline**.\n\n### Compare two different runs\n![Compare two different runs](images/reports/compare_runs.png)\n\n### Compare two different tagged versions of the same\n![Compare two different tagged versions of the same](images/reports/compare_tags.png)\n\n## Manage source components\nSource components are named collections of directory filters which can be used\nto filter run results (reports) by multiple file paths. Source components\ncan be managed only by administrators after clicking on the pencil icon at the\nSource component filter.\n\n![Manage source components](images/reports/manage_source_components.png)\n\nA pop-up window will be opened where you can add, edit or remove existing\nsource components.\n\n![List of source components](images/reports/list_of_source_components.png)\n\nEach line should begin with a `+` or a `-`, followed by a path glob pattern:\n- `+`: *ONLY* results from the matching file paths will be listed.\n- `-`: results from the matching file paths will not be listed.\n\nFor more information [see](https://github.com/Ericsson/codechecker/blob/master/docs/web/user_guide.md#format-of-component-file).\n\n## Manage cleanup plans\nYou can use **cleanup plans** to track progress of reports in your product.\nClenup plans can be managed only by *administrators* after clicking on the\n*pencil icon* at the *Cleanup plans* filter.\n\n![Manage cleanup plans](images/reports/cleanup_plan_filter.png)\n\nA pop-up window will be opened where you can add, edit, close or remove\nexisting cleanup plans.\n\n![List of cleanup plans](images/reports/list_of_cleanup_plans.png)\n\n## Assign reports to cleanup plans\nYou can assign multiple reports to a cleanup plan on the **Reports view**. For\nthis you have to select at least one report by using check boxes on the first\ncolumn of the report list table.\n\nAfter reports are selected the **Set cleanup plan** above the reports table\nwill be active and you can select a cleanup plan here by clicking on the\ncleanup plan name.\n\nYou can remove reports from a cleanup plan the same way by clicking on the\ncleanup plan name.\n\nNotes:\n- You can select all reports on the current page by using the checkbox in\nthe first column of the header bar.\n- If multiple reports are selected and at least one report can be found in a\ncleanup plan but not all of them, after clicking on the **Set cleanup plan**\nbutton beside the cleanup plan a minus sign (**-**) will be shown. Clicking\non the cleanup plan name in this case will assign every selected report to\nthe cleanup.\n\n![Assign reports to cleanup plan](images/reports/assign_reports_to_cleanup_plan.png)\n\nYou can also assign current report to a cleanup plan on the **Report detail**\nview:\n![Assign reports to cleanup plan](images/reports/assign_report_to_cleanup_plan.png)\n\n# Report details\n## Report Navigation Tree\nReport Navigation Tree shows the found reports at the currently opened file.\nThe reports are grouped by the severity level. You can navigate between them\nby clicking on a node in the tree.\n\n![Report navigation tree](images/report/report_navigation_tree.png)\n\n## Button pane\nButton Pane contains several items which help you to change or get some\nproperty of the currently opened report.\n\n![Button pane](images/report/button_pane.png)\n\n### Report info\n`REPORT INFO` button shows detailed information about the currently opened\nreport such as *Report ID*, *Run name*, *Detection / Fix date* etc.\n\n### Show documentation\n`SHOW DOCUMENTATION` button shows the documentation of the actual checker which\nidentified the currently opened report.\n\n![Checker documentation](images/report/checker_documentation.png)\n\n### Change review status\nReports can be assigned a review status of *Unreviewed*, *Confirmed*, *False\npositive*, *Intentional* along with an optional comment on why this status was\napplied.\n\nIt can be changed on the GUI or by using\n[source code comments](https://github.com/Ericsson/codechecker/blob/master/docs/analyzer/user_guide.md#source-code-comments)\n(*codechecker_false_positive*, *codechecker_confirmed*, etc.)\n\nWe can change the review status on the GUI from the default\n<span class="customIcon review-status-unreviewed"></span> *Unreviewed* option\nto something else in the report details view above the file view.\n\n![Unreviewed](images/report/review_status_unreviewed.png)\n\nIf you changed the review status, you can optionally explain the reason why\nyou changed it.\n![Change review status](images/report/review_status_change.png)\n\nIf somebody has already changed the review status from the default one, you can\nsee extra information (who changed the review status, when and why) beside\nthe review status selector by hovering on the message icon. This message icon\nis hidden by default if nobody has changed the review status.\n\n![Review status message](images/report/review_status_message.png)\n\n**Note**: source code comments have priority over the value stored in the\ndatabase.\n\n## Same reports\nSeveral reports may belong to a specific bug if the bug itself can be reached\non different control paths. With the `Found in` select option you can check\nwhether the selected report is available on a different path.\n\n![Same reports](images/report/same_reports.png)\n\n## Bug path view\nSome checkers are able to follow the execution path along the control flow of\nthe program. If a bug appears on any of these paths, then CodeChecker is able\nto present the full path on which this so called symbolic execution reached the\nplace of error. This path can be checked in this bug path view.\n\n![Bug path](images/report/bug_path.png)\n\n## Comment\nThere are 2 types of comments:\n- `user based` comments.\n- `system` comments.\n\nYou can add new user comments, edit\n(<span class="customIcon edit" style="padding:0px"></span>) and delete\n(<span class="customIcon delete" style="padding:0px"></span>) them.\n\nThe author of the comment will be the currently logged in user. If the user is\nnot logged in, the author of the comment will be *Anonymous*.\n\nSystem comments are automatically generated on the following events:\n- on user comment update.\n- on review status change.\n\nSystem comments are cannot be removed.\n\n![Comment](images/report/comment.png)\n\n**Note**: comments are connected to report hashes. This way the comments are\nshown for the same report found in multiple runs.\n\n# Statistics\n\n## Statistics pages\nMultiple statistics are available inside the GUI:\n- [Product overview](#product-overview): overview of the quality status of the\ncurrent product.\n- [Checker statistics](#checker-statistics): shows the number of reports\ngrouped by checker names.\n- [Severity statistics](#severity-statistics): shows the number of reports\ngrouped by severity levels.\n- [Component statistics](#component-statistics): shows the number of reports\ngrouped by source components.\n\n### Product overview\nThis page shows an overview of the quality status of the current product.\n\n![Product overview](images/statistics/product_overview.png)\n\nIt has the following sections:\n- Number of *NEW* reports which were detected `today` / `yesterday` /\n`last 7 days` / `last 31 days`.\n- Number of *RESOLVED* reports which were detected `today` / `yesterday` /\n`last 7 days` / `last 31 days`.\n- Number of outstanding reports which are not fixed yet.\n- Number of failed files in the current product. If you click to the number it\nwill show you the list of failed files in a dialog.\n- Number of checkers reporting faults.\n- Number of outstanding reports chart per severity level. By default it will\nshow statistics for the last 6 months. You can change it by using the input box\nin the top-right corner of this chart.\n- Component statistics table grouped by severity levels. Each row can be\nexpanded which will show a checker statistics for the actual component.\n\n### Checker statistics\nShows the number of reports grouped by checker names.\n\n![Checker statistics](images/statistics/checker_statistics.png)\n\n### Severity statistics\nShows the number of reports grouped by severity levels.\n\n![Severity statistics](images/statistics/severity_statistics.png)\n\n### Component statistics\nShows the number of reports grouped by source components.\n\n![Component statististics](images/statistics/component_statistics.png)\n\nEach row can be expanded by using the `^` button beside the component name. It\nwill show a checker statistics table for the selected component.\n\n![Component statististics](images/statistics/component_statistics_expanded.png)\n\n## Filtering statistics\nWe can get statistics only for specified runs, files, checker names etc. by\nusing the filter bar.\n\nFor more information [see](#filtering-reports)\n\n### Uniqueing checker statistics\nThe same bug may appear several times if it is found on different execution\npaths, i.e. through different function calls. By checking **Unique reports** a\nreport appears only once even if it is found on several paths.\n\nBy default uniqueing is enabled for statistics.\n\nYou can find more information how the report hashes are generated\n[here](https://github.com/Ericsson/codechecker/blob/master/docs/analyzer/report_identification.md).\n'}}]);