# Generated by Django 2.2.17 on 2020-12-18 01:34

from django.db import migrations, models
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='JWK',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(editable=False, verbose_name='Created at')),
                ('expires_at', models.DateTimeField(editable=False, null=True, verbose_name='Expires at')),
                ('rotated_at', models.DateTimeField(editable=False, null=True, verbose_name='Rotated at')),
                ('algorithm', models.CharField(blank=True, choices=[('RS256', 'RS256'), ('RS384', 'RS384'), ('RS512', 'RS512'), ('PS256', 'PS256'), ('PS384', 'PS384'), ('PS512', 'PS512'), ('ES256', 'ES256'), ('ES384', 'ES384'), ('ES512', 'ES512'), ('EdDSA', 'EdDSA')], default='RS512', max_length=10, verbose_name='Algorithm')),
                ('private_key_pem', models.BinaryField(default=None, null=True, verbose_name='Private key')),
                ('key_uuid', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='Key ID')),
                ('eddsa_curve', models.CharField(blank=True, choices=[('Ed25519', 'Ed25519'), ('Ed448', 'Ed448')], default='Ed25519', max_length=10, verbose_name='EdDSA curve')),
                ('rsa_public_exponent', models.IntegerField(default=65537, verbose_name='RSA public exponent')),
                ('rsa_size', models.IntegerField(choices=[(1024, '1024'), (2048, '2048'), (4096, '4096')], default=2048, verbose_name='RSA key size')),
            ],
            options={
                'verbose_name': 'JWK',
                'verbose_name_plural': 'JWKs',
                'ordering': ['-created_at'],
            },
        ),
    ]
