"""Add Webhook and WebhookLog

Revision ID: ac62100e37c4
Revises: 30bddbb1abd8
Create Date: 2023-03-02 15:14:05.476824

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "ac62100e37c4"
down_revision = "30bddbb1abd8"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "fief_webhooks",
        sa.Column("url", sa.String(length=255), nullable=False),
        sa.Column("secret", sa.String(length=255), nullable=False),
        sa.Column("events", sa.JSON(), nullable=False),
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_fief_webhooks_created_at"),
        "fief_webhooks",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_webhooks_updated_at"),
        "fief_webhooks",
        ["updated_at"],
        unique=False,
    )
    op.create_table(
        "fief_webhook_logs",
        sa.Column("webhook_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("event", sa.String(length=255), nullable=False),
        sa.Column("attempt", sa.Integer(), nullable=False),
        sa.Column("payload", sa.Text(), nullable=False),
        sa.Column("success", sa.Boolean(), nullable=False),
        sa.Column("response", sa.Text(), nullable=True),
        sa.Column("error_type", sa.String(length=255), nullable=True),
        sa.Column("error_message", sa.Text(), nullable=True),
        sa.Column("id", fief.models.generics.GUID(), nullable=False),
        sa.Column(
            "created_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.Column(
            "updated_at",
            fief.models.generics.TIMESTAMPAware(timezone=True),
            server_default=sa.func.now(),
            nullable=False,
        ),
        sa.ForeignKeyConstraint(
            ["webhook_id"], ["fief_webhooks.id"], ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(
        op.f("ix_fief_webhook_logs_created_at"),
        "fief_webhook_logs",
        ["created_at"],
        unique=False,
    )
    op.create_index(
        op.f("ix_fief_webhook_logs_updated_at"),
        "fief_webhook_logs",
        ["updated_at"],
        unique=False,
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(
        op.f("ix_fief_webhook_logs_updated_at"), table_name="fief_webhook_logs"
    )
    op.drop_index(
        op.f("ix_fief_webhook_logs_created_at"), table_name="fief_webhook_logs"
    )
    op.drop_table("fief_webhook_logs")
    op.drop_index(op.f("ix_fief_webhooks_updated_at"), table_name="fief_webhooks")
    op.drop_index(op.f("ix_fief_webhooks_created_at"), table_name="fief_webhooks")
    op.drop_table("fief_webhooks")
    # ### end Alembic commands ###
