"""Add TenantOAuthProvider

Revision ID: 30bddbb1abd8
Revises: f50cd0e11d49
Create Date: 2023-02-16 10:06:17.643794

"""
import sqlalchemy as sa
from alembic import op

import fief

# revision identifiers, used by Alembic.
revision = "30bddbb1abd8"
down_revision = "f50cd0e11d49"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "fief_tenants_oauth_providers",
        sa.Column("tenant_id", fief.models.generics.GUID(), nullable=False),
        sa.Column("oauth_provider_id", fief.models.generics.GUID(), nullable=False),
        sa.ForeignKeyConstraint(
            ["oauth_provider_id"], ["fief_oauth_providers.id"], ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(["tenant_id"], ["fief_tenants.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("tenant_id", "oauth_provider_id"),
    )

    op.execute(
        """
        INSERT INTO fief_tenants_oauth_providers
        SELECT fief_tenants.id, fief_oauth_providers.id FROM fief_tenants, fief_oauth_providers
    """
    )

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("fief_tenants_oauth_providers")
    # ### end Alembic commands ###
