#!/usr/bin/env python3
#
# Copyright 2021 Graviti. Licensed under MIT License.
#

"""Utility classes."""

from .attr import AttrsMixin, attr, attr_base, camel, upper
from .common import (
    DefaultValueDeprecated,
    Deprecated,
    Disable,
    EqMixin,
    KwargsDeprecated,
    MatrixType,
    common_loads,
    locked,
)
from .itertools import chunked
from .name import NameList, NameMixin, SortedNameList
from .repr import ReprMixin, ReprType, repr_config
from .type import SubcatalogTypeRegister, TypeEnum, TypeMixin, TypeRegister
from .user import UserMapping, UserMutableMapping, UserMutableSequence, UserSequence

__all__ = [
    "AttrsMixin",
    "DefaultValueDeprecated",
    "Deprecated",
    "Disable",
    "EqMixin",
    "KwargsDeprecated",
    "MatrixType",
    "NameList",
    "NameMixin",
    "ReprMixin",
    "ReprType",
    "SortedNameList",
    "SubcatalogTypeRegister",
    "TypeEnum",
    "TypeMixin",
    "TypeRegister",
    "UserMapping",
    "UserMutableMapping",
    "UserMutableSequence",
    "UserSequence",
    "attr",
    "attr_base",
    "camel",
    "chunked",
    "common_loads",
    "locked",
    "repr_config",
    "upper",
]
