from . import auth, errors, fastmail, methods, models
from .__version__ import __version__ as version
from .client import Client, ClientError, EventSourceConfig
from .errors import Error
from .methods import Request, ResponseOrError
from .models import (
    AddedItem,
    Address,
    Blob,
    Comparator,
    Delivered,
    DeliveryStatus,
    Displayed,
    Email,
    EmailAddress,
    EmailBodyPart,
    EmailBodyValue,
    EmailHeader,
    EmailQueryFilter,
    EmailQueryFilterCondition,
    EmailQueryFilterOperator,
    EmailSubmission,
    EmailSubmissionQueryFilter,
    EmailSubmissionQueryFilterCondition,
    EmailSubmissionQueryFilterOperator,
    Envelope,
    Event,
    Identity,
    ListOrRef,
    Mailbox,
    MailboxQueryFilter,
    MailboxQueryFilterCondition,
    MailboxQueryFilterOperator,
    Operator,
    SearchSnippet,
    SetError,
    StateChange,
    StrOrRef,
    Thread,
    TypeState,
    UndoStatus,
)
from .ref import Ref, ResultReference

__all__ = [
    "AddedItem",
    "Address",
    "Blob",
    "Client",
    "ClientError",
    "Comparator",
    "Delivered",
    "DeliveryStatus",
    "Displayed",
    "Email",
    "EmailAddress",
    "EmailBodyPart",
    "EmailBodyValue",
    "EmailHeader",
    "EmailQueryFilter",
    "EmailQueryFilterCondition",
    "EmailQueryFilterOperator",
    "EmailSubmission",
    "EmailSubmissionQueryFilter",
    "EmailSubmissionQueryFilterCondition",
    "EmailSubmissionQueryFilterOperator",
    "Envelope",
    "Error",
    "Event",
    "EventSourceConfig",
    "Identity",
    "ListOrRef",
    "Mailbox",
    "MailboxQueryFilter",
    "MailboxQueryFilterCondition",
    "MailboxQueryFilterOperator",
    "Operator",
    "Ref",
    "Request",
    "ResponseOrError",
    "ResultReference",
    "SearchSnippet",
    "SetError",
    "StateChange",
    "StrOrRef",
    "Thread",
    "TypeState",
    "UndoStatus",
    "auth",
    "fastmail",
    "errors",
    "log",
    "methods",
    "models",
    "version",
]
