from django.utils.translation import gettext_lazy as _

from pfx.pfxcore.http import JsonResponse

from .shortcuts import f


class APIError(Exception):
    def __init__(self, message, status=400, **kwargs):
        self.status = status
        self.data = dict(message=message, **kwargs)

    @property
    def response(self):
        return JsonResponse(self.data, status=self.status)


class ModelNotFoundAPIError(APIError):
    def __init__(self, model, **kwargs):
        super().__init__(
            f(_("{model} not found."), model=model._meta.verbose_name),
            status=404, **kwargs)


class AuthenticationError(APIError):
    def __init__(self, message=None, status=401, **kwargs):
        super().__init__(
            f(message or _("Authentication Error")),
            status=status, **kwargs)


class UnauthorizedError(APIError):
    def __init__(self, **kwargs):
        super().__init__(
            f(_("Unauthorized")),
            status=401, **kwargs)


class ForbiddenError(APIError):
    def __init__(self, **kwargs):
        super().__init__(
            f(_("Forbidden")),
            status=403, **kwargs)


class NotFoundError(APIError):
    def __init__(self, **kwargs):
        super().__init__(
            f(_("Resource not found")),
            status=404, **kwargs)
