# coding: utf-8

"""
    IBM Watson Machine Learning REST API

    ## Authorization  ### IBM Watson Machine Learning Credentials  To start working with API one needs to generate an `access token` using the `username` and `password` available on the Service Credentials tab of the IBM Watson Machine Learning service instance or also available in the VCAP environment variable.  Example of the Service Credentials:  ```json {     \"url\": \"https://ibm-watson-ml.mybluemix.net\",     \"access_key\": \"ERY9vcBfE4sE+F4g8hcotF9L+j81WXWeZv\",     \"username\": \"c1ef4b80-2ee2-458e-ab92-e9ca97ec657d\",     \"password\": \"030528d4-5a3e-4d4c-9258-5d553513be6f\" } ```  Example of obtaining `access token` from Token Endpoint using HTTP Basic Auth (for details please refer to Token section below):  ` curl --basic --user username:password https://ibm-watson-ml.mybluemix.net/v3/identity/token `   ### Apache Spark Service Credentials  The IBM Watson Machine Learning co-operates with the Apache Spark as a Service to deploy pipeline models. For API methods requiring Apache Spark Service instance a custom header: `X-Spark-Service-Instance` with Service Credentials must be specified. The header value is a **base64 encoded** string with the Service Credentials JSON data.  [Example of API method requiring Apache Spark Service](https://console.ng.bluemix.net/docs/services/PredictiveModeling/index-gentopic1.html#pm_service_api_spark_batch)

    OpenAPI spec version: 2.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.
"""

from __future__ import absolute_import

# import models into model package
from .array_model_metrics_output import ArrayModelMetricsOutput
from .array_model_output import ArrayModelOutput
from .array_model_version_output import ArrayModelVersionOutput
from .array_pipeline_output import ArrayPipelineOutput
from .array_pipeline_version_output import ArrayPipelineVersionOutput
from .artifact_author import ArtifactAuthor
from .artifact_version_metadata import ArtifactVersionMetadata
from .artifact_version_short_metadata import ArtifactVersionShortMetadata
from .batch_deploy_output import BatchDeployOutput
from .batch_deploy_output_entity import BatchDeployOutputEntity
from .batch_deploy_output_entity_execution import BatchDeployOutputEntityExecution
from .batch_deploy_output_meta import BatchDeployOutputMeta
from .batch_input import BatchInput
from .batch_output import BatchOutput
from .batch_output_array import BatchOutputArray
from .cols_output import ColsOutput
from .connection import Connection
from .deploy_input import DeployInput
from .error_message import ErrorMessage
from .evaluation_definition import EvaluationDefinition
from .evaluation_definition_metrics import EvaluationDefinitionMetrics
from .input_data_schema import InputDataSchema
from .internal_input_batch import InternalInputBatch
from .internal_output_batch import InternalOutputBatch
from .json_patch_array import JsonPatchArray
from .json_patch_entity import JsonPatchEntity
from .meta_object import MetaObject
from .meta_object_metadata import MetaObjectMetadata
from .model_input import ModelInput
from .model_metrics import ModelMetrics
from .model_metrics_values import ModelMetricsValues
from .model_output import ModelOutput
from .model_output_entity import ModelOutputEntity
from .model_output_entity_pipeline_version import ModelOutputEntityPipelineVersion
from .model_training_data_ref import ModelTrainingDataRef
from .model_type import ModelType
from .model_version_input import ModelVersionInput
from .model_version_output import ModelVersionOutput
from .model_version_output_entity import ModelVersionOutputEntity
from .model_version_output_entity_model import ModelVersionOutputEntityModel
from .pipeline_input import PipelineInput
from .pipeline_output import PipelineOutput
from .pipeline_output_entity import PipelineOutputEntity
from .pipeline_type import PipelineType
from .pipeline_version_input import PipelineVersionInput
from .pipeline_version_output import PipelineVersionOutput
from .pipeline_version_output_entity import PipelineVersionOutputEntity
from .pipeline_version_output_entity_parent import PipelineVersionOutputEntityParent
from .runtime_environment import RuntimeEnvironment
from .score_input import ScoreInput
from .score_output import ScoreOutput
from .spark_service import SparkService
from .stream_input_internal import StreamInputInternal
from .stream_internal import StreamInternal
from .stream_output import StreamOutput
from .stream_output_array import StreamOutputArray
from .stream_output_internal import StreamOutputInternal
from .token_response import TokenResponse
from .training_data_schema import TrainingDataSchema
from .content_location import ContentLocation
from .content_status import ContentStatus
from .output_data_schema import OutputDataSchema

# import v3 models into model package
from .array_data_input_repository import ArrayDataInputRepository
from .artifact_version_repository import ArtifactVersionRepository
from .author_repository import AuthorRepository
from .connection_object_with_name_repository import ConnectionObjectWithNameRepository
from .error_repository import ErrorRepository
from .error_repository_target import ErrorRepositoryTarget
from .error_schema_repository import ErrorSchemaRepository
from .evaluation_definition_repository import EvaluationDefinitionRepository
from .evaluation_definition_repository_metrics import EvaluationDefinitionRepositoryMetrics
from .framework_output_repository import FrameworkOutputRepository
from .framework_output_repository_runtimes import FrameworkOutputRepositoryRuntimes
from .framework_output_repository_libraries import  FrameworkOutputRepositoryLibraries
from .meta_object_repository import MetaObjectRepository
from .meta_object_repository_metadata import MetaObjectRepositoryMetadata
from .ml_assets_create_experiment_input import MlAssetsCreateExperimentInput
from .ml_assets_create_experiment_output import MlAssetsCreateExperimentOutput
from .ml_assets_create_experiment_output_array import MlAssetsCreateExperimentOutputArray
from .ml_assets_create_model_input import MlAssetsCreateModelInput
from .ml_assets_create_model_output import MlAssetsCreateModelOutput
from .ml_assets_create_model_output_array import MlAssetsCreateModelOutputArray
from .ml_assets_model_size_output import MlAssetsModelSizeOutput
from .ml_assets_get_presigned_url_output import MlAssetsGetPreSignedUrlOutput
from .ml_assets_upload_content_output import MlAssetsUploadContentOutput
from .ml_assets_upload_content_output_metadata import MlAssetsUploadContentOutputMetadata
from .ml_assets_upload_content_output_entity import MlAssetsUploadContentOutputEntity


from .model_content_location import ModelContentLocation
from .training_models import TrainingModels
from .space_models import SpaceModels
from .runtime_models import RuntimeModels
from .software_spec_models import SoftwareSpecModels
from .model_schemas import ModelSchemas
from .pipeline_models import PipelinesModels
from .model_content_location import ModelContentLocation
from .custom_models import ModelsCustom
from .metrics_models import ModelsMetrics
from .model_schemas import ModelSchemas
from .size_models import ModelsSize
from .training_models import TrainingModels








# import experiments
from .array_model_version_metrics_experiments import ArrayModelVersionMetricsExperiments
from .array_training_output_experiments import ArrayTrainingOutputExperiments
from .author_experiments import AuthorExperiments
from .compute_configuration_experiments import ComputeConfigurationExperiments
from .connection_object_source_experiments import ConnectionObjectSourceExperiments
from .connection_object_target_experiments import ConnectionObjectTargetExperiments
from .error_experiments import ErrorExperiments
from .error_experiments_target import ErrorExperimentsTarget
from .error_schema_experiments import ErrorSchemaExperiments
from .evaluation_definition_experiments import EvaluationDefinitionExperiments
from .tag_repository import TagRepository
from .experiment_input import ExperimentInput
from .experiment_input_settings import ExperimentInputSettings
from .experiment_output_array import ExperimentOutputArray
from .experiment_output_array_first import ExperimentOutputArrayFirst
from .experiment_output import ExperimentOutput
from .experiment_patch import ExperimentPatch
from .experiment_status_experiments import ExperimentStatusExperiments
from .hyper_parameters_experiments import HyperParametersExperiments
from .hyper_parameters_experiments_inner_values_range import HyperParametersExperimentsInnerValuesRange
from .hyper_parameters_for_status_experiments import HyperParametersForStatusExperiments
from .hyper_parameters_for_status_experiments_inner import HyperParametersForStatusExperimentsInner
from .hyper_parameters_optimization_experiments import HyperParametersOptimizationExperiments
from .meta_object_experiments import MetaObjectExperiments
from .meta_object_experiments_metadata import MetaObjectExperimentsMetadata
from .metric_object_experiments import MetricObjectExperiments
from .model_version_metrics_experiments import ModelVersionMetricsExperiments
from .patch_operation_experiments import PatchOperationExperiments
from .training_output_experiments import TrainingOutputExperiments
from .training_reference_experiments import TrainingReferenceExperiments
from .training_status_experiments import TrainingStatusExperiments
from .training_status_experiments_result import TrainingStatusExperimentsResult
from .hyper_parameters import HyperParameters
from .hyper_parameters_optimization_experiments_method import HyperParametersOptimizationExperimentsMethod
from .hyper_parameters_optimization_experiments_method_parameters import HyperParametersOptimizationExperimentsMethodParameters
from .hyper_parameters_experiments_double_range import HyperParametersExperimentsDoubleRange
from .hyper_parameters_experiments_int_range import HyperParametersExperimentsIntRange
from .libraries_definition_input import LibrariesDefinitionInput
from .patch_operation_libraries import PatchOperationLibraries
from .ml_assets_patch_libraries_input import MlAssetsPatchLibrariesInput
from .ml_assets_create_libraries_output import MlAssetsCreateLibrariesOutput
from .ml_assets_create_libraries_output_array_first import MlAssetsCreateLibrariesOutputArrayFirst
from .ml_assets_create_libraries_output_array import MlAssetsCreateLibrariesOutputArray
from .ml_assets_create_patch_libraries_output import MlAssetsCreatePatchLibrariesOutput
from .runtime_output_repository import RuntimeOutputRepository
from .runtime_spec_definition_input import RuntimeSpecDefinitionInput
from .runtime_spec_definition_input_platform import RuntimeSpecDefinitionInputPlatform
from .runtime_spec_definition_input_public_libraries import RuntimeSpecDefinitionInputPublicLibraries
from .runtime_spec_definition_input_repository import RuntimeSpecDefinitionInputRepository
from .ml_assets_create_runtime_spec_output import MlAssetsCreateRuntimeSpecOutput
from .ml_assets_create_runtime_spec_output_array import MlAssetsCreateRuntimeSpecOutputArray
from .ml_assets_create_runtime_spec_output_array_first import MlAssetsCreateRuntimeSpecOutputArrayFirst
from .ml_assets_patch_runtime_spec_input import MlAssetsPatchRuntimeSpecInput
from .ml_assets_patch_runtime_spec_output import MlAssetsPatchRuntimeSpecOutput
from .patch_operation_runtime_spec import PatchOperationRuntimeSpec
from .runtime_spec_definition_input_custom_libraries import RuntimeSpecDefinitionInputCustomLibraries
from .libraries_definition_input_platform import LibrariesDefinitionInputPlatform




from .ml_assets_create_function_input import MlAssetsCreateFunctionInput
from .ml_assets_create_functions_output import MlAssetsCreateFunctionsOutput
from .meta_object_functions_metadata import MetaObjectFunctionsMetadata
from .ml_assets_create_functions_output_array import MlAssetsCreateFunctionsOutputArray
from .ml_assets_create_functions_output_array_first import MlAssetsCreateFunctionsOutputArrayFirst
from .patch_operation_functions import PatchOperationFunctions


