import { IAlarm, Metric, MetricOptions } from '@aws-cdk/aws-cloudwatch';
import { IGrantable, IPrincipal } from '@aws-cdk/aws-iam';
import { IBucket } from '@aws-cdk/aws-s3';
import { IQueue } from '@aws-cdk/aws-sqs';
import { Construct } from '@aws-cdk/core';
import { Monitoring } from '../../monitoring';
export interface IngestionProps {
    /**
     * The bucket in which ingested objects are due to be inserted.
     */
    readonly bucket: IBucket;
    /**
     * The monitoring handler to register alarms with.
     */
    readonly monitoring: Monitoring;
}
/**
 * The ingestion function receives messages from discovery integrations and
 * processes their payloads into the provided S3 Bucket.
 *
 * This function is also an `IGrantable`, so that it can be granted permissions
 * to read from the source S3 buckets.
 */
export declare class Ingestion extends Construct implements IGrantable {
    readonly grantPrincipal: IPrincipal;
    /**
     * Alarms if the dead-letter-queue associated with the ingestion process
     * is not empty, meaning some packages failed ingestion and require operator
     * attention.
     */
    readonly alarmDeadLetterQueueNotEmpty: IAlarm;
    /**
     * The SQS queue that triggers the ingestion function.
     */
    readonly queue: IQueue;
    constructor(scope: Construct, id: string, props: IngestionProps);
    metricFoundLicenseFile(opts?: MetricOptions): Metric;
    metricIneligibleLicense(opts?: MetricOptions): Metric;
    /**
     * This metrics is the total count of packages that were rejected due to
     * mismatched identity (name, version, license) between the `package.json`
     * file and te `.jsii` attribute.
     */
    metricMismatchedIdentityRejections(opts?: MetricOptions): Metric;
}
