from pathlib import Path
from setuptools import find_packages, setup

# Read the contents of README file
source_root = Path(".")
with (source_root / "README.md").open(encoding="utf-8") as f:
    long_description = f.read()

# Read the requirements
with (source_root / "requirements.txt").open(encoding="utf8") as f:
    requirements = f.readlines()

version = "0.0.11"

with (source_root / "src" / "data_quality_check" / "version.py").open(
        "w", encoding="utf-8"
) as f:
    f.writelines(
        [
            '"""This file is auto-generated by setup.py, please do not alter."""\n',
            f'__version__ = "{version}"\n',
            "",
        ]
    )

setup(
    name='data-quality-check',
    version=version,
    author='Guanlong Zhou',
    author_email='markgzhou@outlook.com',
    description='Spark data quality check tool',
    packages=find_packages("src"),
    package_dir={"": "src"},
    include_package_data=True,
    python_requires=">=3.7",
    install_requires=requirements,
    classifiers=[
        'Development Status :: 3 - Alpha',
        # Choose either "2 - Pre-Alpha", "3 - Alpha", "4 - Beta" or "5 - Production/Stable"
        "License :: OSI Approved :: MIT License",
        "Environment :: Console",
        "Operating System :: OS Independent",
        'Intended Audience :: Developers',
        "Intended Audience :: Science/Research",
        'Topic :: Software Development :: Libraries :: Python Modules',
        "Operating System :: OS Independent",
        "Framework :: IPython",
        'Programming Language :: Python :: 3'
    ],
    keywords="spark data-quality-check python jupyter ipython",
    long_description=long_description,
    long_description_content_type="text/markdown",
    entry_points={
        'console_scripts': [
            'data-quality-check=data_quality_check.controller.console:main'
        ]
    },
)
