"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const appsync = require("../lib");
const t = require("./scalar-type-defintions");
let stack;
let api;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    api = new appsync.GraphQLApi(stack, 'api', {
        name: 'api',
    });
});
describe('testing all GraphQL Types', () => {
    test('scalar type id', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.id,
            },
        }));
        const out = 'type Test {\n  id: ID\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type string', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.string,
            },
        }));
        const out = 'type Test {\n  id: String\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type int', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.int,
            },
        }));
        const out = 'type Test {\n  id: Int\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type float', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.float,
            },
        }));
        const out = 'type Test {\n  id: Float\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type boolean', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.boolean,
            },
        }));
        const out = 'type Test {\n  id: Boolean\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSDate', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsDate,
            },
        }));
        const out = 'type Test {\n  id: AWSDate\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSTime', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsTime,
            },
        }));
        const out = 'type Test {\n  id: AWSTime\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSDateTime', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsDateTime,
            },
        }));
        const out = 'type Test {\n  id: AWSDateTime\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSTimestamp', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsTimestamp,
            },
        }));
        const out = 'type Test {\n  id: AWSTimestamp\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSEmail', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsEmail,
            },
        }));
        const out = 'type Test {\n  id: AWSEmail\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSJSON', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsJson,
            },
        }));
        const out = 'type Test {\n  id: AWSJSON\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSUrl', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsUrl,
            },
        }));
        const out = 'type Test {\n  id: AWSURL\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSPhone', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsPhone,
            },
        }));
        const out = 'type Test {\n  id: AWSPhone\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('scalar type AWSIPAddress', () => {
        // WHEN
        api.addType(new appsync.ObjectType('Test', {
            definition: {
                id: t.awsIpAddress,
            },
        }));
        const out = 'type Test {\n  id: AWSIPAddress\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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