"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
require("@aws-cdk/assert/jest");
const cdk = require("@aws-cdk/core");
const appsync = require("../lib");
const t = require("./scalar-type-defintions");
let stack;
let api;
beforeEach(() => {
    // GIVEN
    stack = new cdk.Stack();
    api = new appsync.GraphQLApi(stack, 'api', {
        name: 'api',
    });
});
describe('testing InterfaceType properties', () => {
    let baseTest;
    beforeEach(() => {
        baseTest = new appsync.InterfaceType('baseTest', {
            definition: {
                id: t.id,
            },
        });
    });
    test('basic InterfaceType produces correct schema', () => {
        // WHEN
        api.addToSchema(baseTest.toString());
        const out = 'interface baseTest {\n  id: ID\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('InterfaceType fields can have arguments', () => {
        // WHEN
        baseTest.addField('test', new appsync.Field({
            returnType: t.string,
            args: { success: t.int },
        }));
        api.addToSchema(baseTest.toString());
        const out = 'interface baseTest {\n  id: ID\n  test(success: Int): String\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
    test('InterfaceType fields will not produce resolvers', () => {
        // WHEN
        baseTest.addField('test', new appsync.ResolvableField({
            returnType: t.string,
            args: { success: t.int },
            dataSource: api.addNoneDataSource('none'),
        }));
        api.addToSchema(baseTest.toString());
        const out = 'interface baseTest {\n  id: ID\n  test(success: Int): String\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
        expect(stack).not.toHaveResource('AWS::AppSync::Resolver');
    });
    test('Interface Type can be a Graphql Type', () => {
        // WHEN
        const graphqlType = baseTest.attribute();
        const test = new appsync.ObjectType('Test', {
            definition: {
                test: graphqlType,
            },
        });
        api.addToSchema(test.toString());
        const out = 'type Test {\n  test: baseTest\n}\n';
        // THEN
        expect(stack).toHaveResourceLike('AWS::AppSync::GraphQLSchema', {
            Definition: `${out}`,
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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