import { CfnGraphQLSchema } from './appsync.generated';
import { GraphQLApi } from './graphqlapi';
import { IIntermediateType } from './schema-base';
/**
 * The options for configuring a schema
 *
 * If no options are specified, then the schema will
 * be generated code-first.
 */
export interface SchemaOptions {
    /**
     * The file path for the schema. When this option is
     * configured, then the schema will be generated from an
     * existing file from disk.
     *
     * @default - schema not configured through disk asset
     */
    readonly filePath?: string;
}
/**
 * The Schema for a GraphQL Api
 *
 * If no options are configured, schema will be generated
 * code-first.
 */
export declare class Schema {
    /**
     * Generate a Schema from file
     *
     * @returns `SchemaAsset` with immutable schema defintion
     * @param filePath the file path of the schema file
     */
    static fromAsset(filePath: string): Schema;
    /**
     * The definition for this schema
     */
    definition: string;
    protected schema?: CfnGraphQLSchema;
    private mode;
    constructor(options?: SchemaOptions);
    /**
     * Called when the GraphQL Api is initialized to allow this object to bind
     * to the stack.
     *
     * @param api The binding GraphQL Api
     */
    bind(api: GraphQLApi): CfnGraphQLSchema;
    /**
     * Escape hatch to add to Schema as desired. Will always result
     * in a newline.
     *
     * @param addition the addition to add to schema
     * @param delimiter the delimiter between schema and addition
     * @default - ''
     *
     * @experimental
     */
    addToSchema(addition: string, delimiter?: string): void;
    /**
     * Add type to the schema
     *
     * @param type the intermediate type to add to the schema
     *
     * @experimental
     */
    addType(type: IIntermediateType): IIntermediateType;
}
