"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Type = exports.Directive = void 0;
/**
 * Directives for types
 *
 * i.e. @aws_iam or @aws_subscribe
 *
 * @experimental
 */
class Directive {
    constructor(statement) { this.statement = statement; }
    /**
     * Add the @aws_iam directive
     */
    static iam() {
        return new Directive('@aws_iam');
    }
    /**
     * Add a custom directive
     *
     * @param statement - the directive statement to append
     */
    static custom(statement) {
        return new Directive(statement);
    }
}
exports.Directive = Directive;
/**
 * Enum containing the Types that can be used to define ObjectTypes
 */
var Type;
(function (Type) {
    /**
     * `ID` scalar type is a unique identifier. `ID` type is serialized similar to `String`.
     *
     * Often used as a key for a cache and not intended to be human-readable.
     */
    Type["ID"] = "ID";
    /**
     * `String` scalar type is a free-form human-readable text.
     */
    Type["STRING"] = "String";
    /**
     * `Int` scalar type is a signed non-fractional numerical value.
     */
    Type["INT"] = "Int";
    /**
     * `Float` scalar type is a signed double-precision fractional value.
     */
    Type["FLOAT"] = "Float";
    /**
     * `Boolean` scalar type is a boolean value: true or false.
     */
    Type["BOOLEAN"] = "Boolean";
    /**
     * `AWSDate` scalar type represents a valid extended `ISO 8601 Date` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DD`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Calendar_dates
     */
    Type["AWS_DATE"] = "AWSDate";
    /**
     * `AWSTime` scalar type represents a valid extended `ISO 8601 Time` string.
     *
     * In other words, accepts date strings in the form of `hh:mm:ss.sss`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Times
     */
    Type["AWS_TIME"] = "AWSTime";
    /**
     * `AWSDateTime` scalar type represents a valid extended `ISO 8601 DateTime` string.
     *
     * In other words, accepts date strings in the form of `YYYY-MM-DDThh:mm:ss.sssZ`. It accepts time zone offsets.
     *
     * @see https://en.wikipedia.org/wiki/ISO_8601#Combined_date_and_time_representations
     */
    Type["AWS_DATE_TIME"] = "AWSDateTime";
    /**
     * `AWSTimestamp` scalar type represents the number of seconds since `1970-01-01T00:00Z`.
     *
     * Timestamps are serialized and deserialized as numbers.
     */
    Type["AWS_TIMESTAMP"] = "AWSTimestamp";
    /**
     * `AWSEmail` scalar type represents an email address string (i.e.`username@example.com`)
     */
    Type["AWS_EMAIL"] = "AWSEmail";
    /**
     * `AWSJson` scalar type represents a JSON string.
     */
    Type["AWS_JSON"] = "AWSJSON";
    /**
     * `AWSURL` scalar type represetns a valid URL string.
     *
     * URLs wihtout schemes or contain double slashes are considered invalid.
     */
    Type["AWS_URL"] = "AWSURL";
    /**
     * `AWSPhone` scalar type represents a valid phone number. Phone numbers maybe be whitespace delimited or hyphenated.
     *
     * The number can specify a country code at the beginning, but is not required for US phone numbers.
     */
    Type["AWS_PHONE"] = "AWSPhone";
    /**
     * `AWSIPAddress` scalar type respresents a valid `IPv4` of `IPv6` address string.
     */
    Type["AWS_IP_ADDRESS"] = "AWSIPAddress";
    /**
     * Type used for Intermediate Types
     * (i.e. an interface or an object type)
     */
    Type["INTERMEDIATE"] = "INTERMEDIATE";
})(Type = exports.Type || (exports.Type = {}));
//# sourceMappingURL=data:application/json;base64,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