import os
import time
import sys
import platform



# This project developed by Momin Iqbal 
# Support : mefiz.com
# ================================================================================================================
# Create django project quickly single command with all necessary file like djnago app, urls.py, templates folder,
# static folder and add the default code in view.py,models.py,admin.py and create index.html

# ----------------------------------------------------------------------------------------------------------------

# How to Use quick-django
# Step 1:
# 1) copy quick-django.py
# 2) past this location C:\Users\mypcname\AppData\Local\Programs\Python\Python37\Lib

# Step 2
# open cmd in your porject folder and run this command

# python -m quick-django [project name] [app name] 
# python -m quick-django myproject myproject_app 

# Check Our Site : https://mefiz.com




print(os.getcwd())
cwd = (os.getcwd())
os.chdir(cwd)

def prCyan(skk): print("\033[96m {}\033[00m" .format(skk))
def prRed(skk): print("\033[91m {}\033[00m" .format(skk))
 

projectname = sys.argv[1]
app_name = sys.argv[2]

if os.path.exists(projectname):
    prRed(f"[0]: {projectname} project name already available")
    exit()
else:
    pass


class Create:
    def html():
        return """
<!DOCTYPE html>
<html lang="en">
<head>
      <meta charset="UTF-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1.0">
      <title>mefiz.com</title>
</head>
<body>
      <h1>visit : <a href="https://mefiz.com">mefiz.com</a></h1>
</body>
</html>
        
        """
    def admin_py(app_name):
        return f"""  
from django.contrib import admin
from {app_name}.models import MyTableName
from django.contrib.auth.models import User,Group

# Remove Group and User Table in Admin Panel
# admin.site.unregister(User)
# admin.site.unregister(Group)


# View DB Table in Admin Panel
admin.site.register(MyTableName)
# ----------------------------------
# @admin.register(MyTableName)
# class MyTableName(admin.ModelAdmin):
#     list_display =  ['id','name']
        """
    def models_py():
        return """
from django.db import models


class MyTableName(models.Model):   
    name = models.CharField(max_length=255)
    class Meta:  
        db_table = "MyTableName"
    def __str__(self):
        return self.name
        
        """
    def setting_py():
        return """
# Generated by quick-django for Reference

# STATIC_URL = '/static/'
# STATIC_ROOT = 'static'

# STATICFILES_DIRS = [
#    os.path.join(BASE_DIR, "static")
# ]


# MEDIA_ROOT = os.path.join(BASE_DIR, "media")
# MEDIA_URL = '/media/'
        
        """
        
    def urls_py(django_app):
        return f"""

from django.urls import path
from {django_app} import views

urlpatterns = [
      path('',views.Home.as_view(),name=''),
]
        """
    def views_py():
        return f"""
        
from django.shortcuts import render,HttpResponse
from django.views import View



class Home(View):
    def get(self,request):
        return HttpResponse('<h1>visit : <a href="https://mefiz.com">mefiz.com</a></h1>')
        # return render(request,'index.html')
        """
    def mainurls_py(django_app):
        return f"""
from django.contrib import admin
from django.urls import path,include

urlpatterns = [
    path('admin/', admin.site.urls),
    path('', include('{django_app}.urls')),
]
        """


# Create Django Project

os.system(f'django-admin startproject {projectname}')
time.sleep(1)


if os.path.exists(projectname):
    pass
else:
    exit()

# Change Folder
os.chdir(projectname)

os.mkdir('static')
os.mkdir('media')


prCyan(f"[1]: {projectname} Project Create Successfully ......... OK ")
# Create App
if platform.system() == 'Linux':
    os.system(f'python3 manage.py startapp {app_name}')
else:
    os.system(f'python manage.py startapp {app_name}')
time.sleep(1)
prCyan(f"[2]: {app_name} App Create Successfully ......... OK ")
# Change Folder
os.chdir(projectname)

# Edit Project urls.py 
prCyan(f"[3]: Modify Project urls.py ......... OK ")
urlscode = Create.mainurls_py(app_name)
file = open("urls.py","w") 
file.write(urlscode)
file.close() 
prCyan(f"[4]: Modify Project urls.py successful ......... OK ")

# Edit Setting.py File
prCyan(f"[5]: Modify Project setting.py ......... OK ")
urlscode = Create.setting_py()
file = open("settings.py","a") 
file.write(urlscode)
file.close() 
prCyan(f"[6]: Modify Project setting.py successful ......... OK ")


os.chdir("..")

# Edit Your Django App
urlscode = Create.urls_py(app_name)
views = Create.views_py()
sample_html = Create.html()


os.chdir(app_name)

prCyan(f"[7]: Modification in {app_name} ......... OK ")
file = open("urls.py","w") 
file.write(urlscode)
file.close() 

file = open("views.py","w") 
file.write(views)
file.close() 


admin = Create.admin_py(app_name)
file = open("admin.py","w") 
file.write(admin)
file.close() 

models = Create.models_py()
file = open("models.py","w") 
file.write(models)
file.close() 

os.mkdir('templates')
os.chdir("templates")
file = open("index.html","w") 
file.write(sample_html)
file.close() 
prCyan(f"[8]: All operation successful ......... OK ")
