"""
    Configure ``setup.py`` for digicloud cli app.
"""
from setuptools import setup, find_packages


try:
    LONG_DESCRIPTION = open('README.md', 'rt').read()
except IOError:
    LONG_DESCRIPTION = ''

setup(
    name='digicloud',
    version='1.1.7',
    description='DigiCloud CLI',

    long_description=LONG_DESCRIPTION,

    author='Arash Shams',
    author_email='a.shams@digikala.com',
    url='https://digicloud.ir',
    download_url='',
    classifiers=[
        'Development Status :: 4 - Beta',
        'License :: OSI Approved :: Apache Software License',
        'Programming Language :: Python',
        'Programming Language :: Python :: 3',
        'Programming Language :: Python :: 3.5',
        'Programming Language :: Python :: 3.6',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Intended Audience :: Developers',
        'Environment :: Console',
    ],
    platforms=['Any'],
    scripts=[],
    provides=[],
    install_requires=[
        'cliff',
        'requests',
        'setuptools',
    ],
    extras_require={
        'dev': [
            'pytest==6.1.0'
        ]
    },
    packages=find_packages(exclude=["tests"]),
    include_package_data=True,
    entry_points={
        'console_scripts': [
            'digicloud = digicloud.main:main'
        ],
        'digicloud.cli': [
            'account_login = digicloud.commands.account:Login',
            'account_logout = digicloud.commands.account:Logout',
            'namespace_current = digicloud.commands.namespace:CurrentNamespace',
            'namespace_select = digicloud.commands.namespace:SelectNamespace',
            'namespace_create = digicloud.commands.namespace:CreateNamespace',
            'namespace_delete = digicloud.commands.namespace:DeleteNamespace',
            'namespace_leave = digicloud.commands.namespace:LeaveNamespace',
            'namespace_list = digicloud.commands.namespace:ListNamespace',
            'namespace_show = digicloud.commands.namespace:ShowNamespace',
            'namespace_member_list = digicloud.commands.namespace:ListNamespaceMember',
            'namespace_member_add = digicloud.commands.namespace:InviteMember',
            'namespace_invitation_accept = digicloud.commands.namespace:AcceptInvitation',
            'namespace_invitation_list = digicloud.commands.namespace:ListInvitation',
            'namespace_member_delete = digicloud.commands.namespace:DeleteNamespaceMember',
            'instance_type_list = digicloud.commands.instance_type:ListInstanceType',
            'instance_type_show = digicloud.commands.instance_type:ShowInstanceType',
            'floating_ip_list = digicloud.commands.access:ListFloatingIp',
            'floating_ip_show = digicloud.commands.access:ShowFloatingIp',
            'floating_ip_create = digicloud.commands.access:CreateFloatingIp',
            'floating_ip_delete = digicloud.commands.access:DeleteFloatingIp',
            'floating_ip_associate = digicloud.commands.access:AssociateFloatingIp',
            'floating_ip_revoke = digicloud.commands.access:RevokeFloatingIp',
            'image_list = digicloud.commands.image:ListImage',
            'image_show = digicloud.commands.image:ShowImage',
            'instance_list = digicloud.commands.instance:ListInstance',
            'instance_create = digicloud.commands.instance:CreateInstance',
            'instance_delete = digicloud.commands.instance:DeleteInstance',
            'instance_update = digicloud.commands.instance:UpdateInstance',
            'instance_start = digicloud.commands.instance:StartInstance',
            'instance_stop = digicloud.commands.instance:StopInstance',
            'instance_suspend = digicloud.commands.instance:SuspendInstance',
            'instance_resume = digicloud.commands.instance:ResumeInstance',
            'instance_reboot = digicloud.commands.instance:RebootInstance',
            'instance_show = digicloud.commands.instance:ShowInstance',
            'instance_volume_list = digicloud.commands.instance:ListInstanceVolume',
            'instance_volume_show = digicloud.commands.instance:ShowInstanceVolume',
            'instance_volume_attach = digicloud.commands.instance:AttachInstanceVolume',
            'instance_volume_detach = digicloud.commands.instance:DetachInstanceVolume',
            'instance_interface_list = digicloud.commands.instance:ListInstanceInterface',
            'instance_interface_attach = digicloud.commands.instance:AttachInterface',
            'instance_interface_detach = digicloud.commands.instance:DetachInterface',
            'instance_security_group_list = digicloud.commands.instance:ListSecurityGroup',
            'instance_security_group_add = digicloud.commands.instance:AddSecurityGroup',
            'instance_security_group_remove = digicloud.commands.instance:RemoveSecurityGroup',
            'volume_list = digicloud.commands.volume:ListVolume',
            'volume_show = digicloud.commands.volume:ShowVolume',
            'volume_delete = digicloud.commands.volume:DeleteVolume',
            'volume_create = digicloud.commands.volume:CreateVolume',
            'volume_update = digicloud.commands.volume:UpdateVolume',
            'network_list = digicloud.commands.network:ListNetwork',
            'network_show = digicloud.commands.network:ShowNetwork',
            'network_delete = digicloud.commands.network:DeleteNetwork',
            'network_create = digicloud.commands.network:CreateNetwork',
            'network_update = digicloud.commands.network:UpdateNetwork',
            'network_port_list = digicloud.commands.network:ListNetworkPorts',
            'security_group_list = digicloud.commands.security:ListSecurityGroup',
            'security_group_show = digicloud.commands.security:ShowSecurityGroup',
            'security_group_create = digicloud.commands.security:CreateSecurityGroup',
            'security_group_delete = digicloud.commands.security:DeleteSecurityGroup',
            'security_group_update = digicloud.commands.security:UpdateSecurityGroup',
            'security_group_rule_list = digicloud.commands.security:ListSecurityGroupRule',
            'security_group_rule_show = digicloud.commands.security:ShowSecurityGroupRule',
            'security_group_rule_create = digicloud.commands.security:CreateSecurityGroupRule',
            'security_group_rule_delete = digicloud.commands.security:DeleteSecurityGroupRule',
            'subnet_create = digicloud.commands.subnet:CreateSubnet',
            'subnet_list = digicloud.commands.subnet:ListSubnet',
            'subnet_show = digicloud.commands.subnet:ShowSubnet',
            'subnet_delete = digicloud.commands.subnet:DeleteSubnet',
            'subnet_update = digicloud.commands.subnet:UpdateSubnet',
            'ssh_key_list = digicloud.commands.ssh_key:ListSSHKey',
            'ssh_key_show = digicloud.commands.ssh_key:ShowSSHKey',
            'ssh_key_delete = digicloud.commands.ssh_key:DeleteSSHKey',
            'ssh_key_create = digicloud.commands.ssh_key:CreateSSHKey',
            'router_list = digicloud.commands.router:ListRouter',
            'router_show = digicloud.commands.router:ShowRouter',
            'router_update = digicloud.commands.router:UpdateRouter',
            'router_delete = digicloud.commands.router:DeleteRouter',
            'router_create = digicloud.commands.router:CreateRouter',
            'router_interface_list = digicloud.commands.router:ListRouterInterface',
            'router_interface_show = digicloud.commands.router:ShowRouterInterface',
            'router_interface_add = digicloud.commands.router:AddRouterInterface',
            'router_interface_remove = digicloud.commands.router:RemoveRouterInterface',
            'router_external_add = digicloud.commands.router:AddRouterExternal',
            'router_external_remove = digicloud.commands.router:RemoveRouterExternal',
            'router_static_list = digicloud.commands.router:ListRouterStatic',
            'router_static_add = digicloud.commands.router:AddRouterStatic',
            'router_static_delete = digicloud.commands.router:DeleteRouterStatic',
            'region_list = digicloud.commands.region:ListRegions',
            'region_select = digicloud.commands.region:SelectRegion',
            'region_current = digicloud.commands.region:CurrentRegion',
        ],
    },
    zip_safe=False,
)
