from setuptools import setup, find_packages

import ssoanalysisworker

setup(
    name='sso-analysis-worker',
    version=ssoanalysisworker.__version__,
    packages=find_packages(),
    include_package_data=True,
    description="SSO Analysis Worker for brain",
    url="https://sso-scanner-mgmt.it.hs-heilbronn.de/",
    author="Maximilian Westers",
    author_email="maximilian.westers@hs-heilbronn.de",
    install_requires=[
        "psycopg~=3.0.8",
        "requests~=2.27.1",
        "selenium~=4.1.0",
        "selenium_stealth~=1.0.6",
        "webdriver_manager~=3.5.2",
        "selenium-wire~=4.6.0",
        "pyvirtualdisplay~=3.0",
        "tldextract~=3.2.0",
        "urllib3~=1.26",
        "Pillow~=9.1.0",
        "imutils==0.5.4",
        "opencv-python==4.5.5.62",
        "numpy==1.22.2",
        "pebble==4.6.3",

    ],
    scripts=["scripts/sso-daemon", "scripts/sso-worker"]
)

with open("version.txt", 'w') as f:
    f.write(ssoanalysisworker.__version__)
    f.write("\n# This file was autogenerated by setup.cfg")
