# HyperMapper

[![Build Status](https://travis-ci.com/luinardi/hypermapper.svg?branch=master)](https://travis-ci.com/luinardi/hypermapper)

## Software and Installation
We recommend installing HyperMapper with `pip`:
```
pip install hypermapper
```

We recommend using pip version 18 or higher. Please see the wiki for the [quick start guide](https://github.com/luinardi/hypermapper/wiki) and [alternative installation](https://github.com/luinardi/hypermapper/wiki/Install-HyperMapper).

## Abstract
HyperMapper is a multi-objective black-box optimization tool based on Bayesian Optimization. 

HyperMapper was succesfully applied to real-world problems involving design search spaces with trillions of possible design choices. In particular it was applied to: 
1) Computer vision and robotics,
2) Programming language compilers and hardware design, 
3) Database management systems (DBMS) parameters configuration.

To learn about the core principles of HyperMapper refer to the papers section at the bottom. 

## Contact and Info
For any questions please contact Luigi Nardi: luigi.nardi at cs.lth.se.

## HyperMapper Slack Channel
Join the channel for a quicker communication with the dev team: 
```latex
hypermapper.slack.com
```

## License
HyperMapper is distributed under the MIT license. More information on the license can be found [here](https://github.com/luinardi/hypermapper/blob/master/LICENSE).

## People
### Main Contributors
    Artur Souza, Ph.D. student, Federal University of Minas Gerais
    Leonard Papenmeier, Ph.D. student, Lund University 
    Carl Hvarfner, Ph.D. student, Lund University
    Luigi Nardi, Assistant Professor, Lund University, and Researcher, Stanford University
### Other Contributors    
    Bruno Bodin, Assistant Professor (National University of Singapore) 
    Samuel Lundberg (Lund University)
    Alfonso White (Imperial College London)
    Adel Ejjeh, Ph.D. Student (University of Illinois at Urbana-Champaign)
    Matthias Mayr, Ph.D. Student (Lund University) 

## Papers
If you use HyperMapper in scientific publications, we would appreciate citations to the following paper: 

```
Nardi, Luigi, David Koeplinger, and Kunle Olukotun. "Practical Design Space Exploration", IEEE MASCOTS, 2019.
```

For the list of all publications (including bibtex) related to HyperMapper and its applications, see our [Publications](https://github.com/luinardi/hypermapper/wiki/Publications) page.
