# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class GetPipelineInstanceRequest(JDCloudRequest):
    """
    查询流水线执行结果及状态信息
    """

    def __init__(self, parameters, header=None, version="v1"):
        super(GetPipelineInstanceRequest, self).__init__(
            '/regions/{regionId}/pipeline/{uuid}/instance/{instanceUuid}', 'GET', header, version)
        self.parameters = parameters


class GetPipelineInstanceParameters(object):

    def __init__(self, regionId, uuid, instanceUuid, ):
        """
        :param regionId: Region ID
        :param uuid: 流水线uuid
        :param instanceUuid: 流水线uuid执行历史记录的uuid, 也可以用 latest 字符串代替uuid, 来取得最近的状态
        """

        self.regionId = regionId
        self.uuid = uuid
        self.instanceUuid = instanceUuid
        self.isSimple = None

    def setIsSimple(self, isSimple):
        """
        :param isSimple: (Optional) 流水线执行的状态，如果isSimple是true，只显示每个stage的状态, 而stage中的action状态将被忽略
        """
        self.isSimple = isSimple

