# coding=utf8

# Copyright 2018 JDCLOUD.COM
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# NOTE: This class is auto generated by the jdcloud code generator program.

from jdcloud_sdk.core.jdcloudrequest import JDCloudRequest


class UpdateLooDeviceRequest(JDCloudRequest):
    """
    修改设备详情
    """

    def __init__(self, parameters, header=None, version="v2"):
        super(UpdateLooDeviceRequest, self).__init__(
            '/regions/{regionId}/instances/{instanceId}/device/{deviceId}:looupdate', 'POST', header, version)
        self.parameters = parameters


class UpdateLooDeviceParameters(object):

    def __init__(self, instanceId, regionId, deviceId, deviceType):
        """
        :param instanceId: 设备归属的实例ID
        :param regionId: 设备归属的实例所在区域
        :param deviceId: 设备Id
        :param deviceType: 设备类型
        """

        self.instanceId = instanceId
        self.regionId = regionId
        self.deviceId = deviceId
        self.model = None
        self.manufacturer = None
        self.description = None
        self.status = None
        self.identifier = None
        self.deviceName = None
        self.deviceType = deviceType

    def setModel(self, model):
        """
        :param model: (Optional) 设备型号
        """
        self.model = model

    def setManufacturer(self, manufacturer):
        """
        :param manufacturer: (Optional) 设备厂商
        """
        self.manufacturer = manufacturer

    def setDescription(self, description):
        """
        :param description: (Optional) 设备名
        """
        self.description = description

    def setStatus(self, status):
        """
        :param status: (Optional) 设备状态
        """
        self.status = status

    def setIdentifier(self, identifier):
        """
        :param identifier: (Optional) 连接码
        """
        self.identifier = identifier

    def setDeviceName(self, deviceName):
        """
        :param deviceName: (Optional) 心跳
        """
        self.deviceName = deviceName

