import datetime

from playhouse.shortcuts import model_to_dict

from qa_data_manager.data_base_model import SkiniveInspections


class GenerateSkinive:
    def __init__(self, user):
        self._created_at = datetime.datetime.now()
        self._deleted_at = None
        self._predict = '{"uid":"ed65c346-4ed0-43aa-9c52-751db65fe0be","check_id":301391,"atlas_page_link":"https:\/\/skinive.ru\/dermatlas\/acne\/id29-acne-vulgaris\/","class":"\u0410\u043a\u043d\u0435 \u0432\u0443\u043b\u044c\u0433\u0430\u0440\u043d\u044b\u0435","class_raw":"2A_acne_vulgaris","description":"\u041d\u0430 \u0444\u043e\u0442\u043e \u0432\u0430\u0448\u0435\u0439 \u043a\u043e\u0436\u0438 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0430\u043a\u043d\u0435 (\u0443\u0433\u0440\u0438). \u041f\u043e\u043c\u0438\u043c\u043e \u043a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0434\u0435\u0444\u0435\u043a\u0442\u0430, \u044d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0438 \u043d\u0430 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0434\u0440\u0443\u0433\u0438\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0432 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043c\u0435. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u0443\u0445\u043e\u0434\u0430 \u0437\u0430 \u043a\u043e\u0436\u0435\u0439 \u0438\u043b\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u0440\u0443\u0433\u0438\u0445 \u043c\u0435\u0440. \u0427\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u043e\u0446\u0435\u043d\u043d\u0443\u044e \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044e - \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u043c\u0443 \u043a\u043e\u0441\u043c\u0435\u0442\u043e\u043b\u043e\u0433\u0443 \u0438\u043b\u0438 \u0434\u0435\u0440\u043c\u0430\u0442\u043e\u043b\u043e\u0433\u0443. \n\n\u0417\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: \n36% \u0410\u043a\u043d\u0435\n\n\u0422\u043e\u0447\u043d\u044b\u0439 \u0434\u0438\u0430\u0433\u043d\u043e\u0437: \u043f\u043e\u0441\u043b\u0435 \u0434\u0435\u0440\u043c\u0430\u0442\u043e\u0441\u043a\u043e\u043f\u0438\u0438\n\u041b\u0435\u0447\u0435\u043d\u0438\u0435: \u043a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0438 \u043c\u0435\u0434\u0438\u043a\u0430\u043c\u0435\u043d\u0442\u043e\u0437\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430 \n\u0421\u043e\u0432\u0435\u0442: \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u043a\u043e\u0441\u043c\u0435\u0442\u043e\u043b\u043e\u0433\u0443\/\u0434\u0435\u0440\u043c\u0430\u0442\u043e\u043b\u043e\u0433\u0443\n\n","colored_s3_url":"https:\/\/cdn.skiniver.com\/colored\/0\/7\/d1f653ce-7df6-48bf-bc63-e5a221fcfacb.jpg","desease":"\u0410\u043a\u043d\u0435","image_url":"https:\/\/cdn.skiniver.com\/2A_acne_vulgaris\/2f3b825bc1ce4f6dbb6aa2ea89bb3016_1081814043866.jpg","masked_s3_url":"https:\/\/cdn.skiniver.com\/masked\/0\/7\/bc8ddba1-3375-4095-a8d3-a440264bfa45.jpg","prob":36,"risk":"\u0421\u0440\u0435\u0434\u043d\u0438\u0439","risk_level":"medium","s3_url":"https:\/\/cdn.skiniver.com\/2A_acne_vulgaris\/2f3b825bc1ce4f6dbb6aa2ea89bb3016_1081814043866.jpg","short_recommendation":"\u0420\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435","topn":[{"atlas_page_link":"https:\/\/skinive.ru\/dermatlas\/acne\/id29-acne-vulgaris\/","class":"\u0410\u043a\u043d\u0435 \u0432\u0443\u043b\u044c\u0433\u0430\u0440\u043d\u044b\u0435","class_raw":"2A_acne_vulgaris","description":"\u041d\u0430 \u0444\u043e\u0442\u043e \u0432\u0430\u0448\u0435\u0439 \u043a\u043e\u0436\u0438 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0430\u043a\u043d\u0435 (\u0443\u0433\u0440\u0438). \u041f\u043e\u043c\u0438\u043c\u043e \u043a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e \u0434\u0435\u0444\u0435\u043a\u0442\u0430, \u044d\u0442\u043e \u043c\u043e\u0436\u0435\u0442 \u0443\u043a\u0430\u0437\u044b\u0432\u0430\u0442\u044c \u0438 \u043d\u0430 \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u0434\u0440\u0443\u0433\u0438\u0445 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0432 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u043c\u0435. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043a\u043e\u0440\u0440\u0435\u043a\u0446\u0438\u044f \u0443\u0445\u043e\u0434\u0430 \u0437\u0430 \u043a\u043e\u0436\u0435\u0439 \u0438\u043b\u0438 \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u0435 \u0434\u0440\u0443\u0433\u0438\u0445 \u043c\u0435\u0440. \u0427\u0442\u043e\u0431\u044b \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u043f\u043e\u043b\u043d\u043e\u0446\u0435\u043d\u043d\u0443\u044e \u043a\u043e\u043d\u0441\u0443\u043b\u044c\u0442\u0430\u0446\u0438\u044e - \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u0435\u0441\u044c \u043a \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u043c\u0443 \u043a\u043e\u0441\u043c\u0435\u0442\u043e\u043b\u043e\u0433\u0443 \u0438\u043b\u0438 \u0434\u0435\u0440\u043c\u0430\u0442\u043e\u043b\u043e\u0433\u0443. \n\n\u0417\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: \n36% \u0410\u043a\u043d\u0435\n\n\u0422\u043e\u0447\u043d\u044b\u0439 \u0434\u0438\u0430\u0433\u043d\u043e\u0437: \u043f\u043e\u0441\u043b\u0435 \u0434\u0435\u0440\u043c\u0430\u0442\u043e\u0441\u043a\u043e\u043f\u0438\u0438\n\u041b\u0435\u0447\u0435\u043d\u0438\u0435: \u043a\u043e\u0441\u043c\u0435\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0435 \u0438 \u043c\u0435\u0434\u0438\u043a\u0430\u043c\u0435\u043d\u0442\u043e\u0437\u043d\u044b\u0435 \u0441\u0440\u0435\u0434\u0441\u0442\u0432\u0430 \n\u0421\u043e\u0432\u0435\u0442: \u041e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u043a\u043e\u0441\u043c\u0435\u0442\u043e\u043b\u043e\u0433\u0443\/\u0434\u0435\u0440\u043c\u0430\u0442\u043e\u043b\u043e\u0433\u0443\n\n","desease":"\u0410\u043a\u043d\u0435","prob":0.36782804131507874,"risk_level":"medium"},{"atlas_page_link":"https:\/\/skinive.ru\/dermatlas\/benign-formations\/id13-papiloma-nevus\/","class":"\u041f\u0430\u043f\u0438\u043b\u043e\u043c\u0430\u0442\u043e\u0437\u043d\u044b\u0439 \u043d\u0435\u0432\u0443\u0441","class_raw":"1B_papiloma_nevus","description":"\u041d\u0430 \u0432\u0430\u0448\u0435\u043c \u0444\u043e\u0442\u043e \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0434\u043e\u0431\u0440\u043e\u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 \u043d\u043e\u0432\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0436\u0438. \u041d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438 \u0438 \u0443\u0433\u0440\u043e\u0437 \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044e \u043d\u0435\u0442. \u0412 \u0441\u043b\u0443\u0447\u0430\u0435 \u0442\u0440\u0430\u0432\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0433\u043e \u043d\u043e\u0432\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f, \u0438\u043b\u0438 \u043f\u0440\u0438 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0432 \u0435\u0433\u043e \u043e\u0431\u043b\u0430\u0441\u0442\u0438 - \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0434\u0435\u0440\u043c\u0430\u0442\u043e\u043b\u043e\u0433\u0443.\n\n\u0417\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: \n8% \u0414\u043e\u0431\u0440\u043e\u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u043d\u043e\u0432\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f\n\n\u0422\u043e\u0447\u043d\u044b\u0439 \u0434\u0438\u0430\u0433\u043d\u043e\u0437: \u043f\u043e\u0441\u043b\u0435 \u0434\u0435\u0440\u043c\u0430\u0442\u043e\u0441\u043a\u043e\u043f\u0438\u0438\n\u041b\u0435\u0447\u0435\u043d\u0438\u0435: \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435\/\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\n\u0421\u043e\u0432\u0435\u0442: \u041f\u043b\u0430\u043d\u043e\u0432\u044b\u0439 \u0432\u0438\u0437\u0438\u0442 \u043a \u0432\u0440\u0430\u0447\u0443\n\n","desease":"\u0414\u043e\u0431\u0440\u043e\u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u043d\u043e\u0432\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f","prob":0.08573130518198013,"risk_level":"low"},{"atlas_page_link":"https:\/\/skinive.ru\/dermatlas\/benign-formations\/id23-benign-nevus\/","class":"\u041f\u0440\u043e\u0441\u0442\u043e\u0439 \u043d\u0435\u0432\u0443\u0441","class_raw":"1B_benign_nevus","description":"\u041d\u0430 \u0432\u0430\u0448\u0435\u043c \u0444\u043e\u0442\u043e \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u0434\u043e\u0431\u0440\u043e\u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0435 \u043d\u043e\u0432\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043a\u043e\u0436\u0438. \u041d\u0430 \u0434\u0430\u043d\u043d\u044b\u0439 \u043c\u043e\u043c\u0435\u043d\u0442 \u043e\u043f\u0430\u0441\u043d\u043e\u0441\u0442\u0438 \u0438 \u0443\u0433\u0440\u043e\u0437 \u0437\u0434\u043e\u0440\u043e\u0432\u044c\u044e \u043d\u0435\u0442. \u0412 \u0441\u043b\u0443\u0447\u0430\u0435 \u0442\u0440\u0430\u0432\u043c\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u044d\u0442\u043e\u0433\u043e \u043d\u043e\u0432\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f, \u0438\u043b\u0438 \u043f\u0440\u0438 \u043f\u043e\u044f\u0432\u043b\u0435\u043d\u0438\u0438 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439 \u0432 \u0435\u0433\u043e \u043e\u0431\u043b\u0430\u0441\u0442\u0438 - \u0441\u043b\u0435\u0434\u0443\u0435\u0442 \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u043a \u0434\u0435\u0440\u043c\u0430\u0442\u043e\u043b\u043e\u0433\u0443.\n\n\u0417\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0435: \n6% \u0414\u043e\u0431\u0440\u043e\u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u043d\u043e\u0432\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f\n\n\u0422\u043e\u0447\u043d\u044b\u0439 \u0434\u0438\u0430\u0433\u043d\u043e\u0437: \u043f\u043e\u0441\u043b\u0435 \u0434\u0435\u0440\u043c\u0430\u0442\u043e\u0441\u043a\u043e\u043f\u0438\u0438\n\u041b\u0435\u0447\u0435\u043d\u0438\u0435: \u043d\u0430\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u0435\/\u0443\u0434\u0430\u043b\u0435\u043d\u0438\u0435\n\u0421\u043e\u0432\u0435\u0442: \u041f\u043b\u0430\u043d\u043e\u0432\u044b\u0439 \u0432\u0438\u0437\u0438\u0442 \u043a \u0432\u0440\u0430\u0447\u0443\n\n","desease":"\u0414\u043e\u0431\u0440\u043e\u043a\u0430\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0435 \u043d\u043e\u0432\u043e\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f","prob":0.06324855983257294,"risk_level":"low"}]}'
        self._updated_at = datetime.datetime.now()
        self._user = user.get('id')

    def with_deleted_at(self):
        self._deleted_at = datetime.datetime.now()
        return self

    def generate(self):
        skinive = SkiniveInspections(created_at=datetime.datetime.now(),
                                     deleted_at=self._deleted_at,
                                     predict=self._predict,
                                     updated_at=datetime.datetime.now(),
                                     user=self._user)

        skinive.save()
        return model_to_dict(skinive)
